/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.autoupdate.DependencyChecker;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.DuplicateWarningDialog;
import org.netbeans.modules.autoupdate.ExternalDialog;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.LicenceDialog;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Notification;
import org.netbeans.modules.autoupdate.PreparedModules;
import org.netbeans.modules.autoupdate.SelectedListCellRenderer;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.UpdateNode;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class UpdatePanel
extends JPanel {
    private static final String EMPTY_STRING = "";
    private static final Dimension PREFERRED_SIZE = new Dimension(600, 500);
    private static final String SPACE = " ";
    private static final transient HashSet acceptedLicencies = new HashSet(10);
    private ExplorerView explorerView;
    private DefaultListModel selectedListModel;
    private long totalSize;
    private Wizard.Validator validator;
    private UpdateNode.AllServers allNodes;
    private int duplicateStatus = 0;
    private PropertyChangeListener nodeListener;
    static final long serialVersionUID = 897622109141801200L;
    static final String LINE_SEPARATOR = "<br>";
    private JButton addButton;
    private JButton addallButton;
    private JLabel avLabel;
    private JTextField avTextField;
    private JEditorPane description;
    private JLabel ivLabel;
    private JTextField ivTextField;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton moreButton;
    private JLabel panel1Label;
    private JButton removeButton;
    private JButton removeallButton;
    private JLabel scrollpaneLabel;
    private JLabel totalsizeLabel;
    private JTextField totalsizeTextField;

    public UpdatePanel(Wizard.Validator validator) {
        this.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.putClientProperty("WizardPanel_contentData", new String[]{UpdatePanel.getBundle("WIZ_First"), UpdatePanel.getBundle("WIZ_Select"), UpdatePanel.getBundle("WIZ_Download"), UpdatePanel.getBundle("WIZ_View")});
        this.initComponents();
        HTMLEditorKit htmlkit = new HTMLEditorKit();
        StyleSheet css = htmlkit.getStyleSheet();
        if (css.getStyleSheets() == null) {
            StyleSheet css2 = new StyleSheet();
            Font f = this.jList1.getFont();
            int size = this.jList1.getFont().getSize();
            css2.addRule("body { font-size: " + size + "; font-family: " + f.getName() + "; }");
            css2.addStyleSheet(css);
            htmlkit.setStyleSheet(css2);
        }
        this.description.setEditorKit(htmlkit);
        this.setName(UpdatePanel.getBundle("LAB_Select2"));
        this.validator = validator;
        this.explorerView = new ExplorerView();
        this.explorerView.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "selectedNodes") {
                    UpdatePanel.this.selectionChange(true);
                }
            }
        });
        this.jList1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                UpdatePanel.this.unselectLeft();
                if (UpdatePanel.this.jList1.getSelectedIndex() == -1 && UpdatePanel.this.selectedListModel.getSize() > 0) {
                    UpdatePanel.this.jList1.setSelectedIndex(0);
                }
            }

            public void focusLost(FocusEvent evt) {
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.insets = new Insets(0, 3, 0, 3);
        this.jPanel1.add((Component)this.explorerView, gridBagConstraints1);
        this.jList1.setCellRenderer(new SelectedListCellRenderer());
        this.selectedListModel = new DefaultListModel();
        this.jList1.setModel(this.selectedListModel);
        this.jList1.getSelectionModel().setSelectionMode(2);
        this.jList1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                UpdatePanel.this.selectionChange(false);
            }
        });
        this.panel1Label.setLabelFor(this.explorerView);
        this.getAccessibleContext().setAccessibleName(UpdatePanel.getBundle("ACS_UpdatePanel"));
        this.getAccessibleContext().setAccessibleDescription(UpdatePanel.getBundle("ACSD_UpdatePanel") + UpdatePanel.getBundle("LAB_227"));
        this.moreButton.getAccessibleContext().setAccessibleDescription(UpdatePanel.getBundle("ACS_More"));
        this.jList1.getAccessibleContext().setAccessibleDescription(UpdatePanel.getBundle("ACS_InstallList"));
        this.explorerView.setName(UpdatePanel.getBundle("ACSN_ExplorerView"));
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    private void initComponents() {
        this.panel1Label = new JLabel();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addallButton = new JButton();
        this.removeallButton = new JButton();
        this.scrollpaneLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel3 = new JPanel();
        this.totalsizeLabel = new JLabel();
        this.totalsizeTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.avLabel = new JLabel();
        this.avTextField = new JTextField();
        this.ivLabel = new JLabel();
        this.ivTextField = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.description = new JEditorPane();
        this.moreButton = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.panel1Label, (String)UpdatePanel.getBundle("LAB_221"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.panel1Label, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)UpdatePanel.getBundle("BTN_Add_2"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdatePanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 12, 0, 12);
        this.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)UpdatePanel.getBundle("BTN_Remove_2"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdatePanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addallButton, (String)UpdatePanel.getBundle("BTN_AddAll_2"));
        this.addallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdatePanel.this.addallButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.addallButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeallButton, (String)UpdatePanel.getBundle("BTN_RemoveAll_2"));
        this.removeallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdatePanel.this.removeallButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.removeallButton, gridBagConstraints);
        this.scrollpaneLabel.setLabelFor(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.scrollpaneLabel, (String)UpdatePanel.getBundle("LAB_222"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.scrollpaneLabel, gridBagConstraints);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                UpdatePanel.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel3.setLayout(new GridLayout(1, 2, 6, 0));
        this.totalsizeLabel.setHorizontalAlignment(4);
        this.totalsizeLabel.setLabelFor(this.totalsizeTextField);
        Mnemonics.setLocalizedText((JLabel)this.totalsizeLabel, (String)UpdatePanel.getBundle("LAB_223"));
        this.jPanel3.add(this.totalsizeLabel);
        this.totalsizeTextField.setEditable(false);
        this.totalsizeTextField.setDisabledTextColor(Color.black);
        this.totalsizeTextField.setEnabled(false);
        this.totalsizeTextField.setMinimumSize(new Dimension(6, 20));
        this.jPanel3.add(this.totalsizeTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.avLabel.setLabelFor(this.avTextField);
        Mnemonics.setLocalizedText((JLabel)this.avLabel, (String)UpdatePanel.getBundle("LAB_224"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.jPanel2.add((Component)this.avLabel, gridBagConstraints);
        this.avTextField.setEditable(false);
        this.avTextField.setDisabledTextColor(Color.black);
        this.avTextField.setEnabled(false);
        this.avTextField.setMinimumSize(new Dimension(60, 21));
        this.avTextField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.jPanel2.add((Component)this.avTextField, gridBagConstraints);
        this.ivLabel.setLabelFor(this.ivTextField);
        Mnemonics.setLocalizedText((JLabel)this.ivLabel, (String)UpdatePanel.getBundle("LAB_225"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.jPanel2.add((Component)this.ivLabel, gridBagConstraints);
        this.ivTextField.setEditable(false);
        this.ivTextField.setDisabledTextColor(Color.black);
        this.ivTextField.setEnabled(false);
        this.ivTextField.setMinimumSize(new Dimension(60, 21));
        this.ivTextField.setPreferredSize(new Dimension(63, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.jPanel2.add((Component)this.ivTextField, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(22, 52));
        this.description.setEditable(false);
        this.jScrollPane2.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 4, 0);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moreButton, (String)UpdatePanel.getBundle("BTN_More"));
        this.moreButton.setHorizontalTextPosition(0);
        this.moreButton.setIconTextGap(0);
        this.moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdatePanel.this.moreButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(6, 11, 4, 4);
        this.jPanel2.add((Component)this.moreButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void moreButtonActionPerformed(ActionEvent evt) {
        ModuleUpdate mu = this.getSingleSelection();
        if (mu != null && mu.getHomePage() != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(mu.getHomePage());
        }
    }

    private void removeallButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            ((ModuleUpdate)this.selectedListModel.get(i)).setSelected(false);
            ((ModuleUpdate)this.selectedListModel.get(i)).setDownloadOK(false);
            ((ModuleUpdate)this.selectedListModel.get(i)).setSecurity(-1);
        }
        this.refreshNodes();
        this.selectedListModel.clear();
        Downloader.deleteDownload();
        this.showSize();
        this.validator.setValid(this.selectedListModel.size() > 0);
        this.buttonsCheck();
    }

    private void addallButtonActionPerformed(ActionEvent evt) {
        Collection modules = Wizard.getAllModules();
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            if (this.addModule((ModuleUpdate)it.next())) continue;
            this.removeallButtonActionPerformed(evt);
            return;
        }
        this.buttonsCheck();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] index = this.jList1.getSelectedIndices();
        if (index.length == 0) {
            return;
        }
        ArrayList toremove = new ArrayList();
        for (int i = index.length - 1; i >= 0; --i) {
            toremove.add(this.selectedListModel.get(index[i]));
        }
        Iterator it = toremove.iterator();
        while (it.hasNext()) {
            this.removeModule((ModuleUpdate)it.next());
        }
        this.refreshNodes();
        this.showSize();
        this.validator.setValid(this.selectedListModel.size() > 0);
        this.buttonsCheck();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = this.explorerView.getSelectedNodes();
        ArrayList<ModuleUpdate> modulesToAdd = new ArrayList<ModuleUpdate>();
        ModuleUpdate mu = null;
        for (int i = 0; i < nodes.length; ++i) {
            mu = (ModuleUpdate)nodes[i].getCookie(class$org$netbeans$modules$autoupdate$ModuleUpdate == null ? UpdatePanel.class$("org.netbeans.modules.autoupdate.ModuleUpdate") : class$org$netbeans$modules$autoupdate$ModuleUpdate);
            if (mu != null) {
                modulesToAdd.add(mu);
                continue;
            }
            modulesToAdd.addAll(this.getUnselectedChildren(nodes[i]));
        }
        Iterator iter = modulesToAdd.iterator();
        while (iter.hasNext()) {
            mu = (ModuleUpdate)iter.next();
            if (this.addModule(mu, modulesToAdd)) continue;
            return;
        }
        this.buttonsCheck();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int index = this.jList1.locationToIndex(evt.getPoint());
            if (index >= 0 && index < this.selectedListModel.size()) {
                this.removeModule((ModuleUpdate)this.selectedListModel.get(index));
                this.showSize();
                this.validator.setValid(this.selectedListModel.size() > 0);
                this.refreshNodes();
            }
            this.buttonsCheck();
        }
    }

    void setUpdates(int wizardType) {
        boolean firstTime = true;
        this.allNodes = null;
        this.selectedListModel.clear();
        this.totalSize = 0L;
        Iterator it = Wizard.getAllModules().iterator();
        while (it.hasNext()) {
            ModuleUpdate mu = (ModuleUpdate)it.next();
            if (mu.isSelected() && !this.selectedListModel.contains(mu)) {
                this.selectedListModel.addElement(mu);
                this.totalSize += mu.getDownloadSize();
            }
            if (!firstTime || wizardType != 1 && !mu.isPurchased()) continue;
            this.addModule(mu);
        }
        this.validator.setValid(this.selectedListModel.size() > 0);
        this.totalsizeTextField.setText(this.totalSize / 1024L + SPACE + UpdatePanel.getBundle("CTL_UpdatePanel_KB"));
        this.buttonsCheck();
        this.showSize();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpdatePanel.this.refreshNodes();
            }
        });
        this.nodeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ModuleUpdate mu;
                Node[] selectedNodes;
                if ("nodeDefaultAction".equals(evt.getPropertyName()) && (selectedNodes = UpdatePanel.this.explorerView.getSelectedNodes()).length == 1 && (mu = (ModuleUpdate)selectedNodes[0].getCookie(class$org$netbeans$modules$autoupdate$ModuleUpdate == null ? (class$org$netbeans$modules$autoupdate$ModuleUpdate = UpdatePanel.class$("org.netbeans.modules.autoupdate.ModuleUpdate")) : class$org$netbeans$modules$autoupdate$ModuleUpdate)) != null && !UpdatePanel.this.addModule(mu)) {
                    UpdatePanel.this.buttonsCheck();
                }
            }
        };
        Settings.getShared().addPropertyChangeListener(this.nodeListener);
    }

    private ModuleUpdate getSingleSelection() {
        if (this.jList1.getSelectedIndex() >= 0) {
            return (ModuleUpdate)this.selectedListModel.get(this.jList1.getSelectedIndex());
        }
        Node[] selectedNodes = this.explorerView.getSelectedNodes();
        if (selectedNodes.length != 1) {
            return null;
        }
        return (ModuleUpdate)selectedNodes[0].getCookie(ModuleUpdate.class);
    }

    private void unselectLeft() {
        try {
            this.explorerView.getExplorerManager().setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private String formatDescription(ModuleUpdate mu) {
        Date date = mu.getReleaseDate();
        String release = date != null ? ModuleUpdate.DATE_FORMAT.format(date) : EMPTY_STRING;
        String author = mu.getModuleAuthor() == null ? EMPTY_STRING : mu.getModuleAuthor();
        String desc = UpdatePanel.getBundle("LAB_226") + SPACE + mu.getDownloadSize() / 1024L + SPACE + UpdatePanel.getBundle("CTL_UpdatePanel_KB") + LINE_SEPARATOR + (author.length() == 0 ? EMPTY_STRING : UpdatePanel.getBundle("LAB_AuthorName") + SPACE + author + LINE_SEPARATOR) + (release.length() == 0 ? EMPTY_STRING : UpdatePanel.getBundle("LAB_ReleaseDate") + SPACE + release + LINE_SEPARATOR) + mu.getDescription();
        return desc;
    }

    private void selectionChange(boolean onLeft) {
        ModuleUpdate mu;
        if (onLeft && this.explorerView.getSelectedNodes().length > 0) {
            this.jList1.clearSelection();
        }
        if ((mu = this.getSingleSelection()) == null) {
            this.ivTextField.setText(EMPTY_STRING);
            this.avTextField.setText(EMPTY_STRING);
            this.description.setText(EMPTY_STRING);
        } else {
            this.ivTextField.setText(mu.getLocalModule() == null ? UpdatePanel.getBundle("CTL_UpdatePanel_ModuleNotInstalled") : (mu.getLocalModule().getSpecificationVersion() == null ? EMPTY_STRING : mu.getLocalModule().getSpecificationVersion().toString()));
            SpecificationVersion sv = mu.getRemoteModule().getSpecificationVersion();
            this.avTextField.setText(sv == null ? EMPTY_STRING : sv.toString());
            this.description.setText(this.formatDescription(mu));
            this.description.setCaretPosition(0);
        }
        this.buttonsCheck();
    }

    private void buttonsCheck() {
        if (this.selectedListModel.getSize() > 0) {
            this.removeallButton.setEnabled(true);
            if (this.jList1.getSelectedIndex() != -1) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        } else {
            this.removeButton.setEnabled(false);
            this.removeallButton.setEnabled(false);
        }
        if (this.existUnselectedModule()) {
            this.addallButton.setEnabled(true);
            if (this.isLeftSelection()) {
                this.addButton.setEnabled(true);
            } else {
                this.addButton.setEnabled(false);
            }
        } else {
            this.addButton.setEnabled(false);
            this.addallButton.setEnabled(false);
        }
        ModuleUpdate mu = this.getSingleSelection();
        this.moreButton.setEnabled(mu != null && mu.getHomePage() != null);
    }

    private boolean isLeftSelection() {
        Node[] selectedNodes = this.explorerView.getSelectedNodes();
        for (int i = 0; i < selectedNodes.length; ++i) {
            if (selectedNodes[i].getCookie(class$org$netbeans$modules$autoupdate$ModuleUpdate == null ? UpdatePanel.class$("org.netbeans.modules.autoupdate.ModuleUpdate") : class$org$netbeans$modules$autoupdate$ModuleUpdate) != null) {
                return true;
            }
            List lst = this.getUnselectedChildren(selectedNodes[i]);
            if (lst.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List getUnselectedChildren(Node group) {
        Node[] nodes = group.getChildren().getNodes();
        ArrayList<ModuleUpdate> modlist = new ArrayList<ModuleUpdate>();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].getCookie(class$org$netbeans$modules$autoupdate$ModuleUpdate == null ? UpdatePanel.class$("org.netbeans.modules.autoupdate.ModuleUpdate") : class$org$netbeans$modules$autoupdate$ModuleUpdate) != null) {
                ModuleUpdate mu = (ModuleUpdate)nodes[i].getCookie(class$org$netbeans$modules$autoupdate$ModuleUpdate == null ? UpdatePanel.class$("org.netbeans.modules.autoupdate.ModuleUpdate") : class$org$netbeans$modules$autoupdate$ModuleUpdate);
                if (mu.isSelected()) continue;
                modlist.add(mu);
                continue;
            }
            List lst = this.getUnselectedChildren(nodes[i]);
            if (lst.size() <= 0) continue;
            modlist.addAll(lst);
        }
        return modlist;
    }

    private boolean addModule(ModuleUpdate mu) {
        return this.addModule(mu, null);
    }

    private boolean addModule(ModuleUpdate mu, List group) {
        return this.addModule(mu, group, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addModule(ModuleUpdate mu, List group, boolean askForDuplicates) {
        List ext_list;
        if (this.selectedListModel.contains(mu)) {
            return true;
        }
        String prepSpecVersion = PreparedModules.getPrepared().getPreparedVersion(mu.getCodeNameBase());
        if (prepSpecVersion != null) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)UpdatePanel.class, (String)"MSG_Prepared_Module", (Object)mu.getName(), (Object)prepSpecVersion), UpdatePanel.getBundle("CTL_Prepared_Title"), 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) return true;
            PreparedModules.getPrepared().removeModule(mu.getCodeNameBase());
        }
        boolean remove = false;
        for (int j = 0; j < this.selectedListModel.size(); ++j) {
            ModuleUpdate mu2 = (ModuleUpdate)this.selectedListModel.get(j);
            String loc = null;
            if (mu instanceof L10NUpdate) {
                loc = ((L10NUpdate)mu).getLangcode();
            }
            loc = loc == null ? EMPTY_STRING : loc;
            String loc2 = null;
            if (mu2 instanceof L10NUpdate) {
                loc2 = ((L10NUpdate)mu2).getLangcode();
            }
            String string = loc2 = loc2 == null ? EMPTY_STRING : loc2;
            if (mu2.getCodeNameBase().equals(mu.getCodeNameBase()) && loc2.equals(loc)) {
                if (askForDuplicates) {
                    if (this.duplicateStatus == 1) {
                        remove = true;
                    } else {
                        if (this.duplicateStatus == 3) {
                            return true;
                        }
                        Dialog warnDialog = DuplicateWarningDialog.getDialog(mu.getName());
                        warnDialog.setVisible(true);
                        this.duplicateStatus = DuplicateWarningDialog.getResult();
                        if (this.duplicateStatus != 0 && this.duplicateStatus != 1) return true;
                        remove = true;
                    }
                } else {
                    remove = true;
                }
            }
            if (!remove) continue;
            this.removeModule(mu2, mu);
            break;
        }
        if (mu.getNotification() != null && mu.getNotification().length() > 0 && !mu.getNotificationAccepted()) {
            if (!Notification.performModuleNotification(mu.getNotification())) return false;
            mu.setNotificationAccepted(true);
        }
        if ((ext_list = mu.getExternals()) != null) {
            Iterator it = ext_list.iterator();
            while (it.hasNext()) {
                ExternalDialog.showExternal(mu.getName(), (ModuleUpdate.External)it.next());
            }
        }
        DependencyChecker dc = new DependencyChecker();
        StringBuffer dontAddModuleName = new StringBuffer();
        Collection modulesToAdd = dc.modulesToAdd(mu, this.selectedListModel.elements(), group, dontAddModuleName);
        if (dontAddModuleName.length() > 0) {
            return false;
        }
        this.selectedListModel.add(this.findPosition(mu), mu);
        Iterator it = modulesToAdd.iterator();
        while (it.hasNext()) {
            ModuleUpdate addMu = (ModuleUpdate)it.next();
            if (this.addModule(addMu, null, false)) continue;
            this.selectedListModel.removeElement(mu);
            this.totalSize += mu.getDownloadSize();
            return false;
        }
        this.showSize();
        this.validator.setValid(this.selectedListModel.size() > 0);
        this.jList1.revalidate();
        mu.setSelected(true);
        this.refreshNodes();
        return true;
    }

    boolean checkLicencies() {
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            ModuleUpdate mu = (ModuleUpdate)this.selectedListModel.get(i);
            if (mu.getLicenceText() == null || mu.getLicenceID() == null || acceptedLicencies.contains(mu.getLicenceID())) continue;
            if (LicenceDialog.acceptLicence(mu.getLicenceText())) {
                acceptedLicencies.add(mu.getLicenceID());
                continue;
            }
            return false;
        }
        return true;
    }

    private int findPosition(ModuleUpdate mu) {
        int pos = 0;
        Collection modules = Wizard.getAllModules();
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            ModuleUpdate imu = (ModuleUpdate)it.next();
            if (mu == imu) {
                return pos;
            }
            if (!this.selectedListModel.contains(imu)) continue;
            ++pos;
        }
        return pos;
    }

    private void removeModule(ModuleUpdate mu) {
        this.removeModule(mu, null);
    }

    private void removeModule(ModuleUpdate mu, ModuleUpdate toReplace) {
        if (!this.selectedListModel.contains(mu)) {
            return;
        }
        int index = this.selectedListModel.indexOf(mu);
        this.totalSize -= mu.getDownloadSize();
        this.selectedListModel.remove(index);
        if (mu.isDownloadStarted()) {
            Downloader.deleteModuleNBM(mu);
        }
        DependencyChecker dc = new DependencyChecker();
        Collection modulesToRemove = dc.modulesToRemove(mu, toReplace);
        Iterator it = modulesToRemove.iterator();
        while (it.hasNext()) {
            ModuleUpdate removeMu = (ModuleUpdate)it.next();
            this.removeModule(removeMu);
        }
        mu.setSelected(false);
        mu.setDownloadOK(false);
        mu.setSecurity(-1);
    }

    void showSize() {
        this.totalSize = 0L;
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            if (((ModuleUpdate)this.selectedListModel.get(i)).isDownloadOK()) continue;
            this.totalSize += ((ModuleUpdate)this.selectedListModel.get(i)).getDownloadSize();
        }
        this.totalsizeTextField.setText(this.totalSize / 1024L + SPACE + UpdatePanel.getBundle("CTL_UpdatePanel_KB"));
    }

    int modulesToDownload() {
        int result = 0;
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            if (((ModuleUpdate)this.selectedListModel.get(i)).isDownloadOK() && !((ModuleUpdate)this.selectedListModel.get(i)).isNotChecked()) continue;
            ++result;
        }
        return result;
    }

    private boolean existUnselectedModule() {
        Collection modules = Wizard.getAllModules();
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            if (((ModuleUpdate)it.next()).isSelected()) continue;
            return true;
        }
        return false;
    }

    void markSelectedModules() {
        Collection modules = Wizard.getAllModules();
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            ((ModuleUpdate)it.next()).setSelected(false);
        }
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            ((ModuleUpdate)this.selectedListModel.get(i)).setSelected(true);
        }
    }

    private void refreshNodes() {
        if (this.allNodes == null) {
            this.allNodes = UpdateNode.getAllServers();
            this.explorerView.getExplorerManager().setRootContext((Node)this.allNodes);
            this.explorerView.expandAll();
            Runnable makeVisible = new Runnable(){

                public void run() {
                    if (!UpdatePanel.this.allNodes.isLeaf()) {
                        UpdatePanel.this.explorerView.getExplorerManager().setExploredContext(UpdatePanel.this.allNodes.getChildren().getNodes()[0]);
                    }
                }
            };
            RequestProcessor.getDefault().post(makeVisible, 300);
        } else {
            this.allNodes.refreshContent(true);
        }
    }

    void removeListeners() {
        if (this.nodeListener != null) {
            Settings.getShared().removePropertyChangeListener(this.nodeListener);
        }
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage((Class)UpdatePanel.class, (String)key);
    }

    static class ExplorerView
    extends JComponent
    implements ExplorerManager.Provider {
        private ExplorerManager em;
        private BeanTreeView btv;
        static final long serialVersionUID = -5811911993587966912L;

        ExplorerView() {
            UpdateNode.Wait waitNode = new UpdateNode.Wait();
            this.createContent((Node)waitNode);
        }

        private void createContent(Node node) {
            this.btv = new BeanTreeView();
            this.btv.setPopupAllowed(false);
            this.btv.setDefaultActionAllowed(true);
            this.btv.setBorder(UIManager.getBorder("ScrollPane.border"));
            this.setLayout(new BorderLayout());
            this.add("Center", (Component)this.btv);
            this.getExplorerManager().setRootContext(node);
            this.btv.setRootVisible(false);
        }

        public Dimension getPreferredSize() {
            Dimension sup = super.getPreferredSize();
            return new Dimension(Math.max(sup.width, 450), Math.max(sup.height, 300));
        }

        void expandAll() {
            this.expandChildren(this.getExplorerManager().getRootContext());
        }

        public void addNotify() {
            super.addNotify();
            this.btv.requestFocus();
        }

        private void expandChildren(Node n) {
            Node[] kids = n.getChildren().getNodes();
            for (int i = 0; i < kids.length; ++i) {
                if (kids[i].getDisplayName().startsWith("L10N")) continue;
                this.btv.expandNode(kids[i]);
                if (kids[i].getChildren() == Children.LEAF) continue;
                this.expandChildren(kids[i]);
            }
        }

        Node[] getSelectedNodes() {
            return this.getExplorerManager().getSelectedNodes();
        }

        public ExplorerManager getExplorerManager() {
            if (this.em == null) {
                this.em = new ExplorerManager();
            }
            return this.em;
        }
    }
}

