/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.earproject.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.j2ee.earproject.ui.customizer.LibrariesChooser;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClassPathItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VisualArchiveIncludesSupport {
    final Project master;
    final String j2eePlatform;
    final JTable classpathTable;
    final JButton addJarButton;
    final JButton addLibraryButton;
    final JButton addArtifactButton;
    final JButton removeButton;
    private final ClasspathTableModel classpathModel;
    private Object[][] data;
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>();

    public VisualArchiveIncludesSupport(Project master, String j2eePlatform, JTable classpathTable, JButton addJarButton, JButton addLibraryButton, JButton addArtifactButton, JButton removeButton) {
        this.classpathTable = classpathTable;
        this.classpathModel = new ClasspathTableModel();
        this.classpathTable.setModel(this.classpathModel);
        this.classpathTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(VisualArchiveIncludesSupport.class, (String)"TXT_Archive_Item"));
        this.classpathTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(VisualArchiveIncludesSupport.class, (String)"TXT_Archive_PathInArchive"));
        this.classpathTable.getColumnModel().getColumn(0).setCellRenderer(new ClassPathCellRenderer());
        this.classpathTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null) {
                    this.setToolTipText(value.toString());
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.classpathTable.setSelectionMode(2);
        this.addJarButton = addJarButton;
        this.addLibraryButton = addLibraryButton;
        this.addArtifactButton = addArtifactButton;
        this.removeButton = removeButton;
        this.master = master;
        this.j2eePlatform = j2eePlatform;
        ClasspathSupportListener csl = new ClasspathSupportListener();
        addJarButton.addActionListener(csl);
        addLibraryButton.addActionListener(csl);
        addArtifactButton.addActionListener(csl);
        removeButton.addActionListener(csl);
        classpathTable.getSelectionModel().addListSelectionListener(csl);
        this.classpathModel.addTableModelListener(csl);
        csl.valueChanged(null);
    }

    public void setVisualWarItems(List<VisualClassPathItem> items) {
        Object[][] data = new Object[items.size()][2];
        this.data = data;
        for (int i = 0; i < items.size(); ++i) {
            this.classpathModel.setValueAt(items.get(i), i, 0);
            String pathInWAR = items.get(i).getPathInEAR();
            this.classpathModel.setValueAt(pathInWAR, i, 1);
        }
        this.classpathModel.fireTableDataChanged();
    }

    public List<VisualClassPathItem> getVisualWarItems() {
        ArrayList<VisualClassPathItem> items = new ArrayList<VisualClassPathItem>();
        for (int i = 0; i < this.data.length; ++i) {
            items.add((VisualClassPathItem)this.classpathModel.getValueAt(i, 0));
        }
        return items;
    }

    public void addTableModelListener(TableModelListener tml) {
        this.classpathModel.addTableModelListener(tml);
    }

    public void removeTableModelListener(TableModelListener tml) {
        this.classpathModel.removeTableModelListener(tml);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed() {
        ArrayList<ActionListener> listeners;
        VisualArchiveIncludesSupport visualArchiveIncludesSupport = this;
        synchronized (visualArchiveIncludesSupport) {
            listeners = new ArrayList<ActionListener>(this.actionListeners);
        }
        ActionEvent ae = new ActionEvent(this, 0, null);
        for (ActionListener al : listeners) {
            al.actionPerformed(ae);
        }
    }

    private Collection<Object> getLibraries() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (VisualClassPathItem vcpi : this.getVisualWarItems()) {
            if (vcpi.getType() != VisualClassPathItem.Type.LIBRARY) continue;
            list.add(vcpi.getObject());
        }
        return list;
    }

    private void addLibraries(Library[] libraries) {
        if (libraries.length > 0) {
            ArrayList<Library> newLibList = new ArrayList<Library>(Arrays.asList(libraries));
            this.classpathTable.clearSelection();
            int n0 = this.data.length;
            for (int i = 0; i < n0; ++i) {
                VisualClassPathItem item = (VisualClassPathItem)this.data[i][0];
                if (item.getType() != VisualClassPathItem.Type.LIBRARY || !newLibList.remove(item.getObject())) continue;
                this.classpathTable.addRowSelectionInterval(i, i);
            }
            int n = newLibList.size();
            if (n > 0) {
                int i;
                Object[][] newData = new Object[n0 + n][2];
                for (i = 0; i < n0; ++i) {
                    newData[i] = this.data[i];
                }
                for (i = 0; i < n; ++i) {
                    Library library = (Library)newLibList.get(i);
                    VisualClassPathItem item = VisualClassPathItem.createLibrary(library);
                    newData[n0 + i][0] = item;
                    newData[n0 + i][1] = "/";
                }
                this.data = newData;
                this.classpathModel.fireTableRowsInserted(n0, n0 + n - 1);
                this.classpathTable.addRowSelectionInterval(n0, n0 + n - 1);
            }
            this.fireActionPerformed();
        }
    }

    private void addJarFiles(File[] files) {
        int i;
        Object[][] newData = new Object[this.data.length + files.length][2];
        for (i = 0; i < this.data.length; ++i) {
            newData[i] = this.data[i];
        }
        for (i = 0; i < files.length; ++i) {
            VisualClassPathItem jarFile = VisualClassPathItem.createJAR(files[i]);
            newData[this.data.length + i][0] = jarFile;
            newData[this.data.length + i][1] = jarFile.getPathInEAR();
        }
        this.data = newData;
        this.classpathModel.fireTableRowsInserted(this.data.length, this.data.length + files.length - 1);
        this.fireActionPerformed();
    }

    private void addArtifacts(AntArtifact[] artifacts) {
        int i;
        Object[][] newData = new Object[this.data.length + artifacts.length][2];
        for (i = 0; i < this.data.length; ++i) {
            newData[i] = this.data[i];
        }
        for (i = 0; i < artifacts.length; ++i) {
            VisualClassPathItem vcpi = VisualClassPathItem.createArtifact(artifacts[i]);
            newData[this.data.length + i][0] = vcpi;
            newData[this.data.length + i][1] = vcpi.getPathInEAR();
        }
        this.data = newData;
        this.classpathModel.fireTableRowsInserted(this.data.length, this.data.length + artifacts.length - 1);
        this.fireActionPerformed();
    }

    private void removeElements() {
        ListSelectionModel sm = this.classpathTable.getSelectionModel();
        int index = sm.getMinSelectionIndex();
        if (sm.isSelectionEmpty()) assert (false) : "Remove button should be disabled";
        ArrayList<Object[]> elements = new ArrayList<Object[]>();
        int n0 = this.data.length;
        for (int i = 0; i < n0; ++i) {
            if (sm.isSelectedIndex(i)) continue;
            elements.add(this.data[i]);
        }
        int n = elements.size();
        this.data = (Object[][])elements.toArray((T[])new Object[n][2]);
        this.classpathModel.fireTableRowsDeleted(elements.size(), n0 - 1);
        if (index >= n) {
            index = n - 1;
        }
        sm.setSelectionInterval(index, index);
        this.fireActionPerformed();
    }

    class ClasspathTableModel
    extends AbstractTableModel {
        ClasspathTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (VisualArchiveIncludesSupport.this.data == null) {
                return 0;
            }
            return VisualArchiveIncludesSupport.this.data.length;
        }

        public Object getValueAt(int row, int col) {
            return VisualArchiveIncludesSupport.this.data[row][col];
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public void setValueAt(Object value, int row, int col) {
            ((VisualArchiveIncludesSupport)VisualArchiveIncludesSupport.this).data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    private static class ClassPathCellRenderer
    extends DefaultTableCellRenderer {
        private ClassPathCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof VisualClassPathItem) {
                VisualClassPathItem item = (VisualClassPathItem)value;
                this.setIcon(item.getIcon());
            }
            String s = value == null ? null : value.toString();
            return super.getTableCellRendererComponent(table, s, isSelected, false, row, column);
        }
    }

    private class ClasspathSupportListener
    implements ActionListener,
    ListSelectionListener,
    TableModelListener {
        private ClasspathSupportListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == VisualArchiveIncludesSupport.this.addJarButton) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                chooser.setMultiSelectionEnabled(true);
                chooser.setDialogTitle(NbBundle.getMessage(VisualArchiveIncludesSupport.class, (String)"LBL_CustomizeCompile_Classpath_AddJar_JButton"));
                chooser.setAcceptAllFileFilterUsed(false);
                int option = chooser.showOpenDialog(null);
                if (option == 0) {
                    File[] files = chooser.getSelectedFiles();
                    VisualArchiveIncludesSupport.this.addJarFiles(files);
                }
            } else if (source == VisualArchiveIncludesSupport.this.addLibraryButton) {
                LibrariesChooser panel = new LibrariesChooser(VisualArchiveIncludesSupport.this.getLibraries(), VisualArchiveIncludesSupport.this.j2eePlatform);
                Object[] options = new Object[]{NbBundle.getMessage(VisualArchiveIncludesSupport.class, (String)"LBL_AddLibrary"), DialogDescriptor.CANCEL_OPTION};
                DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(VisualArchiveIncludesSupport.class, (String)"LBL_CustomizeCompile_Classpath_AddLibrary"), true, options, options[0], 0, null, null);
                Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
                dlg.setVisible(true);
                if (desc.getValue() == options[0]) {
                    VisualArchiveIncludesSupport.this.addLibraries(panel.getSelectedLibraries());
                }
                dlg.dispose();
            } else if (source == VisualArchiveIncludesSupport.this.addArtifactButton) {
                AntArtifact[] artifacts = AntArtifactChooser.showDialog(VisualArchiveIncludesSupport.this.master, new String[]{"j2ee_ear_archive", "j2ee_ear_archive", "jar"});
                if (artifacts != null) {
                    VisualArchiveIncludesSupport.this.addArtifacts(artifacts);
                }
            } else if (source == VisualArchiveIncludesSupport.this.removeButton) {
                VisualArchiveIncludesSupport.this.removeElements();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            VisualClassPathItem vcpi;
            boolean remove;
            DefaultListSelectionModel sm = (DefaultListSelectionModel)VisualArchiveIncludesSupport.this.classpathTable.getSelectionModel();
            int index = sm.getMinSelectionIndex();
            boolean bl = remove = index != -1;
            if (remove && !(vcpi = (VisualClassPathItem)VisualArchiveIncludesSupport.this.classpathModel.getValueAt(index, 0)).canDelete()) {
                remove = false;
            }
            VisualArchiveIncludesSupport.this.removeButton.setEnabled(remove);
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getColumn() == 1) {
                VisualClassPathItem cpItem = (VisualClassPathItem)VisualArchiveIncludesSupport.this.classpathModel.getValueAt(e.getFirstRow(), 0);
                cpItem.setPathInEAR((String)VisualArchiveIncludesSupport.this.classpathModel.getValueAt(e.getFirstRow(), 1));
                VisualArchiveIncludesSupport.this.fireActionPerformed();
            }
        }
    }
}

