/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.earproject.ProjectEar;
import org.netbeans.modules.j2ee.earproject.ui.customizer.ArchiveCustomizerPanel;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualPropertySupport;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CustomizerRun
extends JPanel
implements ArchiveCustomizerPanel,
HelpCtx.Provider {
    private final VisualPropertySupport vps;
    private final VisualPropertySupport vps1;
    private String[] serverInstanceIDs;
    private String[] serverNames;
    private boolean initialized;
    private final EarProjectProperties earProperties;
    private JPanel clientInfoPanel;
    private JComboBox clientModuleUriCombo;
    private JLabel filler;
    private JCheckBox jCheckBoxDisplayBrowser;
    private JComboBox jComboBoxServer;
    private JLabel jLabelArgs;
    private JLabel jLabelContextPath;
    private JLabel jLabelContextPathDesc;
    private JLabel jLabelMainClass;
    private JLabel jLabelRelativeURL;
    private JLabel jLabelServer;
    private JLabel jLabelVMOptions;
    private JLabel jLabelVMOptionsExample;
    private JLabel jLabelVersion;
    private JTextField jTextArgs;
    private JTextField jTextFieldRelativeURL;
    private JTextField jTextFieldVersion;
    private JTextField jTextMainClass;
    private JTextField jTextVMOptions;
    private JPanel webInfoPanel;

    public CustomizerRun(EarProjectProperties earProperties, ProjectEar wm) {
        this.earProperties = earProperties;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_A11YDesc"));
        this.vps = new VisualPropertySupport(earProperties);
        this.vps1 = new VisualPropertySupport(earProperties);
        this.clientModuleUriCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomizerRun.this.updateEnabled();
            }
        });
        this.updateEnabled();
        String j2eeVersion = earProperties.getProject().getJ2eePlatformVersion();
        if ("1.5".equals(j2eeVersion)) {
            this.jTextFieldVersion.setText(EarProjectProperties.JAVA_EE_SPEC_50_LABEL);
        } else if ("1.4".equals(j2eeVersion)) {
            this.jTextFieldVersion.setText(EarProjectProperties.J2EE_SPEC_14_LABEL);
        }
    }

    private void updateEnabled() {
        boolean displayInBrowser = this.jCheckBoxDisplayBrowser.isSelected();
        boolean isWebUri = this.earProperties.isWebUri((String)this.clientModuleUriCombo.getSelectedItem());
        this.jTextFieldRelativeURL.setEnabled(displayInBrowser && isWebUri);
        this.jLabelContextPathDesc.setEnabled(displayInBrowser && isWebUri);
        this.jLabelRelativeURL.setEnabled(displayInBrowser && isWebUri);
        this.jTextMainClass.setEnabled(!isWebUri);
        this.jTextArgs.setEnabled(!isWebUri);
        this.jTextVMOptions.setEnabled(!isWebUri);
        this.jLabelMainClass.setEnabled(!isWebUri);
        this.jLabelArgs.setEnabled(!isWebUri);
        this.jLabelVMOptions.setEnabled(!isWebUri);
        this.jLabelVMOptionsExample.setEnabled(!isWebUri);
    }

    public void initValues() {
        if (this.initialized) {
            return;
        }
        this.initServerInstances();
        this.vps.register(this.jCheckBoxDisplayBrowser, "display.browser");
        this.vps.register(this.jTextFieldRelativeURL, "client.urlPart");
        this.vps.register(this.jComboBoxServer, this.serverNames, this.serverInstanceIDs, "j2ee.server.instance");
        this.vps.register(this.jTextMainClass, "main.class");
        this.vps.register(this.jTextArgs, "application.args");
        this.vps.register(this.jTextVMOptions, "j2ee.appclient.jvmoptions");
        String[] displayUris = this.getDisplayUris();
        this.vps1.register(this.clientModuleUriCombo, displayUris, this.getUris(displayUris), "client.module.uri");
        this.jTextFieldRelativeURL.setEditable(this.jCheckBoxDisplayBrowser.isSelected());
        this.initialized = true;
    }

    private String[] getDisplayUris() {
        LinkedHashSet<String> uris = new LinkedHashSet<String>();
        uris.addAll(Arrays.asList(this.earProperties.getWebUris()));
        uris.addAll(Arrays.asList(this.earProperties.getAppClientUris()));
        return uris.toArray(new String[uris.size()]);
    }

    private String[] getUris(String[] displayUris) {
        String appClient = (String)this.earProperties.get("app.client");
        String[] uris = new String[displayUris.length];
        for (int i = 0; i < uris.length; ++i) {
            if (this.earProperties.isWebUri(displayUris[i])) {
                uris[i] = displayUris[i];
                continue;
            }
            if (this.earProperties.isAppClientUri(displayUris[i])) {
                if (displayUris[i].equals(appClient)) {
                    uris[i] = this.earProperties.getClientModuleUriForAppClient();
                    continue;
                }
                uris[i] = displayUris[i];
                continue;
            }
            assert (false) : "Nor web module neither application client: " + displayUris[i];
        }
        return uris;
    }

    private int getLongestVersionLength() {
        return Math.max(EarProjectProperties.JAVA_EE_SPEC_50_LABEL.length(), EarProjectProperties.J2EE_SPEC_14_LABEL.length());
    }

    private void initComponents() {
        this.jLabelContextPath = new JLabel();
        this.jLabelServer = new JLabel();
        this.jComboBoxServer = new JComboBox();
        this.jCheckBoxDisplayBrowser = new JCheckBox();
        this.clientModuleUriCombo = new JComboBox();
        this.webInfoPanel = new JPanel();
        this.jLabelContextPathDesc = new JLabel();
        this.jLabelRelativeURL = new JLabel();
        this.jTextFieldRelativeURL = new JTextField();
        this.clientInfoPanel = new JPanel();
        this.jLabelVMOptionsExample = new JLabel();
        this.jTextVMOptions = new JTextField();
        this.jLabelVMOptions = new JLabel();
        this.jLabelArgs = new JLabel();
        this.jLabelMainClass = new JLabel();
        this.jTextMainClass = new JTextField();
        this.jTextArgs = new JTextField();
        this.filler = new JLabel();
        this.jLabelVersion = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jLabelContextPath.setLabelFor(this.clientModuleUriCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPath, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_ClientModuleURI_JLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabelContextPath, gridBagConstraints);
        this.jLabelServer.setLabelFor(this.jComboBoxServer);
        Mnemonics.setLocalizedText((JLabel)this.jLabelServer, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Server_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabelServer, gridBagConstraints);
        this.jComboBoxServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.jComboBoxServerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.jComboBoxServer, gridBagConstraints);
        this.jComboBoxServer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_Server_A11YDesc"));
        this.jCheckBoxDisplayBrowser.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDisplayBrowser, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_DisplayBrowser_JCheckBox"));
        this.jCheckBoxDisplayBrowser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.jCheckBoxDisplayBrowserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jCheckBoxDisplayBrowser, gridBagConstraints);
        this.jCheckBoxDisplayBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_DisplayBrowser_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.clientModuleUriCombo, gridBagConstraints);
        this.webInfoPanel.setLayout(new GridBagLayout());
        this.webInfoPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_WebModInfo")));
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPathDesc, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_ContextPathDesc_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.webInfoPanel.add((Component)this.jLabelContextPathDesc, gridBagConstraints);
        this.jLabelRelativeURL.setLabelFor(this.jTextFieldRelativeURL);
        Mnemonics.setLocalizedText((JLabel)this.jLabelRelativeURL, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_RelativeURL_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.webInfoPanel.add((Component)this.jLabelRelativeURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.webInfoPanel.add((Component)this.jTextFieldRelativeURL, gridBagConstraints);
        this.jTextFieldRelativeURL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_RelativeURL_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.webInfoPanel, gridBagConstraints);
        this.clientInfoPanel.setLayout(new GridBagLayout());
        this.clientInfoPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ClientInfo")));
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptionsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.clientInfoPanel.add((Component)this.jLabelVMOptionsExample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.clientInfoPanel.add((Component)this.jTextVMOptions, gridBagConstraints);
        this.jLabelVMOptions.setLabelFor(this.jTextVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptions, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.clientInfoPanel.add((Component)this.jLabelVMOptions, gridBagConstraints);
        this.jLabelArgs.setLabelFor(this.jTextArgs);
        Mnemonics.setLocalizedText((JLabel)this.jLabelArgs, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.clientInfoPanel.add((Component)this.jLabelArgs, gridBagConstraints);
        this.jLabelMainClass.setLabelFor(this.jTextMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.clientInfoPanel.add((Component)this.jLabelMainClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.clientInfoPanel.add((Component)this.jTextMainClass, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.clientInfoPanel.add((Component)this.jTextArgs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.clientInfoPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler, gridBagConstraints);
        this.jLabelVersion.setLabelFor(this.jTextFieldVersion);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVersion, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Version_JLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.jLabelVersion, gridBagConstraints);
        this.jTextFieldVersion.setColumns(this.getLongestVersionLength());
        this.jTextFieldVersion.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.add((Component)this.jTextFieldVersion, gridBagConstraints);
    }

    private void jComboBoxServerActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxDisplayBrowserActionPerformed(ActionEvent evt) {
        this.updateEnabled();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void initServerInstances() {
        String j2eeSpec = (String)this.earProperties.get("j2ee.platform");
        String[] servInstIDs = Deployment.getDefault().getServerInstanceIDs();
        Deployment deployment = Deployment.getDefault();
        TreeMap<String, String> servers = new TreeMap<String, String>();
        for (int i = 0; i < servInstIDs.length; ++i) {
            String instanceID = servInstIDs[i];
            J2eePlatform j2eePlat = deployment.getJ2eePlatform(instanceID);
            String servInstDisplayName = Deployment.getDefault().getServerInstanceDisplayName(servInstIDs[i]);
            if (servInstDisplayName == null || j2eePlat == null || !j2eePlat.getSupportedModuleTypes().contains(J2eeModule.EAR) || !j2eePlat.getSupportedSpecVersions(J2eeModule.EAR).contains(j2eeSpec)) continue;
            servers.put(servInstDisplayName, instanceID);
        }
        this.serverInstanceIDs = servers.values().toArray(new String[servers.size()]);
        this.serverNames = servers.keySet().toArray(new String[servers.size()]);
    }
}

