/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openide.ErrorManager;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ElementBeanModel;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FieldCustomizer
extends JPanel {
    static ResourceBundle bundle = NbBundle.getBundle((Class)FieldCustomizer.class);
    FieldElement element;
    private static final String[] COMMON_TYPES = new String[]{"String", "boolean", "char", "int", "long", "byte", "short", "float", "double"};
    boolean isOK = true;
    private JPanel nameTypePanel;
    private JLabel jLabel1;
    private JTextField nameTextField;
    private JLabel jLabel2;
    private JComboBox typeCombo;
    private JPanel jPanel1;
    private JPanel modifierPanel;
    private JPanel initValuePanel;
    private JScrollPane jScrollPane1;
    private JEditorPane initValueEditor;

    public FieldCustomizer(FieldElement element) {
        this.element = element;
        this.initComponents();
        this.nameTypePanel.setBorder(new CompoundBorder(new TitledBorder(bundle.getString("CTL_FieldFrame")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.modifierPanel.setBorder(new TitledBorder(bundle.getString("CTL_Modifiers")));
        this.initValuePanel.setBorder(new CompoundBorder(new TitledBorder(bundle.getString("CTL_InitValue")), new EmptyBorder(new Insets(3, 3, 3, 3))));
        this.modifierPanel.add((Component)ElementBeanModel.createModifiersPanel(element));
        this.nameTextField.setText(element.getName().toString());
        this.typeCombo.setSelectedItem(element.getType().toString());
        this.initValueEditor.setText(element.getInitValue());
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(bundle.getString("CTL_Type_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int l = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(l);
        this.nameTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FieldCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.nameTypePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.typeCombo = new JComboBox<String>(COMMON_TYPES);
        this.jPanel1 = new JPanel();
        this.modifierPanel = new JPanel();
        this.initValuePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.initValueEditor = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.nameTypePanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("CTL_Name"));
        this.jLabel1.setLabelFor(this.nameTextField);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(10, 0, 0, 8);
        gridBagConstraints2.anchor = 13;
        this.nameTypePanel.add((Component)this.jLabel1, gridBagConstraints2);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FieldCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        this.nameTypePanel.add((Component)this.nameTextField, gridBagConstraints2);
        this.jLabel2.setText(bundle.getString("CTL_Type"));
        this.jLabel2.setLabelFor(this.typeCombo);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(8, 0, 0, 8);
        gridBagConstraints2.anchor = 13;
        this.nameTypePanel.add((Component)this.jLabel2, gridBagConstraints2);
        this.typeCombo.setEditable(true);
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldCustomizer.this.jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        this.nameTypePanel.add((Component)this.typeCombo, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weighty = 1.0;
        this.nameTypePanel.add((Component)this.jPanel1, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.nameTypePanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        this.add((Component)this.modifierPanel, gridBagConstraints1);
        this.initValuePanel.setLayout(new BorderLayout());
        this.initValueEditor.setPreferredSize(new Dimension(302, 200));
        this.initValueEditor.setContentType("text/x-java");
        this.initValueEditor.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FieldCustomizer.this.initValueEditorFocusLost(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.initValueEditor);
        this.initValuePanel.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.initValuePanel, gridBagConstraints1);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        boolean ok;
        Type oldValue;
        block7: {
            Object selItem = this.typeCombo.getSelectedItem();
            oldValue = this.element.getType();
            ok = false;
            if (selItem != null) {
                try {
                    final Type newValue = Type.parse(selItem.toString());
                    if (!oldValue.equals(newValue)) {
                        try {
                            SourceEditSupport.runAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                                public void run() throws SourceException {
                                    FieldCustomizer.this.element.setType(newValue);
                                }
                            });
                            ok = true;
                        }
                        catch (SourceException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        break block7;
                    }
                    return;
                }
                catch (IllegalArgumentException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, 256, null, bundle.getString("MSG_Not_Valid_Type"), null, null);
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
        this.isOK = ok;
        if (!ok) {
            this.typeCombo.setSelectedItem(oldValue.toString());
        }
    }

    private void initValueEditorFocusLost(FocusEvent evt) {
        if (evt != null && evt.isTemporary()) {
            return;
        }
        final String newText = this.initValueEditor.getText();
        String oldText = this.element.getInitValue();
        boolean ok = false;
        if (!newText.equals(oldText)) {
            try {
                SourceEditSupport.runAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        FieldCustomizer.this.element.setInitValue(newText);
                    }
                });
                ok = true;
            }
            catch (SourceException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            return;
        }
        this.isOK = ok;
        if (!ok) {
            this.initValueEditor.setText(oldText);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nameTextFieldFocusLost(FocusEvent evt) {
        void var5_9;
        if (evt != null && evt.isTemporary()) {
            return;
        }
        String newName = this.nameTextField.getText();
        String oldName = this.element.getName().toString();
        boolean ok = false;
        Object var5_5 = null;
        if (Utilities.isJavaIdentifier((String)newName)) {
            if (oldName.equals(newName)) return;
            final Identifier id = Identifier.create(newName);
            try {
                SourceEditSupport.runAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        FieldCustomizer.this.element.setName(id);
                    }
                });
                ok = true;
            }
            catch (SourceException e) {
                SourceException sourceException = e;
            }
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, bundle.getString("MSG_Not_Valid_Identifier"), null, null);
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
        if (var5_9 == null) return;
        ErrorManager.getDefault().notify((Throwable)var5_9);
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_FieldNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_FieldNameTextField"));
        this.initValueEditor.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_InitValueEditorPane"));
        this.initValueEditor.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_InitValueEditorPane"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_FieldCustomizerDialog");
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        this.initValueEditorFocusLost(null);
        this.jComboBox1ActionPerformed(null);
        return this.isOK;
    }
}

