/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.ant.freeform.ui.ProjectNodeWrapper;
import org.netbeans.modules.ant.freeform.ui.UnboundTargetAlert;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.w3c.dom.Element;

public final class Actions
implements ActionProvider {
    private static final Set COMMON_IDE_GLOBAL_ACTIONS;
    private static final Set COMMON_NON_IDE_GLOBAL_ACTIONS;
    private final FreeformProject project;
    static TargetRunner TARGET_RUNNER;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Actions(FreeformProject project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        Element genldata = this.project.helper().getPrimaryConfigurationData(true);
        Element actionsEl = Util.findElement(genldata, "ide-actions", "http://www.netbeans.org/ns/freeform-project/1");
        if (actionsEl == null) {
            return new String[0];
        }
        List actions = Util.findSubElements(actionsEl);
        LinkedHashSet<String> names = new LinkedHashSet<String>(actions.size());
        Iterator it = actions.iterator();
        while (it.hasNext()) {
            Element actionEl = (Element)it.next();
            names.add(actionEl.getAttribute("name"));
        }
        names.addAll(COMMON_NON_IDE_GLOBAL_ACTIONS);
        names.add("rename");
        names.add("move");
        names.add("copy");
        names.add("delete");
        return names.toArray(new String[names.size()]);
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            return true;
        }
        if ("copy".equals(command)) {
            return true;
        }
        if ("rename".equals(command)) {
            return true;
        }
        if ("move".equals(command)) {
            return true;
        }
        Element genldata = this.project.helper().getPrimaryConfigurationData(true);
        Element actionsEl = Util.findElement(genldata, "ide-actions", "http://www.netbeans.org/ns/freeform-project/1");
        if (actionsEl == null) {
            throw new IllegalArgumentException("No commands supported");
        }
        List actions = Util.findSubElements(actionsEl);
        Iterator it = actions.iterator();
        boolean foundAction = false;
        while (it.hasNext()) {
            Element actionEl = (Element)it.next();
            if (!actionEl.getAttribute("name").equals(command)) continue;
            foundAction = true;
            Element contextEl = Util.findElement(actionEl, "context", "http://www.netbeans.org/ns/freeform-project/1");
            if (contextEl != null) {
                Map selection = Actions.findSelection(contextEl, context, this.project);
                if (selection.size() == 1) {
                    return true;
                }
                if (selection.isEmpty()) continue;
                Element arityEl = Util.findElement(contextEl, "arity", "http://www.netbeans.org/ns/freeform-project/1");
                if (!$assertionsDisabled && arityEl == null) {
                    throw new AssertionError((Object)("No <arity> in <context> for " + command));
                }
                if (Util.findElement(arityEl, "separated-files", "http://www.netbeans.org/ns/freeform-project/1") == null) continue;
                return true;
            }
            return true;
        }
        if (COMMON_NON_IDE_GLOBAL_ACTIONS.contains(command)) {
            return true;
        }
        if (foundAction) {
            return false;
        }
        throw new IllegalArgumentException("Unrecognized command: " + command);
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        Element genldata = this.project.helper().getPrimaryConfigurationData(true);
        Element actionsEl = Util.findElement(genldata, "ide-actions", "http://www.netbeans.org/ns/freeform-project/1");
        if (actionsEl == null) {
            throw new IllegalArgumentException("No commands supported");
        }
        List actions = Util.findSubElements(actionsEl);
        Iterator it = actions.iterator();
        boolean foundAction = false;
        while (it.hasNext()) {
            Element actionEl = (Element)it.next();
            if (!actionEl.getAttribute("name").equals(command)) continue;
            foundAction = true;
            Actions.runConfiguredAction(this.project, actionEl, context);
        }
        if (!foundAction) {
            if (COMMON_NON_IDE_GLOBAL_ACTIONS.contains(command)) {
                if (this.addGlobalBinding(command)) {
                    this.invokeAction(command, context);
                }
            } else {
                throw new IllegalArgumentException("Unrecognized command: " + command);
            }
        }
    }

    private static Map findSelection(Element contextEl, Lookup context, FreeformProject project) {
        ArrayList<FileObject> files = context.lookup(new Lookup.Template(FileObject.class)).allInstances();
        if (files.isEmpty()) {
            Collection filesDO = context.lookup(new Lookup.Template(DataObject.class)).allInstances();
            if (filesDO.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            files = new ArrayList<FileObject>(filesDO.size());
            Iterator it = filesDO.iterator();
            while (it.hasNext()) {
                files.add(((DataObject)it.next()).getPrimaryFile());
            }
        }
        Element folderEl = Util.findElement(contextEl, "folder", "http://www.netbeans.org/ns/freeform-project/1");
        if (!$assertionsDisabled && folderEl == null) {
            throw new AssertionError((Object)"Must have <folder> in <context>");
        }
        String rawtext = Util.findText(folderEl);
        if (!$assertionsDisabled && rawtext == null) {
            throw new AssertionError((Object)"Must have text contents in <folder>");
        }
        String evaltext = project.evaluator().evaluate(rawtext);
        if (evaltext == null) {
            return Collections.EMPTY_MAP;
        }
        FileObject folder = project.helper().resolveFileObject(evaltext);
        if (folder == null) {
            return Collections.EMPTY_MAP;
        }
        Pattern pattern = null;
        Element patternEl = Util.findElement(contextEl, "pattern", "http://www.netbeans.org/ns/freeform-project/1");
        if (patternEl != null) {
            String text = Util.findText(patternEl);
            if (!$assertionsDisabled && text == null) {
                throw new AssertionError((Object)"Must have text contents in <pattern>");
            }
            try {
                pattern = Pattern.compile(text);
            }
            catch (PatternSyntaxException e) {
                org.netbeans.modules.ant.freeform.Util.err.annotate((Throwable)e, 0, "From <pattern> in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory().getFileObject("nbproject/project.xml")), null, null, null);
                org.netbeans.modules.ant.freeform.Util.err.notify((Throwable)e);
                return Collections.EMPTY_MAP;
            }
        }
        HashMap<String, FileObject> result = new HashMap<String, FileObject>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            FileObject file = (FileObject)it.next();
            String path = FileUtil.getRelativePath((FileObject)folder, (FileObject)file);
            if (path == null) {
                return Collections.EMPTY_MAP;
            }
            if (pattern != null && !pattern.matcher(path).find()) {
                return Collections.EMPTY_MAP;
            }
            result.put(path, file);
        }
        return result;
    }

    private static void runConfiguredAction(FreeformProject project, Element actionEl, Lookup context) {
        Element scriptEl = Util.findElement(actionEl, "script", "http://www.netbeans.org/ns/freeform-project/1");
        String script = scriptEl != null ? Util.findText(scriptEl) : "build.xml";
        String scriptLocation = project.evaluator().evaluate(script);
        FileObject scriptFile = project.helper().resolveFileObject(scriptLocation);
        if (scriptFile == null) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getMessage((Class)Actions.class, (String)"LBL_ScriptFileNotFoundError"), scriptLocation), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        List targets = Util.findSubElements(actionEl);
        ArrayList<String> targetNames = new ArrayList<String>(targets.size());
        Iterator it2 = targets.iterator();
        while (it2.hasNext()) {
            Element targetEl = (Element)it2.next();
            if (!targetEl.getLocalName().equals("target")) continue;
            targetNames.add(Util.findText(targetEl));
        }
        String[] targetNameArray = !targetNames.isEmpty() ? targetNames.toArray(new String[targetNames.size()]) : null;
        Properties props = new Properties();
        Element contextEl = Util.findElement(actionEl, "context", "http://www.netbeans.org/ns/freeform-project/1");
        if (contextEl != null) {
            Map selection = Actions.findSelection(contextEl, context, project);
            if (selection.isEmpty()) {
                return;
            }
            String separator = null;
            if (selection.size() > 1) {
                Element arityEl = Util.findElement(contextEl, "arity", "http://www.netbeans.org/ns/freeform-project/1");
                if (!$assertionsDisabled && arityEl == null) {
                    throw new AssertionError((Object)("No <arity> in <context> for " + actionEl.getAttribute("name")));
                }
                Element sepFilesEl = Util.findElement(arityEl, "separated-files", "http://www.netbeans.org/ns/freeform-project/1");
                if (sepFilesEl == null) {
                    return;
                }
                separator = Util.findText(sepFilesEl);
            }
            Element formatEl = Util.findElement(contextEl, "format", "http://www.netbeans.org/ns/freeform-project/1");
            if (!$assertionsDisabled && formatEl == null) {
                throw new AssertionError((Object)("No <format> in <context> for " + actionEl.getAttribute("name")));
            }
            String format = Util.findText(formatEl);
            StringBuffer buf = new StringBuffer();
            Iterator it = selection.entrySet().iterator();
            while (it.hasNext()) {
                String path;
                File f;
                Map.Entry entry = it.next();
                if (format.equals("absolute-path")) {
                    f = FileUtil.toFile((FileObject)((FileObject)entry.getValue()));
                    if (f == null) {
                        return;
                    }
                    buf.append(f.getAbsolutePath());
                } else if (format.equals("relative-path")) {
                    buf.append((String)entry.getKey());
                } else if (format.equals("absolute-path-noext")) {
                    f = FileUtil.toFile((FileObject)((FileObject)entry.getValue()));
                    if (f == null) {
                        return;
                    }
                    String path2 = f.getAbsolutePath();
                    int dot = path2.lastIndexOf(46);
                    if (dot > path2.lastIndexOf(47)) {
                        path2 = path2.substring(0, dot);
                    }
                    buf.append(path2);
                } else if (format.equals("relative-path-noext")) {
                    path = (String)entry.getKey();
                    int dot = path.lastIndexOf(46);
                    if (dot > path.lastIndexOf(47)) {
                        path = path.substring(0, dot);
                    }
                    buf.append(path);
                } else {
                    if (!$assertionsDisabled && !format.equals("java-name")) {
                        throw new AssertionError((Object)format);
                    }
                    path = (String)entry.getKey();
                    int dot = path.lastIndexOf(46);
                    String dotless = dot == -1 || dot < path.lastIndexOf(47) ? path : path.substring(0, dot);
                    String javaname = dotless.replace('/', '.');
                    buf.append(javaname);
                }
                if (!it.hasNext()) continue;
                if (!$assertionsDisabled && separator == null) {
                    throw new AssertionError();
                }
                buf.append(separator);
            }
            Element propEl = Util.findElement(contextEl, "property", "http://www.netbeans.org/ns/freeform-project/1");
            if (!$assertionsDisabled && propEl == null) {
                throw new AssertionError((Object)("No <property> in <context> for " + actionEl.getAttribute("name")));
            }
            String prop = Util.findText(propEl);
            if (!$assertionsDisabled && prop == null) {
                throw new AssertionError((Object)"Must have text contents in <property>");
            }
            props.setProperty(prop, buf.toString());
        }
        it2 = targets.iterator();
        while (it2.hasNext()) {
            String evaltext;
            Element propEl = (Element)it2.next();
            if (!propEl.getLocalName().equals("property")) continue;
            String rawtext = Util.findText(propEl);
            if (rawtext == null) {
                rawtext = "";
            }
            if ((evaltext = project.evaluator().evaluate(rawtext)) == null) continue;
            props.setProperty(propEl.getAttribute("name"), evaltext);
        }
        TARGET_RUNNER.runTarget(scriptFile, targetNameArray, props);
    }

    public static Action[] createContextMenu(FreeformProject p) {
        Element contextMenuEl;
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(CommonProjectActions.newFileAction());
        Element genldata = p.helper().getPrimaryConfigurationData(true);
        Element viewEl = Util.findElement(genldata, "view", "http://www.netbeans.org/ns/freeform-project/1");
        if (viewEl != null && (contextMenuEl = Util.findElement(viewEl, "context-menu", "http://www.netbeans.org/ns/freeform-project/1")) != null) {
            actions.add(null);
            List actionEls = Util.findSubElements(contextMenuEl);
            Iterator it = actionEls.iterator();
            while (it.hasNext()) {
                Element actionEl = (Element)it.next();
                if (actionEl.getLocalName().equals("ide-action")) {
                    String cmd = actionEl.getAttribute("name");
                    String displayName = COMMON_IDE_GLOBAL_ACTIONS.contains(cmd) || COMMON_NON_IDE_GLOBAL_ACTIONS.contains(cmd) ? NbBundle.getMessage((Class)(class$org$netbeans$modules$ant$freeform$Actions == null ? Actions.class$("org.netbeans.modules.ant.freeform.Actions") : class$org$netbeans$modules$ant$freeform$Actions), (String)("CMD_" + cmd)) : cmd;
                    actions.add(ProjectSensitiveActions.projectCommandAction((String)cmd, (String)displayName, null));
                    continue;
                }
                if (actionEl.getLocalName().equals("separator")) {
                    actions.add(null);
                    continue;
                }
                if (!$assertionsDisabled && !actionEl.getLocalName().equals("action")) {
                    throw new AssertionError(actionEl);
                }
                actions.add(new CustomAction(p, actionEl));
            }
        }
        actions.add(null);
        actions.add(CommonProjectActions.setAsMainProjectAction());
        actions.add(CommonProjectActions.openSubprojectsAction());
        actions.add(CommonProjectActions.closeProjectAction());
        actions.add(null);
        actions.add(CommonProjectActions.renameProjectAction());
        actions.add(CommonProjectActions.moveProjectAction());
        actions.add(CommonProjectActions.copyProjectAction());
        actions.add(CommonProjectActions.deleteProjectAction());
        actions.add(null);
        actions.add((Action)SystemAction.get((Class)FindAction.class));
        actions.add(ProjectNodeWrapper.GENERIC_PROJECTS_ACTIONS_MARKER);
        actions.add(null);
        actions.add((Action)SystemAction.get((Class)ToolsAction.class));
        actions.add(null);
        actions.add(CommonProjectActions.customizeProjectAction());
        return actions.toArray(new Action[actions.size()]);
    }

    private boolean addGlobalBinding(String command) {
        try {
            return new UnboundTargetAlert(this.project, command).accepted();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    static {
        $assertionsDisabled = !Actions.class.desiredAssertionStatus();
        COMMON_IDE_GLOBAL_ACTIONS = new HashSet<String>(Arrays.asList("debug", "delete", "copy", "move", "rename"));
        COMMON_NON_IDE_GLOBAL_ACTIONS = new HashSet<String>(Arrays.asList("build", "clean", "rebuild", "run", "test", "javadoc", "redeploy"));
        TARGET_RUNNER = new TargetRunner();
    }

    static class TargetRunner {
        public void runTarget(FileObject scriptFile, String[] targetNameArray, Properties props) {
            try {
                ActionUtils.runTarget((FileObject)scriptFile, (String[])targetNameArray, (Properties)props);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private static final class CustomAction
    extends AbstractAction {
        private final FreeformProject p;
        private final Element actionEl;

        public CustomAction(FreeformProject p, Element actionEl) {
            this.p = p;
            this.actionEl = actionEl;
        }

        public void actionPerformed(ActionEvent e) {
            Actions.runConfiguredAction(this.p, this.actionEl, Lookup.EMPTY);
        }

        public boolean isEnabled() {
            Element scriptEl = Util.findElement(this.actionEl, "script", "http://www.netbeans.org/ns/freeform-project/1");
            String script = scriptEl != null ? Util.findText(scriptEl) : "build.xml";
            String scriptLocation = this.p.evaluator().evaluate(script);
            return this.p.helper().resolveFileObject(scriptLocation) != null;
        }

        public Object getValue(String key) {
            if (key.equals("Name")) {
                Element labelEl = Util.findElement(this.actionEl, "label", "http://www.netbeans.org/ns/freeform-project/1");
                return Util.findText(labelEl);
            }
            return super.getValue(key);
        }
    }
}

