/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.Util;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ResourceWizardPanel
extends JPanel {
    private final Map sourceMap = Util.createWizardSourceMap();
    private final ResourceTableModel tableModel = new ResourceTableModel();
    private final Panel descPanel;
    private final boolean testMode;
    private JButton addAllButton;
    private JButton addButton;
    private JTextArea descTextArea;
    private JScrollPane jScrollPane1;
    private JTable resourcesTable;

    private ResourceWizardPanel(Panel descPanel, boolean testMode) {
        this.descPanel = descPanel;
        this.testMode = testMode;
        this.initComponents();
        this.postInitComponents();
        this.initTable();
        this.initAccesibility();
    }

    public Map getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map sourceMap) {
        this.sourceMap.clear();
        this.sourceMap.putAll(sourceMap);
        this.tableModel.fireTableDataChanged();
        this.descPanel.fireStateChanged();
    }

    private String getPanelDescription() {
        if (!this.testMode) {
            return Util.getString("MSG_ResourcePanel_desc");
        }
        return Util.getString("MSG_ResourcePanel_test_desc");
    }

    private void postInitComponents() {
        this.addAllButton.setMnemonic(NbBundle.getBundle(this.getClass()).getString("CTL_SelectResourceAll_Mnem").charAt(0));
        this.addButton.setMnemonic(NbBundle.getBundle(this.getClass()).getString("CTL_SelectResource_Mnem").charAt(0));
    }

    private void initTable() {
        this.resourcesTable.setDefaultRenderer(DataObject.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DataObject dataObject = (DataObject)value;
                if (dataObject != null) {
                    String name = "N/A";
                    if (column == 0) {
                        ClassPath cp = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                        name = cp.getResourceName(dataObject.getPrimaryFile(), '.', false);
                    } else {
                        DataObject dob = (DataObject)ResourceWizardPanel.this.tableModel.getValueAt(row, 0);
                        name = Util.getResourceName(dob.getPrimaryFile(), dataObject.getPrimaryFile(), '.', false);
                    }
                    label.setText(name);
                    label.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
                } else {
                    label.setText("");
                    label.setIcon(null);
                }
                return label;
            }
        });
        Component cellSample = new DefaultTableCellRenderer().getTableCellRendererComponent(this.resourcesTable, "N/A", false, false, 0, 0);
        int cellHeight = cellSample.getPreferredSize().height;
        int rowHeight = cellHeight + this.resourcesTable.getRowMargin();
        this.resourcesTable.setRowHeight(Math.max(16, rowHeight));
        this.resourcesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ResourceWizardPanel.this.addButton.setEnabled(!ResourceWizardPanel.this.resourcesTable.getSelectionModel().isSelectionEmpty());
            }
        });
        this.addButton.setEnabled(!this.resourcesTable.getSelectionModel().isSelectionEmpty());
    }

    private void initAccesibility() {
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("ACS_CTL_SelectResource"));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("ACS_CTL_SelectResourceAll"));
        this.resourcesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("ACSD_resourcesTable"));
        this.resourcesTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("ACSN_resourcesTable"));
    }

    private void initComponents() {
        this.descTextArea = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.resourcesTable = new JTable();
        this.addAllButton = new JButton();
        this.addButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.descTextArea.setColumns(20);
        this.descTextArea.setEditable(false);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(this.getPanelDescription());
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(new JLabel().getForeground());
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.resourcesTable.setModel(this.tableModel);
        this.jScrollPane1.setViewportView(this.resourcesTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addAllButton.setText(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("CTL_SelectResourceAll"));
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceWizardPanel.this.addAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.addAllButton, gridBagConstraints);
        this.addButton.setText(NbBundle.getBundle((Class)ResourceWizardPanel.class).getString("CTL_SelectResource"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceWizardPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        DataObject resource = this.selectResource();
        if (resource == null) {
            return;
        }
        int[] selectedRows = this.resourcesTable.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            DataObject dataObject = (DataObject)this.resourcesTable.getValueAt(selectedRows[i], 0);
            this.sourceMap.put(dataObject, new SourceData(resource));
            this.tableModel.fireTableCellUpdated(selectedRows[i], 1);
        }
        this.descPanel.fireStateChanged();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        DataObject resource = this.selectResource();
        if (resource == null) {
            return;
        }
        for (int i = 0; i < this.resourcesTable.getRowCount(); ++i) {
            DataObject dataObject = (DataObject)this.resourcesTable.getValueAt(i, 0);
            this.sourceMap.put(dataObject, new SourceData(resource));
            this.tableModel.fireTableCellUpdated(i, 1);
        }
        this.descPanel.fireStateChanged();
    }

    private DataObject selectResource() {
        Project prj = null;
        FileObject fo = null;
        Iterator it = this.sourceMap.keySet().iterator();
        if (it.hasNext()) {
            DataObject dobj = (DataObject)it.next();
            fo = dobj.getPrimaryFile();
            prj = FileOwnerQuery.getOwner((FileObject)fo);
        }
        return SelectorUtils.selectBundle(prj, fo);
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel
    implements I18nWizardDescriptor.ProgressMonitor {
        private transient ResourceWizardPanel resourcePanel;
        private boolean testWizard;

        public Panel() {
            this(false);
        }

        public Panel(boolean testWizard) {
            this.testWizard = testWizard;
        }

        protected Component createComponent() {
            JPanel panel = new JPanel();
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("ACS_ResourceWizardPanel"));
            panel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
            if (this.testWizard) {
                panel.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_SelectTestResource"));
            } else {
                panel.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_SelectResource"));
            }
            panel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            panel.add((Component)this.getUI(), constraints);
            return panel;
        }

        public boolean isValid() {
            return !this.getUI().getSourceMap().containsValue(null);
        }

        public void readSettings(Object settings) {
            super.readSettings(settings);
            this.getUI().setSourceMap(this.getMap());
        }

        public void storeSettings(Object settings) {
            super.storeSettings(settings);
            this.getMap().clear();
            this.getMap().putAll(this.getUI().getSourceMap());
        }

        public void doLongTimeChanges() {
            ProgressWizardPanel progressPanel = new ProgressWizardPanel(false);
            this.showProgressPanel(progressPanel);
            progressPanel.setMainText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_Loading"));
            progressPanel.setMainProgress(0);
            Map sourceMap = this.getUI().getSourceMap();
            Iterator sourceIterator = sourceMap.keySet().iterator();
            int i = 0;
            while (sourceIterator.hasNext()) {
                block6: {
                    I18nSupport support;
                    DataObject source = (DataObject)sourceIterator.next();
                    ClassPath cp = ClassPath.getClassPath((FileObject)source.getPrimaryFile(), (String)"classpath/source");
                    progressPanel.setMainText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel") : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_Loading") + " " + cp.getResourceName(source.getPrimaryFile(), '.', false));
                    SourceData sourceData = (SourceData)sourceMap.get(source);
                    try {
                        support = FactoryRegistry.getFactory(source.getClass()).create(source);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe);
                        sourceMap.remove(source);
                        break block6;
                    }
                    sourceData = new SourceData(sourceData.getResource(), support);
                    sourceMap.put(source, sourceData);
                    cp = ClassPath.getClassPath((FileObject)source.getPrimaryFile(), (String)"classpath/source");
                    progressPanel.setMainText(NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel") : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("TXT_SearchingIn") + " " + cp.getResourceName(source.getPrimaryFile(), '.', false));
                    Map stringMap = sourceData.getStringMap();
                    HardCodedString[] foundStrings = this.testWizard ? support.getFinder().findAllI18nStrings() : support.getFinder().findAllHardCodedStrings();
                    if (foundStrings == null) {
                        sourceData.setStringMap(new HashMap(0));
                    } else {
                        HashMap<HardCodedString, I18nString> map = new HashMap<HardCodedString, I18nString>(foundStrings.length);
                        for (int j = 0; j < foundStrings.length; ++j) {
                            if (this.testWizard && support.getResourceHolder().getValueForKey(UtilConvert.escapePropertiesSpecialChars((String)foundStrings[j].getText())) != null) continue;
                            map.put(foundStrings[j], support.getDefaultI18nString(foundStrings[j]));
                        }
                        progressPanel.setMainProgress((int)((float)(i + 1) / (float)sourceMap.size() * 100.0f));
                        sourceData.setStringMap(map);
                    }
                }
                ++i;
            }
        }

        private void showProgressPanel(ProgressWizardPanel progressPanel) {
            ((Container)this.getComponent()).remove(this.getUI());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            ((Container)this.getComponent()).add((Component)progressPanel, constraints);
            ((JComponent)this.getComponent()).revalidate();
            this.getComponent().repaint();
        }

        public void reset() {
            Container container = (Container)this.getComponent();
            if (!container.isAncestorOf(this.getUI())) {
                container.removeAll();
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                container.add((Component)this.getUI(), constraints);
            }
        }

        public HelpCtx getHelp() {
            if (this.testWizard) {
                return new HelpCtx("internation.testing");
            }
            return new HelpCtx("internation.wizard");
        }

        private synchronized ResourceWizardPanel getUI() {
            if (this.resourcePanel == null) {
                this.resourcePanel = new ResourceWizardPanel(this, this.testWizard);
            }
            return this.resourcePanel;
        }
    }

    private class ResourceTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ResourceWizardPanel.this.sourceMap.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ResourceWizardPanel.this.sourceMap.keySet().toArray()[rowIndex];
            }
            SourceData value = (SourceData)ResourceWizardPanel.this.sourceMap.values().toArray()[rowIndex];
            return value == null ? null : value.getResource();
        }

        public Class getColumnClass(int columnIndex) {
            return class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResourceWizardPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("CTL_Source");
            }
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel == null ? (class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel = ResourceWizardPanel.class$("org.netbeans.modules.i18n.wizard.ResourceWizardPanel")) : class$org$netbeans$modules$i18n$wizard$ResourceWizardPanel)).getString("CTL_Resource");
        }
    }
}

