/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.visitor;

import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindSchemaComponentFromDOM
extends DeepSchemaVisitor {
    private SchemaComponent result;
    private Element xmlNode;

    public static <T extends SchemaComponent> T find(Class<T> type, SchemaComponent root, String xpath) {
        SchemaComponent ret = new FindSchemaComponentFromDOM().findComponent(root, xpath);
        return (T)((SchemaComponent)type.cast(ret));
    }

    public SchemaComponent findComponent(SchemaComponent root, Element xmlNode) {
        assert (root instanceof Schema);
        assert (xmlNode != null);
        this.xmlNode = xmlNode;
        this.result = null;
        root.accept(this);
        return this.result;
    }

    public SchemaComponent findComponent(SchemaComponent root, String xpath) {
        Document doc = this.getDocument(root);
        if (doc == null) {
            return null;
        }
        Node result = ((SchemaModelImpl)root.getModel()).getAccess().findNode(doc, xpath);
        if (result instanceof Element) {
            return this.findComponent(root, (Element)result);
        }
        return null;
    }

    private Document getDocument(SchemaComponent root) {
        return root.getModel().getDocument();
    }

    private Element getElement(SchemaComponent c) {
        return c.getPeer();
    }

    public String getXPathForComponent(SchemaComponent root, SchemaComponent target) {
        Document doc = this.getDocument(root);
        Element element = this.getElement(target);
        if (doc == null || element == null) {
            return null;
        }
        return ((SchemaModelImpl)root.getModel()).getAccess().getXPath(doc, element);
    }

    @Override
    protected void visitChildren(SchemaComponent component) {
        if (this.result != null) {
            return;
        }
        if (component.referencesSameNode(this.xmlNode)) {
            this.result = component;
        } else {
            super.visitChildren(component);
        }
    }
}

