/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.validation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.spi.XsdBasedValidator;
import org.openide.util.NbBundle;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class SchemaXsdBasedValidator
extends XsdBasedValidator {
    private static Schema schema;

    protected Schema getSchema(Model model) {
        block4: {
            if (!(model instanceof SchemaModel)) {
                return null;
            }
            if (schema == null) {
                try {
                    schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema();
                }
                catch (SAXException ex) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)"Error while creating compiled schema for");
                }
            }
        }
        return schema;
    }

    public String getName() {
        return NbBundle.getMessage(SchemaXsdBasedValidator.class, (String)"LBL_Schema_Validator");
    }

    protected void validate(Model model, Schema schema, XsdBasedValidator.Handler handler) {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            CatalogModel cm = (CatalogModel)model.getModelSource().getLookup().lookup(CatalogModel.class);
            if (cm != null) {
                sf.setResourceResolver((LSResourceResolver)cm);
            }
            sf.setErrorHandler((ErrorHandler)handler);
            Source saxSource = this.getSource(model, handler);
            if (saxSource == null) {
                return;
            }
            sf.newSchema(saxSource);
        }
        catch (SAXException sax) {
        }
        catch (Exception ex) {
            handler.logValidationErrors(Validator.ResultType.ERROR, ex.getMessage());
        }
    }

    public DocumentModel resolveResource(String systemId, Model currentModel) {
        try {
            CatalogModel cm = (CatalogModel)currentModel.getModelSource().getLookup().lookup(CatalogModel.class);
            ModelSource ms = cm.getModelSource(new URI(systemId));
            if (ms != null) {
                return SchemaModelFactory.getDefault().getModel(ms);
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "resolveResource", ex);
        }
        catch (CatalogModelException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "resolveResource", ex);
        }
        return null;
    }
}

