/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppservClassLoader;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.LocalStringsManager;

public abstract class AppServerAdmin
extends Task {
    static Method invokeCLI = null;
    static Class adminMain = null;
    static Class inputsAndOutputs = null;
    static Class systemPropertyConstants = null;
    protected Server server;
    protected List servers = new ArrayList();
    private File asinstalldir;
    private boolean executeCommand = true;
    private static final String CLASS_INPUTS_AND_OUTPUTS = "com.sun.enterprise.cli.framework.InputsAndOutputs";
    private static final String CLASS_ADMIN_MAIN = "com.sun.enterprise.cli.framework.CLIMain";
    private static final String METHOD_INVOKE_CLI = "invokeCLI";
    LocalStringsManager lsm = new LocalStringsManager();
    private static final String CLASS_SYSTEM_PROPERTY_CONSTANTS = "com.sun.enterprise.util.SystemPropertyConstants";

    public AppServerAdmin() {
        this.server = this.getNewServer();
    }

    protected void checkConfiguration() throws BuildException {
        this.log(this.servers.size() + " servers were found.", 4);
        if (this.servers.size() == 0) {
            String msg = this.lsm.getString("SpecifyOneServer");
            throw new BuildException(msg, this.getLocation());
        }
        Iterator it = this.servers.iterator();
        while (it.hasNext()) {
            Server aServer = (Server)it.next();
            this.checkConfiguration(aServer);
        }
    }

    public void execute() throws BuildException {
        this.prepareToExecute();
        this.checkConfiguration();
        Iterator it = this.servers.iterator();
        while (it.hasNext()) {
            Server aServer = (Server)it.next();
            this.execute(aServer);
        }
    }

    protected void prepareToExecute() {
        if (this.servers.size() == 0) {
            this.servers.add(this.server);
        }
    }

    public void setPort(int port) {
        this.server.setPort(port);
    }

    public void setExecuteCommand(boolean executeCommand) {
        this.executeCommand = executeCommand;
    }

    protected File getAsinstalldir() throws ClassNotFoundException {
        if (this.asinstalldir == null) {
            String home = this.getProject().getProperty("asinstall.dir");
            if (home != null) {
                this.asinstalldir = new File(home);
            } else {
                home = this.getProject().getProperty("sunone.home");
                if (home != null) {
                    String msg = this.lsm.getString("DeprecatedProperty", new Object[]{"sunone.home", "asinstall.dir"});
                    this.log(msg, 1);
                    this.asinstalldir = new File(home);
                }
            }
        }
        if (this.asinstalldir != null) {
            this.verifyAsinstalldir(this.asinstalldir);
        }
        return this.asinstalldir;
    }

    public void setAsinstalldir(File asinstalldir) {
        this.asinstalldir = asinstalldir;
    }

    public void setSunonehome(File sunonehome) {
        String msg = this.lsm.getString("DeprecatedAttribute", new Object[]{"sunonehome", "asinstalldir"});
        this.log(msg, 1);
        this.asinstalldir = sunonehome;
    }

    private boolean verifyAsinstalldir(File home) throws ClassNotFoundException {
        if (home != null && home.isDirectory() && new File(home, "config").isDirectory()) {
            return true;
        }
        throw new ClassNotFoundException("ClassCouldNotBeFound");
    }

    protected void execAdminCommand(String command) throws BuildException {
        this.log("Executing: " + command, 2);
        try {
            if (invokeCLI == null) {
                AntClassLoader antClassLoader = new AntClassLoader((ClassLoader)AppservClassLoader.getClassLoader(), this.getProject(), null, false);
                this.log("class = " + antClassLoader.getClasspath(), 4);
                inputsAndOutputs = Class.forName(CLASS_INPUTS_AND_OUTPUTS, true, (ClassLoader)antClassLoader);
                adminMain = Class.forName(CLASS_ADMIN_MAIN, true, (ClassLoader)antClassLoader);
                systemPropertyConstants = Class.forName(CLASS_SYSTEM_PROPERTY_CONSTANTS, true, (ClassLoader)antClassLoader);
            }
            this.log("***** INSTALL_ROOT_PROPERTY = " + (String)systemPropertyConstants.getField("INSTALL_ROOT_PROPERTY").get(null), 4);
            String installRootConstant = (String)systemPropertyConstants.getField("INSTALL_ROOT_PROPERTY").get(null);
            String configRootConstant = (String)systemPropertyConstants.getField("CONFIG_ROOT_PROPERTY").get(null);
            String installRoot = this.getInstallRoot(installRootConstant);
            this.log("installRoot: " + installRoot, 4);
            System.setProperty("java.library.path", installRoot + "/lib");
            System.setProperty(installRootConstant, installRoot);
            System.setProperty(configRootConstant, installRoot + "/config");
            System.setProperty("java.endorsed.dirs", installRoot + "/lib/endorsed");
            Class[] parameterClasses = new Class[]{String.class, inputsAndOutputs};
            invokeCLI = adminMain.getDeclaredMethod(METHOD_INVOKE_CLI, parameterClasses);
            Object[] parameters = new Object[]{command, null};
            if (this.executeCommand) {
                invokeCLI.invoke((Object)adminMain, parameters);
            }
        }
        catch (ClassNotFoundException e) {
            String msg = this.lsm.getString("ClassCouldNotBeFound", new Object[]{e.getMessage()});
            throw new BuildException(msg, this.getLocation());
        }
        catch (NoSuchMethodException e) {
            String msg = this.lsm.getString("CouldNotFindInvokeCLI", new Object[]{e.getMessage()});
            throw new BuildException(msg, this.getLocation());
        }
        catch (InvocationTargetException e) {
            String msg = this.lsm.getString("ExceptionOccuredRunningTheCommand", new Object[]{e.getTargetException().getMessage()});
            throw new BuildException(msg, this.getLocation());
        }
        catch (IllegalAccessException e) {
            String msg = this.lsm.getString("ExceptionOccuredInvokeingCLI", new Object[]{e.getMessage()});
            throw new BuildException(msg, this.getLocation());
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), this.getLocation());
        }
    }

    public void setHost(String host) {
        this.server.setHost(host);
    }

    public void setInstance(String instance) {
        this.server.setInstance(instance);
    }

    public void setPassword(String password) {
        String msg = this.lsm.getString("DeprecatedAttribute", new Object[]{"password", "passwordfile"});
        this.log(msg, 1);
        this.server.setPassword(password);
    }

    public void setPasswordfile(String passwordfile) {
        this.server.setPasswordfile(passwordfile);
    }

    public void setSecure(String secure) {
        this.server.setSecure(secure);
    }

    public void setUser(String user) {
        this.server.setUser(user);
    }

    public Server createServer() {
        this.log("createServer", 4);
        Server aNestedServer = this.getNewServer();
        this.servers.add(aNestedServer);
        return aNestedServer;
    }

    protected Server getNewServer() {
        return new Server(this.server);
    }

    protected abstract void checkConfiguration(Server var1) throws BuildException;

    protected abstract void execute(Server var1) throws BuildException;

    private String getInstallRoot(String installRootConstant) throws ClassNotFoundException {
        String installRoot;
        File installDir = this.getAsinstalldir();
        if (installDir == null) {
            installRoot = System.getProperty(installRootConstant);
            if (installRoot == null) {
                throw new ClassNotFoundException("ClassCouldNotBeFound");
            }
        } else {
            installRoot = installDir.getPath();
            System.setProperty(installRootConstant, installRoot);
        }
        return installRoot;
    }

    public class Server {
        private Server parent;
        private String user;
        private String password;
        private String passwordfile;
        private String host;
        private int port;
        private String secure;
        private String instance;
        protected static final String DEFAULT_USER = "admin";
        protected static final String DEFAULT_HOST = "localhost";
        protected static final String DEFAULT_PORT = "4848";

        protected int getPort() {
            if (this.port == 0) {
                return this.parent == null ? 0 : this.parent.getPort();
            }
            return this.port;
        }

        protected boolean hasPassword() {
            if (this.passwordfile != null || this.password != null) {
                return true;
            }
            if (this.parent != null) {
                return this.parent.hasPassword();
            }
            return false;
        }

        public void setPort(int port) {
            this.port = port;
        }

        protected String getHost() {
            if (this.host == null) {
                return this.parent == null ? null : this.parent.getHost();
            }
            return this.host;
        }

        protected String getInstance() {
            if (this.instance == null) {
                return this.parent == null ? null : this.parent.getInstance();
            }
            return this.instance;
        }

        private String getPassword() {
            if (this.password == null) {
                return this.parent == null ? null : this.parent.getPassword();
            }
            return this.password;
        }

        protected String getPasswordCommand() {
            if (!this.hasPassword()) {
                return null;
            }
            if (this.passwordfile != null) {
                return " --passwordfile " + this.passwordfile + " ";
            }
            if (this.password != null) {
                return " --password " + this.password + " ";
            }
            if (this.parent != null) {
                return this.parent.getPasswordCommand();
            }
            return null;
        }

        private String getPasswordfile() {
            if (this.passwordfile == null) {
                return this.parent == null ? null : this.parent.getPasswordfile();
            }
            return this.passwordfile;
        }

        protected String getSecure() {
            if (this.secure == null) {
                return this.parent == null ? null : this.parent.getSecure();
            }
            return this.secure;
        }

        protected String getUser() {
            if (this.user == null) {
                return this.parent == null ? DEFAULT_USER : this.parent.getUser();
            }
            return this.user;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.getHost() == null ? DEFAULT_HOST : this.getHost());
            sb.append(':');
            sb.append(this.getPort() == 0 ? DEFAULT_PORT : String.valueOf(this.getPort()));
            return sb.toString();
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setInstance(String instance) {
            this.instance = instance;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setPasswordfile(String passwordfile) {
            this.passwordfile = "\"" + new File(passwordfile).getPath() + "\"";
        }

        public void setSecure(String secure) {
            this.secure = secure;
        }

        public void setUser(String user) {
            this.user = user;
        }

        protected String getCommandParameters(boolean includeInstance) {
            StringBuffer cmdString = new StringBuffer();
            cmdString.append(" --user ").append(this.getUser());
            String pwc = this.getPasswordCommand();
            if (pwc != null) {
                cmdString.append(pwc);
            }
            if (this.getHost() != null) {
                cmdString.append(" --host ").append(this.getHost());
            }
            if (this.getPort() != 0) {
                cmdString.append(" --port ").append(this.getPort());
            }
            if (includeInstance && this.getInstance() != null) {
                cmdString.append(" --instance ").append(this.getInstance());
            }
            if (this.getSecure() != null) {
                cmdString.append(" --secure=").append(this.getSecure());
            }
            return cmdString.toString();
        }

        public Server() {
            this(null);
        }

        public Server getParent() {
            return this.parent;
        }

        public void setParent(Server parent) {
            this.parent = parent;
        }

        public Server(Server parent) {
            this.parent = parent;
        }
    }
}

