/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.bridge.apis;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.RARModuleConfig;
import com.sun.appserv.management.config.ResourceConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.j2ee.J2EEDomain;
import com.sun.appserv.management.j2ee.J2EEManagedObject;
import com.sun.appserv.management.j2ee.ResourceAdapterModule;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.appsrvapi.PortDetector;
import org.netbeans.modules.j2ee.sun.ide.controllers.ControllerUtil;
import org.netbeans.modules.j2ee.sun.util.NodeTypes;

public abstract class AppserverMgmtControllerBase
implements NotificationListener {
    private AMX amxObj;
    private ProxyFactory amxProxyFactory;
    private MBeanServerConnection mbeanServerConn;
    private DeploymentManager deployMgr;
    private static Logger logger = Logger.getLogger("org.netbeans.modules.j2ee.sun");
    protected AppserverConnectionSource appMgmtConnection;
    protected static final String DAS_SERVER_NAME = "server";
    protected static final String BACKEND_COM_SUN_APPSERV_MBEAN_DOMAIN_NAME = "com.sun.appserv";

    public AppserverMgmtControllerBase(DeploymentManager deploymentMgr, AppserverConnectionSource connection) {
        this.deployMgr = deploymentMgr;
        this.appMgmtConnection = connection;
        this.initializeAMXConnectorWithInterceptor();
    }

    public AppserverMgmtControllerBase(AMX amxObject, DeploymentManager deploymentMgr, AppserverConnectionSource connection) {
        this.deployMgr = deploymentMgr;
        this.appMgmtConnection = connection;
        this.initializeAMXConnectorWithInterceptor();
        this.amxObj = amxObject;
    }

    public AppserverMgmtControllerBase(AMX amxObject, AppserverConnectionSource connection) {
        this.appMgmtConnection = connection;
        this.setupProxyFactory();
        this.amxObj = amxObject;
    }

    public AppserverConnectionSource getAppserverConnectionSource() {
        return this.appMgmtConnection;
    }

    private void initializeAMXConnectorWithInterceptor() {
        try {
            ControllerUtil.checkIfServerInDebugMode(this.getDeploymentManager());
            JMXConnector jmxConn = this.appMgmtConnection.getJMXConnector(false);
            jmxConn.addConnectionNotificationListener(this, null, null);
            this.setupProxyFactory();
        }
        catch (RuntimeException rex) {
            this.getLogger().log(Level.FINE, rex.getMessage(), rex);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.FINE, ex.getMessage(), ex);
        }
    }

    private void setupProxyFactory() {
        try {
            ControllerUtil.checkIfServerInDebugMode(this.getDeploymentManager());
            this.amxProxyFactory = ProxyFactory.getInstance((MBeanServerConnection)this.getMBeanServerConnection());
        }
        catch (RuntimeException rex) {
            this.getLogger().log(Level.FINE, rex.getMessage(), rex);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.FINE, ex.getMessage(), ex);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        try {
            JMXConnector jmxConn = this.appMgmtConnection.getJMXConnector(false);
            if (jmxConn != null) {
                jmxConn.close();
            }
        }
        catch (IOException io) {
            this.getLogger().log(Level.FINE, io.getMessage(), io);
        }
        this.appMgmtConnection = null;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        try {
            if (this.mbeanServerConn == null) {
                this.testIfServerInDebugAndLogException();
                this.mbeanServerConn = ControllerUtil.getMBeanServerConnWithInterceptor((SunDeploymentManagerInterface)this.deployMgr, this.appMgmtConnection);
            }
            this.testIfServerInDebugAndLogException();
        }
        catch (RuntimeException rex) {
            this.getLogger().log(Level.FINE, rex.getMessage(), rex);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, e.getMessage(), e);
        }
        return this.mbeanServerConn;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deployMgr;
    }

    public String getName() {
        return this.getAMXObject().getName();
    }

    public AMX getAMXObject() {
        return this.amxObj;
    }

    final DomainRoot getDomainRoot() {
        this.testIfServerInDebug();
        return this.amxProxyFactory.getDomainRoot();
    }

    final DomainConfig getDomainConfig() {
        return this.getDomainRoot().getDomainConfig();
    }

    protected final J2EEDomain getJ2EEDomain() {
        return this.getDomainRoot().getJ2EEDomain();
    }

    protected final QueryMgr getQueryMgr() {
        return this.getDomainRoot().getQueryMgr();
    }

    final ProxyFactory getAMXProxyFactory() {
        return this.amxProxyFactory;
    }

    public Map getJ2EEAndConfigProperties(String nodeType, AMX j2eeMod, AMX configPeer, List propsToIgnore) {
        try {
            Map propsMap = new HashMap();
            if (configPeer == null && j2eeMod != null) {
                configPeer = this.getConfigPeerByNodeTypeAndName(j2eeMod, nodeType);
            }
            if (configPeer != null) {
                propsMap = this.getConfigPropertiesFromBackend(nodeType, configPeer, propsToIgnore);
            }
            if (j2eeMod != null) {
                Map j2eeProps = this.getPropertiesFromBackend(nodeType, j2eeMod, propsToIgnore);
                propsMap.putAll(j2eeProps);
            }
            if (propsMap.size() == 0 || propsMap == null) {
                this.getLogger().log(Level.FINE, "The props in getJ2EE is 0!");
            }
            propsMap = ControllerUtil.modifyEnabledProperty(propsMap, configPeer);
            return propsMap;
        }
        catch (RuntimeException rex) {
            this.getLogger().log(Level.FINE, rex.getMessage(), rex);
            return new HashMap();
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, e.getMessage());
            return new HashMap();
        }
    }

    protected Map getPropertiesFromBackend(String nodeType, AMX res, List propsToIgnore) {
        this.testIfServerInDebug();
        Class intrface = NodeTypes.getAMXInterface(nodeType);
        return ControllerUtil.getAllAttributes(intrface, res, propsToIgnore, this.getMBeanServerConnection(), nodeType);
    }

    protected Map getConfigPropertiesFromBackend(String nodeType, AMX res, List propsToIgnore) {
        this.testIfServerInDebug();
        Class intrface = NodeTypes.getAMXConfigPeerInterface(nodeType);
        return ControllerUtil.getAllAttributes(intrface, res, propsToIgnore, this.getMBeanServerConnection(), nodeType);
    }

    protected AMX getConfigPeerByNodeTypeAndName(AMX amx, String nodeType) {
        this.testIfServerInDebug();
        J2EEManagedObject managedObj = (J2EEManagedObject)amx;
        AMXConfig configPeer = managedObj.getConfigPeer();
        if (configPeer != null) {
            return configPeer;
        }
        String j2eeType = NodeTypes.getAMXConfigPeerJ2EETypeByNodeType(nodeType);
        Set set = this.getQueryMgr().queryJ2EETypeSet(j2eeType);
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            AMX config = (AMX)itr.next();
            if (!config.getName().equals(amx.getName())) continue;
            return config;
        }
        return null;
    }

    protected Map getLogPropertiesFromBackend(AMX res, Map propNames) {
        this.testIfServerInDebug();
        return ControllerUtil.getLogAttributes(res, propNames, this.getMBeanServerConnection());
    }

    public void undeploy() {
        this.testIfServerInDebug();
        DeploymentFacility df = this.createDeploymentFacility();
        JESProgressObject progressObject = null;
        Properties props = null;
        if (this.getAMXObject() instanceof ResourceAdapterModule || this.getAMXObject() instanceof RARModuleConfig) {
            props = new Properties();
            props.put("name", this.getName());
            props.put("cascade", "true");
        }
        if (df.isConnected()) {
            String[] instances = this.getRelevantTargets();
            Target[] targets = df.createTargets(instances);
            progressObject = df.undeploy(targets, this.getName(), (Map)props);
            df.waitFor(progressObject);
        }
        DeploymentStatus ds = progressObject.getCompletedStatus();
        ds.toString();
    }

    private String[] getRelevantTargets() {
        Map serverConfigs = ControllerUtil.getServerInstancesMap(this.getAMXObject());
        Vector<String> instances = new Vector<String>();
        Iterator itr = serverConfigs.values().iterator();
        while (itr.hasNext()) {
            ServerConfig config = (ServerConfig)itr.next();
            boolean contains = config.getDeployedItemRefConfigMap().containsKey(this.getName());
            if (!contains) continue;
            instances.add(config.getName());
        }
        String[] targets = new String[instances.size()];
        for (int i = 0; i < instances.size(); ++i) {
            targets[i] = instances.get(i).toString();
        }
        return targets;
    }

    private DeploymentFacility createDeploymentFacility() {
        DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
        SunDeploymentManagerInterface sunDplmtMgr = (SunDeploymentManagerInterface)this.getDeploymentManager();
        ServerConnectionIdentifier conn = this.createServerConnectionIdentifier(sunDplmtMgr.getHost(), sunDplmtMgr.getPort(), sunDplmtMgr.getUserName(), sunDplmtMgr.getPassword());
        df.connect(conn);
        return df;
    }

    private ServerConnectionIdentifier createServerConnectionIdentifier(String host, int port, String user, String password) {
        ServerConnectionIdentifier conn = new ServerConnectionIdentifier();
        conn.setHostName(host);
        conn.setHostPort(port);
        conn.setUserName(user);
        conn.setPassword(password);
        try {
            if (PortDetector.isSecurePort((String)host, (int)port)) {
                conn.setSecure(true);
            } else {
                conn.setSecure(false);
            }
        }
        catch (Exception ex) {
            conn.setSecure(false);
        }
        return conn;
    }

    protected void removeResourceRef(ResourceConfig resConfig, String resName) {
        this.testIfServerInDebug();
        Map serverConfigs = ControllerUtil.getStandaloneServerInstancesMap((AMX)resConfig);
        Iterator itr = serverConfigs.values().iterator();
        while (itr.hasNext()) {
            StandaloneServerConfig config = (StandaloneServerConfig)itr.next();
            boolean contains = config.getResourceRefConfigMap().containsKey(resName);
            if (!contains) continue;
            config.removeResourceRefConfig(resName);
        }
    }

    protected final Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("org.netbeans.modules.j2ee.sun");
        }
        return logger;
    }

    protected void testIfServerInDebug() {
        try {
            ControllerUtil.checkIfServerInDebugMode(this.getDeploymentManager());
        }
        catch (RuntimeException rex) {
            this.getLogger().log(Level.FINE, rex.getMessage(), rex);
            throw rex;
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, e.getMessage(), e);
        }
    }

    protected void testIfServerInDebugAndLogException() {
        try {
            ControllerUtil.checkIfServerInDebugMode(this.getDeploymentManager());
        }
        catch (RuntimeException rex) {
            this.getLogger().log(Level.FINE, rex.getMessage(), rex);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, e.getMessage(), e);
        }
    }

    public boolean isDeployMgrLocal() {
        return ((SunDeploymentManagerInterface)this.deployMgr).isLocal();
    }
}

