/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.hyperlink;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.HyperlinkProviderManager;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.openide.ErrorManager;

public class HyperlinkOperation
implements MouseListener,
MouseMotionListener,
PropertyChangeListener,
KeyListener {
    private static Cursor HAND_CURSOR = null;
    private JTextComponent component;
    private Document currentDocument;
    private HyperlinkLayer layer;
    private String mimeType;
    private Cursor oldComponentsMouseCursor;
    private boolean hyperlinkUp;
    private boolean listenersSetUp;
    private boolean hyperlinkEnabled;
    private int actionKeyMask;

    public static HyperlinkOperation create(JTextComponent component, String mimeType) {
        return new HyperlinkOperation(component, mimeType);
    }

    private static synchronized Cursor getHandCursor() {
        if (HAND_CURSOR == null) {
            HAND_CURSOR = Cursor.getPredefinedCursor(12);
        }
        return HAND_CURSOR;
    }

    private HyperlinkOperation(JTextComponent component, String mimeType) {
        this.component = component;
        this.mimeType = mimeType;
        this.oldComponentsMouseCursor = null;
        this.hyperlinkUp = false;
        this.listenersSetUp = false;
        this.readSettings();
        if (this.hyperlinkEnabled) {
            EditorUI ui = Utilities.getEditorUI(component);
            this.layer = new HyperlinkLayer();
            if (ui != null) {
                ui.addLayer(this.layer, 1100);
            }
            component.addPropertyChangeListener("document", this);
        }
    }

    private void documentUpdated() {
        if (!this.hyperlinkEnabled) {
            return;
        }
        this.currentDocument = this.component.getDocument();
        if (this.currentDocument instanceof BaseDocument && !this.listenersSetUp) {
            this.component.addMouseListener(this);
            this.component.addMouseMotionListener(this);
            this.component.addKeyListener(this);
            this.listenersSetUp = true;
        }
    }

    private void readSettings() {
        String hyperlinkActivationKeyPropertyValue = System.getProperty("org.netbeans.lib.editor.hyperlink.HyperlinkOperation.activationKey");
        if (hyperlinkActivationKeyPropertyValue != null) {
            if ("off".equals(hyperlinkActivationKeyPropertyValue)) {
                this.hyperlinkEnabled = false;
                this.actionKeyMask = -1;
            } else {
                this.hyperlinkEnabled = true;
                this.actionKeyMask = -1;
                for (int cntr = 0; cntr < hyperlinkActivationKeyPropertyValue.length(); ++cntr) {
                    int localMask = 0;
                    switch (hyperlinkActivationKeyPropertyValue.charAt(cntr)) {
                        case 'S': {
                            localMask = 64;
                            break;
                        }
                        case 'C': {
                            localMask = 128;
                            break;
                        }
                        case 'A': {
                            localMask = 512;
                            break;
                        }
                        case 'M': {
                            localMask = 256;
                            break;
                        }
                        default: {
                            ErrorManager.getDefault().log(16, "Incorrect value of org.netbeans.lib.editor.hyperlink.HyperlinkOperation.activationKey property (only letters CSAM are allowed): " + hyperlinkActivationKeyPropertyValue.charAt(cntr));
                        }
                    }
                    if (localMask == 0) {
                        this.actionKeyMask = -1;
                        break;
                    }
                    if (this.actionKeyMask == -1) {
                        this.actionKeyMask = localMask;
                        continue;
                    }
                    this.actionKeyMask |= localMask;
                }
                if (this.actionKeyMask == -1) {
                    ErrorManager.getDefault().log(16, "Some problem with property org.netbeans.lib.editor.hyperlink.HyperlinkOperation.activationKey, more information might be given above. Falling back to the default behaviour.");
                } else {
                    return;
                }
            }
        }
        this.hyperlinkEnabled = true;
        Object activation = Settings.getValue(Utilities.getKitClass(this.component), "hyperlink-activation-modifiers");
        this.actionKeyMask = activation != null && activation instanceof Integer ? (Integer)activation : 128;
    }

    public void mouseMoved(MouseEvent e) {
        if (this.isHyperlinkEvent(e)) {
            int position = this.component.viewToModel(e.getPoint());
            if (position < 0) {
                this.unHyperlink(true);
                return;
            }
            this.performHyperlinking(position);
        } else {
            this.unHyperlink(true);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    private boolean isHyperlinkEvent(InputEvent e) {
        return ((e.getModifiers() | e.getModifiersEx()) & this.actionKeyMask) == this.actionKeyMask;
    }

    private void performHyperlinking(int position) {
        HyperlinkProvider provider = this.findProvider(position);
        if (provider != null) {
            int[] offsets = provider.getHyperlinkSpan(this.component.getDocument(), position);
            if (offsets != null) {
                this.makeHyperlink(offsets[0], offsets[1]);
            }
        } else {
            this.unHyperlink(true);
        }
    }

    private void performAction(int position) {
        HyperlinkProvider provider = this.findProvider(position);
        if (provider != null) {
            this.unHyperlink(true);
            this.component.getCaret().setDot(position);
            JumpList.checkAddEntry(this.component, position);
            provider.performClickAction(this.component.getDocument(), position);
        }
    }

    private HyperlinkProvider findProvider(int position) {
        Object mimeTypeObj = this.component.getDocument().getProperty("mimeType");
        String mimeType = mimeTypeObj instanceof String ? (String)mimeTypeObj : this.mimeType;
        List providers = HyperlinkProviderManager.getDefault().getHyperlinkProviders(mimeType);
        Iterator i = providers.iterator();
        while (i.hasNext()) {
            HyperlinkProvider provider = (HyperlinkProvider)i.next();
            if (!provider.isHyperlinkPoint(this.component.getDocument(), position)) continue;
            return provider;
        }
        return null;
    }

    private synchronized void makeHyperlink(int start, int end) {
        boolean makeCursorSnapshot = true;
        if (this.hyperlinkUp) {
            this.unHyperlink(false);
            makeCursorSnapshot = false;
        }
        try {
            Position startPos = this.layer.hyperlinkStart = this.component.getDocument().createPosition(start);
            Position endPos = this.layer.hyperlinkEnd = this.component.getDocument().createPosition(end);
            this.hyperlinkUp = true;
            this.damageRange(startPos, endPos);
            if (makeCursorSnapshot) {
                this.oldComponentsMouseCursor = this.component.isCursorSet() ? this.component.getCursor() : null;
                this.component.setCursor(HyperlinkOperation.getHandCursor());
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            this.unHyperlink(false);
        }
    }

    private void damageRange(final Position start, final Position end) {
        if (start != null && end != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HyperlinkOperation.this.component.getDocument().render(new Runnable(){

                        public void run() {
                            int startIndex = start.getOffset();
                            int endIndex = end.getOffset();
                            HyperlinkOperation.this.component.getUI().damageRange(HyperlinkOperation.this.component, startIndex, endIndex);
                        }
                    });
                }
            });
        }
    }

    private synchronized void unHyperlink(boolean removeCursor) {
        if (!this.hyperlinkUp) {
            return;
        }
        Position start = this.layer.hyperlinkStart;
        Position end = this.layer.hyperlinkEnd;
        this.layer.hyperlinkStart = null;
        this.layer.hyperlinkEnd = null;
        this.damageRange(start, end);
        if (removeCursor) {
            if (this.component.isCursorSet() && this.component.getCursor() == HyperlinkOperation.getHandCursor()) {
                this.component.setCursor(this.oldComponentsMouseCursor);
            }
            this.oldComponentsMouseCursor = null;
        }
        this.hyperlinkUp = false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.currentDocument != this.component.getDocument()) {
            this.documentUpdated();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if ((e.getModifiers() & this.actionKeyMask) == 0) {
            this.unHyperlink(true);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (this.isHyperlinkEvent(e) && !e.isPopupTrigger() && e.getClickCount() == 1 && e.getButton() == 1) {
            int position = this.component.viewToModel(e.getPoint());
            if (position < 0) {
                return;
            }
            this.performAction(position);
        }
    }

    private static class HyperlinkLayer
    extends DrawLayer.AbstractLayer {
        private Position hyperlinkStart = null;
        private Position hyperlinkEnd = null;
        public static final String NAME = "hyperlink-layer";
        public static final int VISIBILITY = 1050;
        private boolean initialized = false;
        private static Coloring hoverColoring = new Coloring(null, 0, Color.BLUE, null, Color.BLUE, null);

        public HyperlinkLayer() {
            super(NAME);
        }

        private void checkDocument(Document doc) {
        }

        public boolean extendsEOL() {
            return true;
        }

        public synchronized void init(DrawContext ctx) {
            if (!this.initialized) {
                BaseDocument doc = ctx.getEditorUI().getDocument();
                this.initialized = true;
                this.checkDocument(doc);
            }
            if (this.isActive()) {
                this.setNextActivityChangeOffset(this.hyperlinkStart.getOffset());
            }
        }

        private boolean isActive() {
            return this.hyperlinkStart != null && this.hyperlinkEnd != null;
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            return this.isActive();
        }

        private boolean isIn(int offset) {
            return offset >= this.hyperlinkStart.getOffset() && offset < this.hyperlinkEnd.getOffset();
        }

        public void updateContext(DrawContext ctx) {
            if (!this.isActive()) {
                return;
            }
            int currentOffset = ctx.getFragmentOffset();
            if (this.isIn(currentOffset)) {
                hoverColoring.apply(ctx);
                if (this.isIn(currentOffset + ctx.getFragmentLength())) {
                    this.setNextActivityChangeOffset(currentOffset + ctx.getFragmentLength());
                }
            }
        }
    }
}

