/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.text.CharacterIterator;

public class CharacterArrayIterator
implements CharacterIterator {
    char[] chars;
    int beginIndex;
    int endIndex;
    int index;

    public CharacterArrayIterator(char[] chars, int beginIndex, int endIndex) {
        this.chars = chars;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.index = beginIndex;
    }

    private char currentChar() {
        return this.index >= this.beginIndex && this.index < this.endIndex ? this.chars[this.index] : (char)'\uffff';
    }

    public char first() {
        this.index = this.beginIndex;
        return this.currentChar();
    }

    public char last() {
        this.index = this.endIndex - 1;
        return this.currentChar();
    }

    public char current() {
        return this.currentChar();
    }

    public char next() {
        this.index = Math.min(this.index + 1, this.endIndex);
        return this.currentChar();
    }

    public char previous() {
        if (this.index <= this.beginIndex) {
            return '\uffff';
        }
        return this.chars[--this.index];
    }

    public char setIndex(int position) {
        if (position < this.beginIndex || position >= this.endIndex) {
            throw new IllegalArgumentException();
        }
        this.index = position;
        return this.currentChar();
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public Object clone() {
        return new CharacterArrayIterator(this.chars, this.beginIndex, this.endIndex);
    }
}

