/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.LineElement;
import org.netbeans.editor.LineRootElement;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxUpdateTokens;

final class FixLineSyntaxState {
    private static final boolean debug = false;
    private final DocumentEvent evt;
    private int syntaxUpdateOffset;
    private List syntaxUpdateTokenList = Collections.EMPTY_LIST;
    static final /* synthetic */ boolean $assertionsDisabled;

    FixLineSyntaxState(DocumentEvent evt) {
        this.evt = evt;
    }

    final int getSyntaxUpdateOffset() {
        return this.syntaxUpdateOffset;
    }

    final List getSyntaxUpdateTokenList() {
        return this.syntaxUpdateTokenList;
    }

    static void invalidateAllSyntaxStateInfos(BaseDocument doc) {
        LineRootElement lineRoot = FixLineSyntaxState.getLineRoot(doc);
        int elemCount = lineRoot.getElementCount();
        for (int i = elemCount - 1; i >= 0; --i) {
            LineElement line = (LineElement)lineRoot.getElement(i);
            line.clearSyntaxStateInfo();
        }
    }

    static void prepareSyntax(BaseDocument doc, Segment text, Syntax syntax, int reqPos, int reqLen, boolean forceLastBuffer, boolean forceNotLastBuffer) throws BadLocationException {
        int preScan;
        if (reqPos < 0 || reqLen < 0 || reqPos + reqLen > doc.getLength()) {
            throw new BadLocationException("reqPos=" + reqPos + ", reqLen=" + reqLen + ", doc.getLength()=" + doc.getLength(), -1);
        }
        LineRootElement lineRoot = FixLineSyntaxState.getLineRoot(doc);
        int reqPosLineIndex = lineRoot.getElementIndex(reqPos);
        Element reqPosLineElem = lineRoot.getElement(reqPosLineIndex);
        Syntax.StateInfo stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(doc, reqPosLineIndex);
        int lineStartOffset = reqPosLineElem.getStartOffset();
        int n = preScan = stateInfo != null ? stateInfo.getPreScan() : 0;
        if (preScan > lineStartOffset) {
            preScan = lineStartOffset;
        }
        int intraLineLength = reqPos - lineStartOffset;
        doc.getText(lineStartOffset - preScan, preScan + intraLineLength + reqLen, text);
        text.offset += preScan;
        text.count -= preScan;
        syntax.load(stateInfo, text.array, text.offset, intraLineLength, false, reqPos);
        while (syntax.nextToken() != null) {
        }
        text.offset += intraLineLength;
        text.count -= intraLineLength;
        boolean forceLB = forceNotLastBuffer ? false : forceLastBuffer || reqPos + reqLen >= doc.getLength();
        syntax.relocate(text.array, text.offset, text.count, forceLB, reqPos + reqLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Syntax.StateInfo getValidSyntaxStateInfo(BaseDocument doc, int lineIndex) throws BadLocationException {
        if (lineIndex == 0) {
            return null;
        }
        LineRootElement lineRoot = FixLineSyntaxState.getLineRoot(doc);
        LineElement lineElem = (LineElement)lineRoot.getElement(lineIndex);
        Syntax.StateInfo stateInfo = lineElem.getSyntaxStateInfo();
        if (lineIndex > 0 && stateInfo == null) {
            int validLineIndex;
            LineElement validLineElem = null;
            for (validLineIndex = lineIndex - 1; validLineIndex > 0 && (stateInfo = (validLineElem = (LineElement)lineRoot.getElement(validLineIndex)).getSyntaxStateInfo()) == null; --validLineIndex) {
            }
            Segment text = DocumentUtilities.SEGMENT_CACHE.getSegment();
            try {
                Syntax syntax = doc.getFreeSyntax();
                try {
                    int validLineOffset;
                    int lineElemOffset = lineElem.getStartOffset();
                    int preScan = 0;
                    if (validLineIndex > 0) {
                        validLineOffset = validLineElem.getStartOffset();
                        preScan = stateInfo.getPreScan();
                    } else {
                        validLineOffset = 0;
                        stateInfo = null;
                    }
                    doc.getText(validLineOffset - preScan, lineElemOffset - validLineOffset + preScan, text);
                    text.offset += preScan;
                    text.count -= preScan;
                    syntax.load(stateInfo, text.array, text.offset, text.count, false, lineElemOffset);
                    int textEndOffset = text.offset + text.count;
                    do {
                        validLineElem = (LineElement)lineRoot.getElement(++validLineIndex);
                        int scanLength = validLineOffset;
                        validLineOffset = validLineElem.getStartOffset();
                        scanLength = validLineOffset - scanLength;
                        syntax.relocate(text.array, syntax.getOffset(), scanLength, false, validLineOffset);
                        while (syntax.nextToken() != null) {
                        }
                        validLineElem.updateSyntaxStateInfo(syntax);
                    } while (validLineIndex != lineIndex);
                }
                finally {
                    doc.releaseSyntax(syntax);
                }
            }
            finally {
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
            }
        }
        return lineElem.getSyntaxStateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(boolean undo) {
        SyntaxUpdateTokens suTokens = (SyntaxUpdateTokens)this.evt.getDocument().getProperty(SyntaxUpdateTokens.class);
        if (suTokens != null) {
            suTokens.syntaxUpdateStart();
        }
        try {
            this.syntaxUpdateOffset = this.fixSyntaxStateInfos(undo);
        }
        finally {
            if (suTokens != null) {
                this.syntaxUpdateTokenList = Collections.unmodifiableList(new ArrayList(suTokens.syntaxUpdateEnd()));
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int fixSyntaxStateInfos(boolean undo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static int getTokenSafeOffset(BaseDocument doc, int offset) {
        if (offset == 0) {
            return offset;
        }
        try {
            LineRootElement lineRoot = FixLineSyntaxState.getLineRoot(doc);
            int lineIndex = lineRoot.getElementIndex(offset);
            Element lineElem = lineRoot.getElement(lineIndex);
            int lineStartOffset = lineElem.getStartOffset();
            Syntax.StateInfo stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(doc, lineIndex);
            if (offset == lineStartOffset && stateInfo.getPreScan() == 0) {
                return offset;
            }
            int lineCount = lineRoot.getElementCount();
            while (++lineIndex < lineCount) {
                lineElem = lineRoot.getElement(lineIndex);
                stateInfo = FixLineSyntaxState.getValidSyntaxStateInfo(doc, lineIndex);
                lineStartOffset = lineElem.getStartOffset();
                if (lineStartOffset - stateInfo.getPreScan() < offset) continue;
                return lineStartOffset;
            }
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e.toString());
        }
        return doc.getLength();
    }

    private static LineRootElement getLineRoot(Document doc) {
        return (LineRootElement)((Object)doc.getDefaultRootElement());
    }

    private static void checkConsistency(Document doc) {
        LineRootElement lineRoot = FixLineSyntaxState.getLineRoot(doc);
        int lineCount = lineRoot.getElementCount();
        for (int i = 1; i < lineCount; ++i) {
            LineElement elem = (LineElement)lineRoot.getElement(i);
            if (!$assertionsDisabled && elem.getSyntaxStateInfo() == null) {
                throw new AssertionError((Object)("Syntax state null at line " + i + " of " + lineCount));
            }
        }
    }

    public static String lineInfosToString(Document doc) {
        StringBuffer sb = new StringBuffer();
        LineRootElement lineRoot = FixLineSyntaxState.getLineRoot(doc);
        int lineCount = lineRoot.getElementCount();
        for (int i = 0; i < lineCount; ++i) {
            LineElement elem = (LineElement)lineRoot.getElement(i);
            sb.append("[" + i + "]: lineStartOffset=" + elem.getStartOffset() + ", info: " + elem.getSyntaxStateInfo() + "\n");
        }
        return sb.toString();
    }

    UndoableEdit createBeforeLineUndo() {
        return new BeforeLineUndo();
    }

    UndoableEdit createAfterLineUndo() {
        return new AfterLineUndo();
    }

    static {
        $assertionsDisabled = !FixLineSyntaxState.class.desiredAssertionStatus();
    }

    final class AfterLineUndo
    extends AbstractUndoableEdit {
        AfterLineUndo() {
        }

        public void redo() throws CannotRedoException {
            FixLineSyntaxState.this.update(false);
            super.redo();
        }
    }

    final class BeforeLineUndo
    extends AbstractUndoableEdit {
        BeforeLineUndo() {
        }

        FixLineSyntaxState getMaster() {
            return FixLineSyntaxState.this;
        }

        public void undo() throws CannotUndoException {
            FixLineSyntaxState.this.update(true);
            super.undo();
        }
    }
}

