/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.html;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.im.InputContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.html.HTMLCompletion;
import org.netbeans.editor.ext.html.HTMLDrawLayerFactory;
import org.netbeans.editor.ext.html.HTMLFormatter;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.html.HTMLAutoCompletion;
import org.netbeans.modules.editor.html.NbReaderProvider;
import org.netbeans.modules.html.editor.folding.HTMLFoldTypes;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HTMLKit
extends NbEditorKit
implements HelpCtx.Provider {
    static final long serialVersionUID = -1381945567613910297L;
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String shiftInsertBreakAction = "shift-insert-break";
    public static final String collapseAllCommentsAction = "collapse-all-comment-folds";
    public static final String expandAllCommentsAction = "expand-all-comment-folds";
    private static boolean setupReadersInitialized = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$InputStream;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HTMLKit.class);
    }

    public HTMLKit() {
        if (!setupReadersInitialized) {
            NbReaderProvider.setupReaders();
            setupReadersInitialized = true;
        }
    }

    public String getContentType() {
        return HTML_MIME_TYPE;
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return null;
    }

    protected void initDocument(BaseDocument doc) {
        doc.addDocumentListener((DocumentListener)new HTMLDrawLayerFactory.TagParenWatcher());
    }

    public Syntax createSyntax(Document doc) {
        return new HTMLSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new HTMLSyntaxSupport(doc);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return null;
    }

    public Completion createCompletionForProvider(ExtEditorUI extEditorUI) {
        return new HTMLCompletion(extEditorUI);
    }

    public Formatter createFormatter() {
        return new HTMLFormatter(((Object)((Object)this)).getClass());
    }

    public void install(JEditorPane c) {
        super.install(c);
        c.setTransferHandler(new HTMLTransferHandler());
    }

    protected Action[] createActions() {
        Action[] HTMLActions = new Action[]{new HTMLDefaultKeyTypedAction(), new HTMLDeleteCharAction("delete-previous", false), new HTMLDeleteCharAction("delete-next", true), new HTMLShiftBreakAction(), new MatchBraceAction("match-brace", false), new MatchBraceAction("selection-match-brace", true), new HTMLGenerateFoldPopupAction(), new CollapseAllCommentsFolds(), new ExpandAllCommentsFolds()};
        return TextAction.augmentList(super.createActions(), HTMLActions);
    }

    private static class BasicTransferable
    implements Transferable,
    UIResource {
        protected String plainData;
        protected String htmlData;
        private static DataFlavor[] htmlFlavors;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;

        public BasicTransferable(String plainData, String htmlData) {
            this.plainData = plainData;
            this.htmlData = htmlData;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nRicher = richerFlavors != null ? richerFlavors.length : 0;
            int nHTML = this.isHTMLSupported() ? htmlFlavors.length : 0;
            int nPlain = this.isPlainSupported() ? plainFlavors.length : 0;
            int nString = this.isPlainSupported() ? stringFlavors.length : 0;
            int nFlavors = nRicher + nHTML + nPlain + nString;
            DataFlavor[] flavors = new DataFlavor[nFlavors];
            int nDone = 0;
            if (nRicher > 0) {
                System.arraycopy(richerFlavors, 0, flavors, nDone, nRicher);
                nDone += nRicher;
            }
            if (nHTML > 0) {
                System.arraycopy(htmlFlavors, 0, flavors, nDone, nHTML);
                nDone += nHTML;
            }
            if (nPlain > 0) {
                System.arraycopy(plainFlavors, 0, flavors, nDone, nPlain);
                nDone += nPlain;
            }
            if (nString > 0) {
                System.arraycopy(stringFlavors, 0, flavors, nDone, nString);
                nDone += nString;
            }
            return flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            if (this.isRicherFlavor(flavor)) {
                return this.getRicherData(flavor);
            }
            if (this.isHTMLFlavor(flavor)) {
                String data = this.getHTMLData();
                data = data == null ? "" : data;
                if ((class$java$lang$String == null ? (class$java$lang$String = HTMLKit.class$("java.lang.String")) : class$java$lang$String).equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = HTMLKit.class$("java.io.Reader")) : class$java$io$Reader).equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = HTMLKit.class$("java.io.InputStream")) : class$java$io$InputStream).equals(flavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(data.getBytes());
                }
            } else if (this.isPlainFlavor(flavor)) {
                String data = this.getPlainData();
                data = data == null ? "" : data;
                if ((class$java$lang$String == null ? (class$java$lang$String = HTMLKit.class$("java.lang.String")) : class$java$lang$String).equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = HTMLKit.class$("java.io.Reader")) : class$java$io$Reader).equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = HTMLKit.class$("java.io.InputStream")) : class$java$io$InputStream).equals(flavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(data.getBytes());
                }
            } else if (this.isStringFlavor(flavor)) {
                String data = this.getPlainData();
                data = data == null ? "" : data;
                return data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        protected boolean isRicherFlavor(DataFlavor flavor) {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nFlavors = richerFlavors != null ? richerFlavors.length : 0;
            for (int i = 0; i < nFlavors; ++i) {
                if (!richerFlavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected DataFlavor[] getRicherFlavors() {
            return null;
        }

        protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
            return null;
        }

        protected boolean isHTMLFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = htmlFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHTMLSupported() {
            return this.htmlData != null;
        }

        protected String getHTMLData() {
            return this.htmlData;
        }

        protected boolean isPlainFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = plainFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = stringFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        static {
            try {
                htmlFlavors = new DataFlavor[3];
                BasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
                BasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
                BasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
                plainFlavors = new DataFlavor[3];
                BasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                BasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                BasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                stringFlavors = new DataFlavor[2];
                BasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                BasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException cle) {
                System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
            }
        }
    }

    static class HTMLTransferHandler
    extends TransferHandler
    implements UIResource {
        private JTextComponent exportComp;
        private boolean shouldRemove;
        private int p0;
        private int p1;

        HTMLTransferHandler() {
        }

        protected DataFlavor getImportFlavor(DataFlavor[] flavors, JTextComponent c) {
            DataFlavor plainFlavor = null;
            DataFlavor refFlavor = null;
            DataFlavor stringFlavor = null;
            if (c instanceof JEditorPane) {
                for (int i = 0; i < flavors.length; ++i) {
                    String mime = flavors[i].getMimeType();
                    if (mime.startsWith(((JEditorPane)c).getEditorKit().getContentType())) continue;
                    if (plainFlavor == null && mime.startsWith("text/plain")) {
                        plainFlavor = flavors[i];
                        continue;
                    }
                    if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == (class$java$lang$String == null ? HTMLKit.class$("java.lang.String") : class$java$lang$String)) {
                        refFlavor = flavors[i];
                        continue;
                    }
                    if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
                    stringFlavor = flavors[i];
                }
                if (plainFlavor != null) {
                    return plainFlavor;
                }
                if (refFlavor != null) {
                    return refFlavor;
                }
                if (stringFlavor != null) {
                    return stringFlavor;
                }
                return null;
            }
            for (int i = 0; i < flavors.length; ++i) {
                String mime = flavors[i].getMimeType();
                if (mime.startsWith("text/plain")) {
                    return flavors[i];
                }
                if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == (class$java$lang$String == null ? HTMLKit.class$("java.lang.String") : class$java$lang$String)) {
                    refFlavor = flavors[i];
                    continue;
                }
                if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
                stringFlavor = flavors[i];
            }
            if (refFlavor != null) {
                return refFlavor;
            }
            if (stringFlavor != null) {
                return stringFlavor;
            }
            return null;
        }

        protected void handleReaderImport(Reader in, JTextComponent c, boolean useRead) throws BadLocationException, IOException {
            if (useRead) {
                int startPosition = c.getSelectionStart();
                int endPosition = c.getSelectionEnd();
                int length = endPosition - startPosition;
                EditorKit kit = c.getUI().getEditorKit(c);
                Document doc = c.getDocument();
                if (length > 0) {
                    doc.remove(startPosition, length);
                }
                kit.read(in, doc, startPosition);
            } else {
                int nch;
                char[] buff = new char[1024];
                boolean lastWasCR = false;
                StringBuffer sbuff = null;
                while ((nch = in.read(buff, 0, buff.length)) != -1) {
                    if (sbuff == null) {
                        sbuff = new StringBuffer(nch);
                    }
                    int last = 0;
                    block5: for (int counter = 0; counter < nch; ++counter) {
                        switch (buff[counter]) {
                            case '\r': {
                                if (lastWasCR) {
                                    if (counter == 0) {
                                        sbuff.append('\n');
                                        continue block5;
                                    }
                                    buff[counter - 1] = 10;
                                    continue block5;
                                }
                                lastWasCR = true;
                                continue block5;
                            }
                            case '\n': {
                                if (!lastWasCR) continue block5;
                                if (counter > last + 1) {
                                    sbuff.append(buff, last, counter - last - 1);
                                }
                                lastWasCR = false;
                                last = counter;
                                continue block5;
                            }
                            default: {
                                if (!lastWasCR) continue block5;
                                if (counter == 0) {
                                    sbuff.append('\n');
                                } else {
                                    buff[counter - 1] = 10;
                                }
                                lastWasCR = false;
                            }
                        }
                    }
                    if (last >= nch) continue;
                    if (lastWasCR) {
                        if (last >= nch - 1) continue;
                        sbuff.append(buff, last, nch - last - 1);
                        continue;
                    }
                    sbuff.append(buff, last, nch - last);
                }
                if (lastWasCR) {
                    sbuff.append('\n');
                }
                c.replaceSelection(sbuff != null ? sbuff.toString() : "");
            }
        }

        public int getSourceActions(JComponent c) {
            int actions = 0;
            if (!(c instanceof JPasswordField)) {
                actions = ((JTextComponent)c).isEditable() ? 3 : 1;
            }
            return actions;
        }

        protected Transferable createTransferable(JComponent comp) {
            this.exportComp = (JTextComponent)comp;
            this.shouldRemove = true;
            this.p0 = this.exportComp.getSelectionStart();
            this.p1 = this.exportComp.getSelectionEnd();
            return this.p0 != this.p1 ? new HTMLTransferable(this.exportComp, this.p0, this.p1) : null;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            if (this.shouldRemove && action == 2) {
                HTMLTransferable t = (HTMLTransferable)data;
                t.removeText();
            }
            this.exportComp = null;
        }

        public boolean importData(JComponent comp, Transferable t) {
            JTextComponent c = (JTextComponent)comp;
            if (c == this.exportComp && c.getCaretPosition() >= this.p0 && c.getCaretPosition() <= this.p1) {
                this.shouldRemove = false;
                return true;
            }
            boolean imported = false;
            DataFlavor importFlavor = this.getImportFlavor(t.getTransferDataFlavors(), c);
            if (importFlavor != null) {
                try {
                    InputContext ic;
                    JEditorPane ep;
                    boolean useRead = false;
                    if (comp instanceof JEditorPane && !(ep = (JEditorPane)comp).getContentType().startsWith("text/plain") && importFlavor.getMimeType().startsWith(ep.getContentType())) {
                        useRead = true;
                    }
                    if ((ic = c.getInputContext()) != null) {
                        ic.endComposition();
                    }
                    Reader r = importFlavor.getReaderForText(t);
                    this.handleReaderImport(r, c, useRead);
                    imported = true;
                }
                catch (UnsupportedFlavorException ufe) {
                }
                catch (BadLocationException ble) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return imported;
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            JTextComponent c = (JTextComponent)comp;
            if (!c.isEditable() || !c.isEnabled()) {
                return false;
            }
            return this.getImportFlavor(flavors, c) != null;
        }

        static class HTMLTransferable
        extends BasicTransferable {
            Position p0;
            Position p1;
            String mimeType;
            String richText;
            JTextComponent c;

            HTMLTransferable(JTextComponent c, int start, int end) {
                super(null, null);
                this.c = c;
                Document doc = c.getDocument();
                try {
                    this.p0 = doc.createPosition(start);
                    this.p1 = doc.createPosition(end);
                    this.plainData = c.getSelectedText();
                    if (c instanceof JEditorPane) {
                        JEditorPane ep = (JEditorPane)c;
                        this.mimeType = ep.getContentType();
                        if (this.mimeType.startsWith("text/plain")) {
                            return;
                        }
                        StringWriter sw = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                        ep.getEditorKit().write(sw, doc, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                        if (this.mimeType.startsWith(HTMLKit.HTML_MIME_TYPE)) {
                            this.htmlData = sw.toString();
                        } else {
                            this.richText = sw.toString();
                        }
                    }
                }
                catch (BadLocationException ble) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }

            void removeText() {
                if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                    try {
                        Document doc = this.c.getDocument();
                        doc.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            protected DataFlavor[] getRicherFlavors() {
                if (this.richText == null) {
                    return null;
                }
                try {
                    DataFlavor[] flavors = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                    return flavors;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.richText == null) {
                    return null;
                }
                if ((class$java$lang$String == null ? (class$java$lang$String = HTMLKit.class$("java.lang.String")) : class$java$lang$String).equals(flavor.getRepresentationClass())) {
                    return this.richText;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = HTMLKit.class$("java.io.Reader")) : class$java$io$Reader).equals(flavor.getRepresentationClass())) {
                    return new StringReader(this.richText);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = HTMLKit.class$("java.io.InputStream")) : class$java$io$InputStream).equals(flavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(this.richText.getBytes());
                }
                throw new UnsupportedFlavorException(flavor);
            }
        }
    }

    public static class CollapseAllCommentsFolds
    extends BaseAction {
        public CollapseAllCommentsFolds() {
            super(HTMLKit.collapseAllCommentsAction);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$html$HTMLKit == null ? (class$org$netbeans$modules$editor$html$HTMLKit = HTMLKit.class$("org.netbeans.modules.editor.html.HTMLKit")) : class$org$netbeans$modules$editor$html$HTMLKit)).getString(HTMLKit.collapseAllCommentsAction));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$html$HTMLKit == null ? (class$org$netbeans$modules$editor$html$HTMLKit = HTMLKit.class$("org.netbeans.modules.editor.html.HTMLKit")) : class$org$netbeans$modules$editor$html$HTMLKit)).getString("popup-collapse-all-comment-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, (FoldType)HTMLFoldTypes.COMMENT);
        }
    }

    public static class ExpandAllCommentsFolds
    extends BaseAction {
        public ExpandAllCommentsFolds() {
            super(HTMLKit.expandAllCommentsAction);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$html$HTMLKit == null ? (class$org$netbeans$modules$editor$html$HTMLKit = HTMLKit.class$("org.netbeans.modules.editor.html.HTMLKit")) : class$org$netbeans$modules$editor$html$HTMLKit)).getString(HTMLKit.expandAllCommentsAction));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$html$HTMLKit == null ? (class$org$netbeans$modules$editor$html$HTMLKit = HTMLKit.class$("org.netbeans.modules.editor.html.HTMLKit")) : class$org$netbeans$modules$editor$html$HTMLKit)).getString("popup-expand-all-comment-folds"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.expand((FoldHierarchy)hierarchy, (FoldType)HTMLFoldTypes.COMMENT);
        }
    }

    public static class HTMLGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        protected void addAdditionalItems(JTextComponent target, JMenu menu) {
            this.addAction(target, menu, HTMLKit.collapseAllCommentsAction);
            this.addAction(target, menu, HTMLKit.expandAllCommentsAction);
        }
    }

    public static class MatchBraceAction
    extends ExtKit.MatchBraceAction {
        private boolean select;

        public MatchBraceAction(String name, boolean select) {
            super(name, select);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = Utilities.getDocument((JTextComponent)target);
                    int dotPos = caret.getDot();
                    ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
                    TokenItem token = sup.getTokenChain(dotPos - 1, dotPos);
                    if (token != null && token.getTokenContextPath().contains(HTMLTokenContext.contextPath)) {
                        int[] matchBlk;
                        if (dotPos > 0 && (matchBlk = sup.findMatchingBlock(dotPos - 1, false)) != null) {
                            if (this.select) {
                                caret.moveDot(matchBlk[1]);
                            } else {
                                caret.setDot(matchBlk[1]);
                            }
                        }
                    } else {
                        super.actionPerformed(evt, target);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class HTMLShiftBreakAction
    extends BaseAction {
        static final long serialVersionUID = 4004043376345356061L;

        public HTMLShiftBreakAction() {
            super(HTMLKit.shiftInsertBreakAction, 14);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            Completion completion;
            if (target != null && (completion = ExtUtilities.getCompletion((JTextComponent)target)) != null && completion.isPaneVisible() && !completion.substituteText(true)) {
                completion.refresh(false);
            }
        }
    }

    public static class HTMLDeleteCharAction
    extends BaseKit.DeleteCharAction {
        public HTMLDeleteCharAction(String name, boolean nextChar) {
            super(name, nextChar);
        }

        protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
            super.charBackspaced(doc, dotPos, caret, ch);
            HTMLAutoCompletion.charDeleted(doc, dotPos, caret, ch);
        }
    }

    public static class HTMLDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            super.insertString(doc, dotPos, caret, str, overwrite);
            HTMLAutoCompletion.charInserted(doc, dotPos, caret, str.charAt(0));
        }
    }
}

