/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SuggestionTypeProcessor
implements InstanceCookie,
XMLDataObject.Processor {
    static final String DTD_PUBLIC_ID = "-//NetBeans//DTD suggestion type 1.0//EN";
    static final String DTD_SYSTEM_ID = "http://www.netbeans.org/dtds/suggestion-type-1_0.dtd";
    static final String TAG_TYPE = "type";
    static final String ATTR_TYPE_NAME = "name";
    static final String ATTR_TYPE_LOCALIZING_BUNDLE = "localizing_bundle";
    static final String ATTR_TYPE_DESCRIPTION_KEY = "description_key";
    static final String ATTR_TYPE_LONGDESCRIPTION_KEY = "long_description_key";
    static final String ATTR_TYPE_ICON = "icon";
    static final String TAG_TYPE_ACTIONS = "actions";
    static final String TAG_TYPE_ACTION = "action";
    static final String ATTR_ACTION_CLASS = "class";
    private XMLDataObject xmlDataObject;
    private SuggestionType suggestionType;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public void attachTo(XMLDataObject xmlDO) {
        this.xmlDataObject = xmlDO;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.suggestionType != null) {
            return this.suggestionType;
        }
        this.parse();
        return this.suggestionType;
    }

    public Class instanceClass() {
        return SuggestionType.class;
    }

    public String instanceName() {
        return this.instanceClass().getName();
    }

    private synchronized SuggestionType parse() {
        if (this.suggestionType == null) {
            try {
                XMLReader reader = XMLUtil.createXMLReader((boolean)false);
                TypeHandler handler = new TypeHandler();
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.setEntityResolver(handler);
                reader.parse(new InputSource(this.xmlDataObject.getPrimaryFile().getInputStream()));
                this.suggestionType = handler.getSuggestionType();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return this.suggestionType;
    }

    private static class TypeHandler
    extends DefaultHandler {
        private SuggestionType type = null;
        String id = null;
        List actions = null;
        String localizer = null;
        String key = null;
        String longkey = null;
        URL icon = null;

        private TypeHandler() {
        }

        SuggestionType getSuggestionType() {
            return this.type;
        }

        public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
            if (SuggestionTypeProcessor.TAG_TYPE.equals(name)) {
                this.id = attrs.getValue(SuggestionTypeProcessor.ATTR_TYPE_NAME);
                this.actions = null;
                this.localizer = attrs.getValue(SuggestionTypeProcessor.ATTR_TYPE_LOCALIZING_BUNDLE);
                this.key = attrs.getValue(SuggestionTypeProcessor.ATTR_TYPE_DESCRIPTION_KEY);
                this.longkey = attrs.getValue(SuggestionTypeProcessor.ATTR_TYPE_LONGDESCRIPTION_KEY);
                this.icon = null;
                String ur = attrs.getValue(SuggestionTypeProcessor.ATTR_TYPE_ICON);
                if (ur != null) {
                    try {
                        this.icon = new URL(ur);
                    }
                    catch (MalformedURLException ex) {
                        SAXException saxe = new SAXException(ex);
                        ErrorManager.getDefault().copyAnnotation((Throwable)saxe, (Throwable)ex);
                        throw saxe;
                    }
                }
            } else if (!SuggestionTypeProcessor.TAG_TYPE_ACTIONS.equals(name)) {
                if (SuggestionTypeProcessor.TAG_TYPE_ACTION.equals(name)) {
                    String cln = attrs.getValue(SuggestionTypeProcessor.ATTR_ACTION_CLASS);
                    if (cln == null) {
                        return;
                    }
                    try {
                        SystemAction a;
                        ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = SuggestionTypeProcessor.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                        Class<?> c = Class.forName(cln, true, l);
                        if (c != null && (a = SystemAction.get(c)) != null) {
                            if (this.actions == null) {
                                this.actions = new ArrayList();
                            }
                            this.actions.add(a);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        ErrorManager.getDefault().annotate((Throwable)e, "TL: cannot load " + cln + " action, ignoring...");
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                } else {
                    throw new SAXException("malformed SuggestionType xml file");
                }
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (!SuggestionTypeProcessor.TAG_TYPE_ACTION.equals(name) && !SuggestionTypeProcessor.TAG_TYPE_ACTIONS.equals(name) && SuggestionTypeProcessor.TAG_TYPE.equals(name) && this.id != null) {
                this.type = new SuggestionType(this.id, this.localizer, this.key, this.longkey, this.icon, this.actions);
            }
        }

        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (SuggestionTypeProcessor.DTD_PUBLIC_ID.equals(pid)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return new InputSource(sid);
        }
    }
}

