/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskList;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;

public class SuggestionList
extends TaskList {
    private static final int MAX_INLINE = 20;
    static final Object CATEGORY_NODE_SEED = new Object();
    private final int groupTreshold;
    private Map categoryTasks = null;

    public SuggestionList() {
        this(20);
    }

    public SuggestionList(int groupTreshold) {
        this.groupTreshold = groupTreshold;
    }

    synchronized SuggestionImpl getCategoryTask(SuggestionType type, boolean create) {
        SuggestionImpl category = null;
        if (this.categoryTasks != null) {
            category = (SuggestionImpl)((Object)this.categoryTasks.get(type));
        }
        if (create && category == null) {
            category = new SuggestionImpl(null, type.getLocalizedName(), type, null, CATEGORY_NODE_SEED);
            category.setType(type.getName());
            category.setIcon(type.getIconImage());
            category.setVisitable(false);
            SuggestionManagerImpl manager = (SuggestionManagerImpl)SuggestionManager.getDefault();
            if (manager.isExpandedType(type)) {
                // empty if block
            }
            if (this.categoryTasks == null) {
                this.categoryTasks = new HashMap(20);
            }
            this.categoryTasks.put(type, category);
            SuggestionImpl after = this.findAfter(type);
            if (after != null) {
                this.addCategory((Task)category, after);
            } else {
                this.addCategory((Task)category, false);
            }
        }
        return category;
    }

    private void addCategory(Task task, Task after) {
        if (task.getParent() == null) {
            this.appendTask(task);
        } else {
            Task parent = task.getParent();
            parent.removeSubtask(task);
            parent.addSubtask(task, after);
        }
    }

    private void addCategory(Task task, boolean append) {
        if (task.getParent() == null) {
            this.appendTask(task);
        } else {
            Task parent = task.getParent();
            parent.removeSubtask(task);
            parent.addSubtask(task, append);
        }
    }

    SuggestionImpl findAfter(SuggestionType type) {
        SuggestionImpl after = null;
        int pos = type.getPosition();
        Iterator it = this.getTasks().iterator();
        int i = 0;
        while (it.hasNext()) {
            ++i;
            SuggestionImpl s = (SuggestionImpl)((Object)it.next());
            int spos = s.getSType().getPosition();
            if (spos > pos) break;
            after = s;
        }
        if (i == this.getTasks().size()) {
            return null;
        }
        return after;
    }

    synchronized void removeCategory(SuggestionImpl category, boolean force) {
        if (category != null && (force || !category.hasSubtasks())) {
            category.getParent().removeSubtask((Task)category);
            this.categoryTasks.remove(category.getSType());
        }
    }

    synchronized void removeCategory(SuggestionType type) {
        if (this.getTasks().size() == 0) {
            this.categoryTasks = null;
            return;
        }
        Iterator ti = this.getTasks().iterator();
        ArrayList<SuggestionImpl> removeTasks = new ArrayList<SuggestionImpl>(50);
        while (ti.hasNext()) {
            SuggestionImpl suggestion = (SuggestionImpl)((Object)ti.next());
            if (suggestion.getSType() != type) continue;
            removeTasks.add(suggestion);
        }
        this.addRemove(null, removeTasks, false, null, null);
        if (this.categoryTasks != null) {
            this.categoryTasks.remove(type);
        }
    }

    public Collection getCategoryTasks() {
        if (this.categoryTasks != null) {
            return this.categoryTasks.values();
        }
        return null;
    }

    void clearCategoryTasks() {
        this.categoryTasks = null;
    }

    final int getGroupTreshold() {
        return this.groupTreshold;
    }
}

