/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class CallStackTreeModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(99) >= 0;
    private JPDADebuggerImpl debugger;
    private Collection listeners = new HashSet();
    private Listener listener;

    public CallStackTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent.equals("Root") || parent instanceof JPDAThread) {
            JPDAThread thread = parent.equals("Root") ? this.debugger.getCurrentThread() : (JPDAThread)parent;
            if (thread == null) {
                return new String[]{"No current thread"};
            }
            try {
                Object[] sfs = thread.getCallStack(from, to);
                return sfs;
            }
            catch (AbsentInformationException aiex) {
                if (aiex.getCause() instanceof IncompatibleThreadStateException) {
                    return new String[]{"Thread is running"};
                }
                return new String[]{"No call stack information available."};
            }
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object parent) throws UnknownTypeException {
        if (parent.equals("Root") || parent instanceof JPDAThread) {
            JPDAThread thread = parent.equals("Root") ? this.debugger.getCurrentThread() : (JPDAThread)parent;
            if (thread == null) {
                return 1;
            }
            return thread.getStackDepth();
        }
        throw new UnknownTypeException(parent);
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node.equals("Root")) {
            return false;
        }
        if (node instanceof CallStackFrame) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
            if (this.listeners.size() == 0) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        Object[] ls;
        Collection collection = this.listeners;
        synchronized (collection) {
            ls = this.listeners.toArray();
        }
        ModelEvent.TreeChanged ev = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < ls.length; ++i) {
            ((ModelListener)ls[i]).modelChanged((ModelEvent)ev);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(CallStackTreeModel tm, JPDADebugger debugger) {
            this.debugger = debugger;
            this.model = new WeakReference<CallStackTreeModel>(tm);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
            JPDAThreadImpl lastCurrentThread = (JPDAThreadImpl)debugger.getCurrentThread();
            if (lastCurrentThread != null) {
                lastCurrentThread.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)lastCurrentThread));
            }
        }

        private CallStackTreeModel getModel() {
            CallStackTreeModel tm = (CallStackTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("CSTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void propertyChange(PropertyChangeEvent e) {
            JPDAThreadImpl lastCurrentThread;
            boolean refresh = false;
            String propertyName = e.getPropertyName();
            if (propertyName == "currentThread" && (lastCurrentThread = (JPDAThreadImpl)this.debugger.getCurrentThread()) != null) {
                lastCurrentThread.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)lastCurrentThread));
                refresh = true;
            }
            if (propertyName == "suspended" && Boolean.TRUE.equals(e.getNewValue()) && e.getSource() == this.debugger.getCurrentThread()) {
                refresh = true;
            }
            if (propertyName == "state") {
                if (this.debugger.getState() == 3) {
                    refresh = true;
                }
            }
            if (refresh) {
                Listener listener = this;
                synchronized (listener) {
                    if (this.task == null) {
                        this.task = RequestProcessor.getDefault().create((Runnable)new Refresher());
                    }
                    this.task.schedule(200);
                }
            }
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            public void run() {
                CallStackTreeModel tm;
                int n = Listener.this.debugger.getState();
                Listener.this.debugger;
                if (n == 3 && (tm = Listener.this.getModel()) != null) {
                    tm.fireTreeChanged();
                }
            }
        }
    }
}

