/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.expr.JavaParserTreeConstants;
import org.netbeans.modules.debugger.jpda.expr.JavaParserVisitor;
import org.netbeans.modules.debugger.jpda.expr.Node;

class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    private Map attributes;

    public SimpleNode(int i) {
        this.id = i;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public Object[] getAttributes(String name) {
        if (this.attributes == null) {
            return null;
        }
        List attrs = this.getAttributeList(name);
        return attrs.toArray(new Object[attrs.size()]);
    }

    public void addAttribute(String name, Object value) {
        this.getAttributeList(name).add(value);
    }

    public void setAttribute(String name, Object value) {
        this.getAttributeMap().put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    private Map getAttributeMap() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }

    private List getAttributeList(String name) {
        this.getAttributeMap();
        ArrayList list = (ArrayList)this.attributes.get(name);
        if (list == null) {
            list = new ArrayList();
            this.attributes.put(name, list);
        }
        return list;
    }

    public int jjtGetID() {
        return this.id;
    }
}

