/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.jpda.expr.Identifier;
import org.netbeans.modules.debugger.jpda.expr.JavaParserTreeConstants;
import org.netbeans.modules.debugger.jpda.expr.SimpleNode;
import org.openide.util.NbBundle;

public class EvaluationException
extends RuntimeException {
    private SimpleNode node;
    private String reason;
    private Object[] params;
    private String message;

    public EvaluationException(SimpleNode node, String reason, Object[] params) {
        this.node = node;
        this.reason = reason;
        this.params = params;
    }

    public String getMessage() {
        try {
            return this.getMessageImpl();
        }
        catch (Exception e) {
            this.message = this.formatMessage("CTL_EvalError_unknownInternalError", null);
            return this.message;
        }
    }

    public String getMessageImpl() {
        if (this.message != null) {
            return this.message;
        }
        String[] msgParams = null;
        if (this.reason.equals("unknownNonterminal")) {
            msgParams = new String[]{JavaParserTreeConstants.jjtNodeName[this.node.jjtGetID()]};
        } else if (this.reason.equals("internalError")) {
            msgParams = new String[]{JavaParserTreeConstants.jjtNodeName[this.node.jjtGetID()]};
        } else if (this.reason.equals("invalidArrayInitializer")) {
            msgParams = new String[]{this.params[0] == null ? null : this.params[0].toString()};
        } else if (this.reason.equals("arraySizeBadType")) {
            msgParams = new String[]{this.params[0] == null ? null : this.params[0].toString()};
        } else if (this.reason.equals("arrayCreateError")) {
            msgParams = new String[]{this.params[0] == null ? null : this.params[0].toString()};
        } else if (this.reason.equals("instantiateInterface")) {
            msgParams = new String[]{this.params[0] == null ? null : this.params[0].toString()};
        } else if (this.reason.equals("castToBooleanRequired")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("castFromBooleanRequired")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("castError")) {
            msgParams = new String[]{this.params[0].toString(), this.params[1].toString()};
        } else if (this.reason.equals("badOperandForPostfixOperator")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("postfixOperatorEvaluationError")) {
            msgParams = new String[]{this.params[1].toString()};
        } else if (this.reason.equals("badOperandForPrefixOperator")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("prefixOperatorEvaluationError")) {
            msgParams = new String[]{this.params[1].toString()};
        } else if (this.reason.equals("badOperandForUnaryOperator")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("unaryOperatorEvaluationError")) {
            msgParams = new String[]{this.params[1].toString()};
        } else if (this.reason.equals("unknownType")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("internalErrorResolvingType")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("instanceOfLeftOperandNotAReference")) {
            msgParams = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("conditionalOrAndBooleanOperandRequired")) {
            msgParams = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("conditionalQuestionMarkBooleanOperandRequired")) {
            msgParams = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("thisObjectUnavailable")) {
            msgParams = null;
        } else if (this.reason.equals("objectReferenceRequiredOnDereference")) {
            msgParams = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("badArgument")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("argumentsBadSyntax")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("ambigousMethod")) {
            msgParams = new String[]{((Identifier)this.params[0]).typeContext.name(), ((Identifier)this.params[0]).identifier};
        } else if (this.reason.equals("noSuchMethod")) {
            msgParams = new String[]{((Identifier)this.params[0]).typeContext.name(), ((Identifier)this.params[0]).identifier};
        } else if (this.reason.equals("callException")) {
            msgParams = new String[]{((Identifier)this.params[1]).typeContext.name(), ((Identifier)this.params[1]).identifier, this.params[0].toString()};
        } else if (this.reason.equals("calleeException")) {
            msgParams = new String[]{((Identifier)this.params[1]).typeContext.name(), ((Identifier)this.params[1]).identifier, ((InvocationException)this.params[0]).exception().toString()};
        } else if (this.reason.equals("identifierNotAReference")) {
            msgParams = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("notarray")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("arrayIndexNAN")) {
            msgParams = new String[]{this.params[1].toString()};
        } else if (this.reason.equals("arrayIndexOutOfBounds")) {
            msgParams = new String[]{this.params[1].toString(), Integer.toString(((ArrayReference)this.params[0]).length() - 1)};
        } else if (this.reason.equals("unknownVariable")) {
            msgParams = new String[]{((Identifier)this.params[0]).identifier};
        } else if (this.reason.equals("integerLiteralTooBig")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("badFormatOfIntegerLiteral")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("unknownLiteralType")) {
            msgParams = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("evaluateError")) {
            msgParams = new String[]{this.params[1].toString(), this.params[0].toString(), this.params[2].toString()};
        } else if (this.reason.equals("notEnclosingType")) {
            msgParams = new String[]{((Identifier)this.params[0]).typeContext.name(), ((Identifier)this.params[0]).superQualifier};
        } else if (this.reason.equals("accessInstanceVariableFromStaticContext")) {
            msgParams = new String[]{((Identifier)this.params[0]).identifier};
        } else if (this.reason.equals("methodCallOnNull")) {
            msgParams = new String[]{this.params[0].toString()};
        } else {
            this.reason = "unknownInternalError";
            msgParams = null;
        }
        this.message = this.formatMessage("CTL_EvalError_" + this.reason, msgParams);
        return this.message;
    }

    private String formatMessage(String msg, String[] params) {
        ResourceBundle bundle = NbBundle.getBundle((Class)EvaluationException.class);
        msg = bundle.getString(msg);
        return MessageFormat.format(msg, params);
    }
}

