/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.palette.HTMLPaletteUtilities;
import org.netbeans.modules.html.palette.items.OLCustomizer;
import org.openide.text.ActiveEditorDrop;

public class OL
implements ActiveEditorDrop {
    public static final int ITEM_COUNT_DEFAULT = 2;
    public static final String DEFAULT = "default";
    public static final String ARABIC_NUMBERS = "1";
    public static final String LOWER_ALPHA = "a";
    public static final String UPPER_ALPHA = "A";
    public static final String LOWER_ROMAN = "i";
    public static final String UPPER_ROMAN = "I";
    private String type = "default";
    private int count = 2;

    public boolean handleTransfer(JTextComponent targetComponent) {
        OLCustomizer c = new OLCustomizer(this);
        boolean accept = c.showDialog();
        if (accept) {
            String body = this.createBody();
            try {
                HTMLPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            sb.append("<li></li>\n");
        }
        String strType = "";
        if (!this.type.equals(DEFAULT)) {
            strType = " type=\"" + this.type + "\"";
        }
        String oList = "<ol" + strType + ">\n" + sb.toString() + "</ol>\n";
        return oList;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

