/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class JBLogWriter {
    public static final boolean VERBOSE = System.getProperty("netbeans.serverplugins.jboss4.logging") != null;
    private static final int DELAY = 500;
    private static final int START_TIMEOUT = 900000;
    private final Object READER_LOCK = new Object();
    private final Object START_LOCK = new Object();
    private LOGGER_TYPE type;
    private static final String THREAD_NAME = "JBoss Log Writer";
    private static final String STOPPER_THREAD_NAME = "JBoss Log Writer Stopper";
    private JBStartServer.ACTION_STATUS actionStatus = JBStartServer.ACTION_STATUS.UNKNOWN;
    JBStartServer startServer;
    private final OutputWriter out;
    private volatile BufferedReader reader;
    private final String instanceName;
    private Process process;
    private File logFile;
    Thread logWriterThread;
    private static HashMap<String, JBLogWriter> instances = new HashMap();
    private boolean read;
    private String trailingLine = "";

    private JBLogWriter(InputOutput io, String instanceName) {
        this.out = io != null ? io.getOut() : null;
        this.instanceName = instanceName;
    }

    public static synchronized JBLogWriter createInstance(InputOutput io, String instanceName) {
        JBLogWriter instance = JBLogWriter.getInstance(instanceName);
        if (instance == null) {
            instance = new JBLogWriter(io, instanceName);
            instances.put(instanceName, instance);
        }
        return instance;
    }

    public static synchronized JBLogWriter getInstance(String instanceName) {
        return instances.get(instanceName);
    }

    public void start(File logFile) {
        try {
            this.logFile = logFile;
            this.reader = new BufferedReader(new FileReader(logFile));
        }
        catch (FileNotFoundException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        this.startWriter(new LineProcessor(){

            public void processLine(String line) {
                if (JBLogWriter.this.out != null && line != null && line.indexOf(" INFO ") != -1) {
                    JBLogWriter.this.out.println(line);
                }
            }
        }, LOGGER_TYPE.FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JBStartServer.ACTION_STATUS start(Process process, JBStartServer startServer) {
        this.process = process;
        this.startServer = startServer;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        this.startWriter(new LineProcessor(){
            private boolean checkStartProgress = true;

            public void processLine(String line) {
                if (line != null) {
                    if (JBLogWriter.this.out != null) {
                        JBLogWriter.this.out.println(line);
                    }
                    if (this.checkStartProgress) {
                        this.checkStartProgress(line);
                    }
                }
            }

            private void checkStartProgress(String line) {
                if (line.indexOf("Starting JBoss (MX MicroKernel)") > -1) {
                    if (VERBOSE) {
                        System.out.println("STARTING message fired");
                    }
                    JBLogWriter.this.fireStartProgressEvent(StateType.RUNNING, JBLogWriter.this.createProgressMessage("MSG_START_SERVER_IN_PROGRESS"));
                } else if (line.indexOf("JBoss (MX MicroKernel)") > -1 && line.indexOf("Started in") > -1) {
                    if (VERBOSE) {
                        System.out.println("STARTED message fired");
                    }
                    this.checkStartProgress = false;
                    JBLogWriter.this.actionStatus = JBStartServer.ACTION_STATUS.SUCCESS;
                    JBLogWriter.this.notifyStartupThread();
                } else if (line.indexOf("Shutdown complete") > -1) {
                    this.checkStartProgress = false;
                    JBLogWriter.this.actionStatus = JBStartServer.ACTION_STATUS.FAILURE;
                    JBLogWriter.this.notifyStartupThread();
                }
            }
        }, LOGGER_TYPE.PROCESS);
        try {
            Object object = this.START_LOCK;
            synchronized (object) {
                long start = System.currentTimeMillis();
                this.START_LOCK.wait(900000L);
                if (System.currentTimeMillis() - start >= 900000L) {
                    if (VERBOSE) {
                        System.out.println("Startup thread TIMEOUT EXPIRED");
                    }
                    this.actionStatus = JBStartServer.ACTION_STATUS.UNKNOWN;
                } else if (VERBOSE) {
                    System.out.println("Startup thread NOTIFIED");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.actionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStartupThread() {
        Object object = this.START_LOCK;
        synchronized (object) {
            this.START_LOCK.notify();
        }
    }

    private void fireStartProgressEvent(StateType stateType, String msg) {
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, msg));
    }

    private String createProgressMessage(String resName) {
        return NbBundle.getMessage(JBLogWriter.class, (String)resName, (Object)this.instanceName);
    }

    private void startWriter(final LineProcessor lineProcessor, final LOGGER_TYPE type) {
        if (this.isRunning()) {
            this.logWriterThread.interrupt();
            if (VERBOSE) {
                System.out.println("************INTERRUPT thread " + this.logWriterThread.getId());
            }
        }
        this.type = type;
        this.logWriterThread = new Thread(THREAD_NAME){

            public void run() {
                boolean checkProfiler;
                if (VERBOSE) {
                    System.out.println("************START thread " + Thread.currentThread().getId());
                }
                JBLogWriter.this.read = true;
                boolean interrupted = false;
                long lastFileSize = -1L;
                boolean bl = checkProfiler = JBLogWriter.this.startServer != null && JBLogWriter.this.startServer.getMode() == JBStartServer.MODE.PROFILE;
                while (JBLogWriter.this.read) {
                    if (checkProfiler) {
                        int state = ProfilerSupport.getState();
                        if (state == ProfilerSupport.STATE_BLOCKING || state == ProfilerSupport.STATE_RUNNING || state == ProfilerSupport.STATE_PROFILING) {
                            JBLogWriter.this.fireStartProgressEvent(StateType.COMPLETED, JBLogWriter.this.createProgressMessage("MSG_PROFILED_SERVER_STARTED"));
                            checkProfiler = false;
                            JBLogWriter.this.notifyStartupThread();
                        } else if (state == ProfilerSupport.STATE_INACTIVE) {
                            JBLogWriter.this.fireStartProgressEvent(StateType.FAILED, JBLogWriter.this.createProgressMessage("MSG_START_PROFILED_SERVER_FAILED"));
                            JBLogWriter.this.process.destroy();
                            JBLogWriter.this.notifyStartupThread();
                            break;
                        }
                    }
                    boolean ready = JBLogWriter.this.processInput(lineProcessor, type);
                    if (type == LOGGER_TYPE.FILE) {
                        if (ready) {
                            lastFileSize = JBLogWriter.this.logFile.length();
                        } else if (lastFileSize != JBLogWriter.this.logFile.length()) {
                            if (VERBOSE) {
                                System.out.println("!!!!!!!!!DIFFERENCE found");
                            }
                            JBLogWriter.this.refresh();
                        }
                    } else {
                        try {
                            JBLogWriter.this.process.exitValue();
                            break;
                        }
                        catch (IllegalThreadStateException itse) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        break;
                    }
                }
                lineProcessor.processLine(JBLogWriter.this.trailingLine);
                if (VERBOSE) {
                    System.out.println("************FINISH thread " + Thread.currentThread().getId());
                }
                if (!interrupted) {
                    JBLogWriter.this.read = false;
                    instances.remove(JBLogWriter.this.instanceName);
                }
            }
        };
        this.logWriterThread.start();
    }

    void stop() {
        this.read = false;
    }

    boolean isRunning() {
        return this.read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.type == LOGGER_TYPE.PROCESS || this.logFile == null) {
            return;
        }
        Object object = this.READER_LOCK;
        synchronized (object) {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            try {
                if (this.out != null) {
                    this.out.reset();
                }
                if (VERBOSE) {
                    System.out.println("REFRESHING the output pane");
                }
                this.reader = new BufferedReader(new FileReader(this.logFile));
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processInput(LineProcessor lineProcessor, LOGGER_TYPE type) {
        Object object = this.READER_LOCK;
        synchronized (object) {
            boolean ready = false;
            try {
                if (type == LOGGER_TYPE.PROCESS) {
                    while (this.reader.ready()) {
                        ready = this.readLine(lineProcessor);
                    }
                } else {
                    while (this.reader.ready()) {
                        String line = this.reader.readLine();
                        lineProcessor.processLine(line);
                        ready = true;
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return ready;
        }
    }

    private boolean readLine(LineProcessor lineProcessor) throws IOException {
        char[] cbuf = new char[128];
        int size = -1;
        size = this.reader.read(cbuf);
        if (size != -1) {
            String lines = this.trailingLine != null ? this.trailingLine : "";
            lines = lines + new String(cbuf, 0, size);
            int tlLength = this.trailingLine != null ? this.trailingLine.length() : 0;
            int start = 0;
            for (int i = 0; i < size; ++i) {
                String line;
                if (cbuf[i] == '\r' && (i + 1 == size || cbuf[i + 1] != '\n') || cbuf[i] == '\n') {
                    line = lines.substring(start, tlLength + i);
                    start = tlLength + (i + 1);
                    lineProcessor.processLine(line);
                    continue;
                }
                if (cbuf[i] != '\r' || i + 1 >= size || cbuf[i + 1] != '\n') continue;
                line = lines.substring(start, tlLength + i);
                start = tlLength + (++i + 1);
                lineProcessor.processLine(line);
            }
            this.trailingLine = start < lines.length() ? lines.substring(start) : null;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForServerProcessFinished(long milliseconds) {
        RequestProcessor.Task t = new RequestProcessor(STOPPER_THREAD_NAME, 1, true).post(new Runnable(){

            public void run() {
                try {
                    if (VERBOSE) {
                        System.out.println("JBoss Log Writer Stopper: WAITING for the server process to stop");
                    }
                    if (JBLogWriter.this.type == LOGGER_TYPE.PROCESS) {
                        JBLogWriter.this.process.waitFor();
                    } else {
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        try {
            t.waitFinished(milliseconds);
        }
        catch (InterruptedException ex) {
        }
        finally {
            t.cancel();
        }
    }

    private static interface LineProcessor {
        public void processLine(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LOGGER_TYPE {
        PROCESS,
        FILE;

    }
}

