/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEjbGenerator;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.GeneratedTables;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaFileList;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RelatedCMPHelper {
    private final Project project;
    private final FileObject configFilesFolder;
    private final PersistenceGenerator persistenceGen;
    private final DBSchemaFileList dbschemaFileList;
    private SchemaElement schemaElement;
    private DatabaseConnection dbconn;
    private FileObject dbschemaFile;
    private String datasourceName;
    private TableClosure tableClosure;
    private SelectedTables selectedTables;
    private SourceGroup location;
    private String packageName;
    private boolean cmpFieldsInInterface;
    private boolean generateFinderMethods;
    private DbSchemaEjbGenerator generator;
    private TableSource tableSource;
    private PersistenceUnit persistenceUnit;

    public RelatedCMPHelper(Project project, FileObject configFilesFolder, PersistenceGenerator persistenceGen) {
        this.project = project;
        this.configFilesFolder = configFilesFolder;
        this.persistenceGen = persistenceGen;
        this.tableSource = TableSource.get(project);
        this.dbschemaFileList = new DBSchemaFileList(project, configFilesFolder);
    }

    public Project getProject() {
        return this.project;
    }

    FileObject getConfigFilesFolder() {
        return this.configFilesFolder;
    }

    PersistenceGenerator getPersistenceGenerator() {
        return this.persistenceGen;
    }

    public DBSchemaFileList getDBSchemaFileList() {
        return this.dbschemaFileList;
    }

    public void setTableClosure(TableClosure tableClosure) {
        assert (tableClosure != null);
        this.tableClosure = tableClosure;
    }

    public TableClosure getTableClosure() {
        return this.tableClosure;
    }

    public void setSelectedTables(SelectedTables selectedTables) {
        assert (selectedTables != null);
        this.selectedTables = selectedTables;
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(PersistenceUnit persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public void setTableSource(SchemaElement schemaElement, DatabaseConnection dbconn, String datasourceName) {
        this.schemaElement = schemaElement;
        this.dbconn = dbconn;
        this.dbschemaFile = null;
        this.datasourceName = datasourceName;
        this.updateTableSource();
    }

    public void setTableSource(SchemaElement schemaElement, FileObject dbschemaFile) {
        this.schemaElement = schemaElement;
        this.dbconn = null;
        this.dbschemaFile = dbschemaFile;
        this.datasourceName = null;
        this.updateTableSource();
    }

    public TableSource getTableSource() {
        return this.tableSource;
    }

    private void updateTableSource() {
        this.tableSource = this.dbconn != null ? (this.datasourceName != null ? new TableSource(this.datasourceName, TableSource.Type.DATA_SOURCE) : new TableSource(this.dbconn.getName(), TableSource.Type.CONNECTION)) : (this.dbschemaFile != null ? new TableSource(FileUtil.toFile((FileObject)this.dbschemaFile).getAbsolutePath(), TableSource.Type.SCHEMA_FILE) : null);
    }

    public SchemaElement getSchemaElement() {
        return this.schemaElement;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public FileObject getDBSchemaFile() {
        return this.dbschemaFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public SourceGroup getLocation() {
        return this.location;
    }

    public void setLocation(SourceGroup location) {
        this.location = location;
    }

    public boolean isCmpFieldsInInterface() {
        return this.cmpFieldsInInterface;
    }

    public void setCmpFieldsInInterface(boolean cmpFieldsInInterface) {
        this.cmpFieldsInInterface = cmpFieldsInInterface;
    }

    public boolean isGenerateFinderMethods() {
        return this.generateFinderMethods;
    }

    public void setGenerateFinderMethods(boolean generateFinderMethods) {
        this.generateFinderMethods = generateFinderMethods;
    }

    public void buildBeans() {
        TableSource.put(this.project, this.tableSource);
        GenerateTablesImpl genTables = new GenerateTablesImpl();
        FileObject rootFolder = this.getLocation().getRootFolder();
        String packageName = this.getPackageName();
        for (Table table : this.selectedTables.getTables()) {
            genTables.addTable(table.getName(), rootFolder, this.getPackageName(), this.selectedTables.getClassName(table));
        }
        for (Table table : this.tableClosure.getAvailableTables()) {
            if (!(table.getDisabledReason() instanceof Table.ExistingDisabledReason)) continue;
            Table.ExistingDisabledReason exDisReason = (Table.ExistingDisabledReason)table.getDisabledReason();
            String fqClassName = exDisReason.getFQClassName();
            SourceGroup sourceGroup = Util.getClassSourceGroup(this.getProject(), fqClassName);
            if (sourceGroup == null) continue;
            genTables.addTable(table.getName(), sourceGroup.getRootFolder(), Util.getPackageName(fqClassName), Util.getClassName(fqClassName));
        }
        this.generator = new DbSchemaEjbGenerator(genTables, this.schemaElement);
    }

    public EntityClass[] getBeans() {
        return this.generator.getBeans();
    }

    public EntityRelation[] getRelations() {
        return this.generator.getRelations();
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GenerateTablesImpl
    implements GeneratedTables {
        private final Set<String> tableNames = new HashSet<String>();
        private final Map<String, FileObject> rootFolders = new HashMap<String, FileObject>();
        private final Map<String, String> packageNames = new HashMap<String, String>();
        private final Map<String, String> classNames = new HashMap<String, String>();

        private GenerateTablesImpl() {
        }

        @Override
        public Set<String> getTableNames() {
            return Collections.unmodifiableSet(this.tableNames);
        }

        private void addTable(String tableName, FileObject rootFolder, String packageName, String className) {
            this.tableNames.add(tableName);
            this.rootFolders.put(tableName, rootFolder);
            this.packageNames.put(tableName, packageName);
            this.classNames.put(tableName, className);
        }

        @Override
        public FileObject getRootFolder(String tableName) {
            return this.rootFolders.get(tableName);
        }

        @Override
        public String getPackageName(String tableName) {
            return this.packageNames.get(tableName);
        }

        @Override
        public String getClassName(String tableName) {
            return this.classNames.get(tableName);
        }
    }
}

