/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.SchemaElementUtil;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.j2ee.common.EventRequestProcessor;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaFileList;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DBSchemaManager {
    public static final String DBSCHEMA_EXT = "dbschema";
    private final EventRequestProcessor erp = new EventRequestProcessor();
    private DatabaseConnection oldDBConn;
    private boolean oldDBConnWasConnected;
    private Connection conn;
    private SchemaElement schemaElement;
    private SQLException exception;
    private FileObject schemaFileObject;
    private SchemaElement fileSchemaElement;

    public SchemaElement getSchemaElement(final DatabaseConnection dbconn) throws SQLException {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.oldDBConn == dbconn && this.schemaElement != null) {
            return this.schemaElement;
        }
        this.schemaElement = null;
        ArrayList<Object> actions = new ArrayList<Object>();
        if (this.oldDBConn != null && this.oldDBConn != dbconn && !this.oldDBConnWasConnected) {
            actions.add(new EventRequestProcessor.AsynchronousAction(){

                public void run(EventRequestProcessor.Context actionContext) {
                    actionContext.getProgress().progress(NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_ClosingPreviousConnection"));
                    ConnectionManager.getDefault().disconnect(DBSchemaManager.this.oldDBConn);
                    DBSchemaManager.this.oldDBConn = null;
                    DBSchemaManager.this.conn = null;
                }
            });
        } else {
            this.oldDBConn = null;
            this.conn = null;
        }
        actions.add(new EventRequestProcessor.SynchronousAction(){

            public void run(EventRequestProcessor.Context actionContext) {
                ConnectionManager.getDefault().showConnectionDialog(dbconn);
                DBSchemaManager.this.conn = dbconn.getJDBCConnection();
            }

            public boolean isEnabled() {
                DBSchemaManager.this.conn = dbconn.getJDBCConnection();
                DBSchemaManager.this.oldDBConnWasConnected = DBSchemaManager.this.conn != null;
                return !DBSchemaManager.this.oldDBConnWasConnected;
            }
        });
        actions.add(new EventRequestProcessor.CancellableAction(){
            private SchemaElementImpl schemaElementImpl;
            private boolean cancelled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(final EventRequestProcessor.Context actionContext) {
                actionContext.getProgress().progress(NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingSchema"));
                DBSchemaManager.this.oldDBConn = dbconn;
                ConnectionProvider connectionProvider = null;
                try {
                    connectionProvider = new ConnectionProvider(DBSchemaManager.this.conn, dbconn.getDriverClass());
                    connectionProvider.setSchema(dbconn.getSchema());
                }
                catch (SQLException e) {
                    DBSchemaManager.this.exception = e;
                    return;
                }
                3 e = this;
                synchronized (e) {
                    if (this.cancelled) {
                        return;
                    }
                    this.schemaElementImpl = new SchemaElementImpl(connectionProvider);
                }
                try {
                    this.schemaElementImpl.setName(DBIdentifier.create((String)DBSchemaManager.DBSCHEMA_EXT));
                }
                catch (DBException e2) {
                    ErrorManager.getDefault().notify(1, (Throwable)e2);
                    return;
                }
                DBSchemaManager.this.schemaElement = new SchemaElement((SchemaElement.Impl)this.schemaElementImpl);
                this.schemaElementImpl.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String propertyName = event.getPropertyName();
                        String message = null;
                        if ("totalCount".equals(propertyName)) {
                            int workunits = (Integer)event.getNewValue();
                            actionContext.getProgress().switchToDeterminate(workunits);
                        } else if ("progress".equals(propertyName)) {
                            int workunit = (Integer)event.getNewValue();
                            actionContext.getProgress().progress(workunit);
                        } else if ("tableName".equals(propertyName)) {
                            message = NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingTable", (Object)event.getNewValue());
                        } else if ("viewName".equals(propertyName)) {
                            message = NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingView", (Object)event.getNewValue());
                        } else if ("FKt".equals(propertyName)) {
                            message = NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingTableKeys", (Object)event.getNewValue());
                        } else if ("FKv".equals(propertyName)) {
                            message = NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_RetrievingViewKeys", (Object)event.getNewValue());
                        }
                        if (message != null) {
                            actionContext.getProgress().progress(message);
                        }
                    }
                });
                this.schemaElementImpl.initTables(connectionProvider);
            }

            public boolean getRunInEventThread() {
                return false;
            }

            public boolean isEnabled() {
                return DBSchemaManager.this.conn != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    this.cancelled = true;
                    if (this.schemaElementImpl != null) {
                        this.schemaElementImpl.setStop(true);
                    }
                }
                return true;
            }
        });
        this.exception = null;
        boolean success = this.erp.invoke(actions, true);
        if (this.exception != null) {
            throw this.exception;
        }
        if (!success) {
            this.schemaElement = null;
        }
        return this.schemaElement;
    }

    public SchemaElement getSchemaElement(final FileObject fo) {
        assert (SwingUtilities.isEventDispatchThread());
        if (fo == this.schemaFileObject) {
            return this.fileSchemaElement;
        }
        this.schemaFileObject = null;
        this.fileSchemaElement = null;
        ArrayList<4> actions = new ArrayList<4>();
        actions.add(new EventRequestProcessor.AsynchronousAction(){

            public void run(EventRequestProcessor.Context actionContext) {
                actionContext.getProgress().progress(NbBundle.getMessage(DBSchemaManager.class, (String)"LBL_ReadingSchemaFile"));
                DBSchemaManager.this.schemaFileObject = fo;
                DBSchemaManager.this.fileSchemaElement = SchemaElementUtil.forName((FileObject)fo);
            }
        });
        this.erp.invoke(actions);
        return this.fileSchemaElement;
    }

    public static FileObject updateDBSchemas(SchemaElement schemaElement, DBSchemaFileList dbschemaFileList, FileObject folder, String projectName) throws IOException {
        FileObject result = DBSchemaManager.updateDBSchemas(schemaElement, dbschemaFileList);
        if (result == null) {
            result = DBSchemaManager.writeDBSchema(schemaElement, folder, projectName);
        }
        return result;
    }

    private static FileObject updateDBSchemas(SchemaElement schemaElement, DBSchemaFileList dbschemaFileList) throws IOException {
        FileObject updatedDBSchemaFile = null;
        DBIdentifier schemaFullName = schemaElement.getSchema();
        String schemaName = schemaFullName != null ? schemaFullName.getName() : null;
        for (FileObject dbschemaFile : dbschemaFileList.getFileList()) {
            String existingSchemaName;
            SchemaElement existingSchemaElement = SchemaElementUtil.forName((FileObject)dbschemaFile);
            DBIdentifier existingSchemaFullName = existingSchemaElement.getSchema();
            String string = existingSchemaName = existingSchemaFullName != null ? existingSchemaFullName.getName() : null;
            if (!Utilities.compareObjects((Object)existingSchemaElement.getUrl(), (Object)schemaElement.getUrl()) || !Utilities.compareObjects((Object)existingSchemaName, (Object)schemaName)) continue;
            DBIdentifier existingDBSchemaName = existingSchemaElement.getName();
            DBSchemaManager.overwriteDBSchema(schemaElement, dbschemaFile, existingDBSchemaName);
            updatedDBSchemaFile = dbschemaFile;
        }
        return updatedDBSchemaFile;
    }

    private static FileObject writeDBSchema(SchemaElement schemaElement, FileObject folder, String projectName) throws IOException {
        String schemaName = schemaElement.getSchema().getName();
        String fileName = (schemaName != null && schemaName != "" ? schemaName + "_" : "") + projectName;
        fileName = fileName.replace('.', '_');
        String freeFileName = FileUtil.findFreeFileName((FileObject)folder, (String)fileName, (String)DBSCHEMA_EXT);
        DBIdentifier dbschemaName = DBIdentifier.create((String)freeFileName);
        try {
            schemaElement.setName(dbschemaName);
        }
        catch (DBException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        FileObject dbschemaFile = folder.createData(freeFileName, DBSCHEMA_EXT);
        DBSchemaManager.writeSchemaElement(schemaElement, dbschemaFile);
        return dbschemaFile;
    }

    private static void overwriteDBSchema(SchemaElement schemaElement, FileObject dbschemaFile, DBIdentifier dbschemaName) throws IOException {
        try {
            schemaElement.setName(dbschemaName);
        }
        catch (DBException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        FileObject parent = dbschemaFile.getParent();
        String fileName = dbschemaFile.getName();
        String fileExt = dbschemaFile.getExt();
        dbschemaFile.delete();
        FileObject newDBSchemaFile = parent.createData(fileName, fileExt);
        DBSchemaManager.writeSchemaElement(schemaElement, newDBSchemaFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSchemaElement(SchemaElement schemaElement, FileObject dbschemaFile) throws IOException {
        FileLock lock = dbschemaFile.lock();
        try {
            BufferedOutputStream os = new BufferedOutputStream(dbschemaFile.getOutputStream(lock));
            try {
                schemaElement.save((OutputStream)os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }
}

