/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibraryCustomizer;
import org.openide.util.NbBundle;

public class PersistenceProviderComboboxHelper {
    private static final String SEPARATOR = "PersistenceProviderComboboxHelper.SEPARATOR";
    private static final String EMPTY = "PersistenceProviderComboboxHelper.EMPTY";

    private PersistenceProviderComboboxHelper() {
    }

    public static void connect(final J2eeModuleProvider j2eeModuleProvider, final JComboBox providerCombo) {
        providerCombo.setEditable(false);
        PersistenceProviderComboboxHelper.initCombo(j2eeModuleProvider, providerCombo);
        providerCombo.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object selectedItem;
                int keyCode = e.getKeyCode();
                if (10 == keyCode && (selectedItem = providerCombo.getSelectedItem()) instanceof LibraryItem) {
                    ((LibraryItem)selectedItem).performAction();
                    providerCombo.setPopupVisible(false);
                    e.consume();
                    PersistenceProviderComboboxHelper.initCombo(j2eeModuleProvider, providerCombo);
                }
            }
        });
        providerCombo.addActionListener(new ActionListener(){
            Object currentItem;
            int currentIndex;
            {
                this.currentItem = providerCombo.getSelectedItem();
                this.currentIndex = providerCombo.getSelectedIndex();
            }

            public void actionPerformed(ActionEvent e) {
                Object selectedItem = providerCombo.getSelectedItem();
                if (PersistenceProviderComboboxHelper.SEPARATOR.equals(selectedItem)) {
                    int selectedIndex = providerCombo.getSelectedIndex();
                    if (selectedIndex > this.currentIndex) {
                        this.currentIndex = selectedIndex + 1;
                        this.currentItem = providerCombo.getItemAt(this.currentIndex);
                    } else {
                        this.currentIndex = selectedIndex - 1;
                        this.currentItem = providerCombo.getItemAt(this.currentIndex);
                    }
                    providerCombo.setSelectedItem(this.currentItem);
                } else if ((e.getModifiers() & 0x10) != 0) {
                    if (selectedItem instanceof LibraryItem) {
                        ((LibraryItem)selectedItem).performAction();
                        providerCombo.setPopupVisible(false);
                        PersistenceProviderComboboxHelper.initCombo(j2eeModuleProvider, providerCombo);
                    }
                } else {
                    this.currentItem = selectedItem;
                    this.currentIndex = providerCombo.getSelectedIndex();
                }
            }
        });
    }

    private static void initCombo(J2eeModuleProvider j2eeModuleProvider, JComboBox providerCombo) {
        DefaultComboBoxModel<Provider> providers = new DefaultComboBoxModel<Provider>();
        Provider[] defProvider = new Provider[]{ProviderUtil.DEFAULT_PROVIDER};
        if (j2eeModuleProvider != null) {
            J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
            PersistenceProviderComboboxHelper.addPersistenceProvider(providers, platform, ProviderUtil.HIBERNATE_PROVIDER, "hibernatePersistenceProviderIsDefault", defProvider);
            PersistenceProviderComboboxHelper.addPersistenceProvider(providers, platform, ProviderUtil.TOPLINK_PROVIDER, "toplinkPersistenceProviderIsDefault", defProvider);
            PersistenceProviderComboboxHelper.addPersistenceProvider(providers, platform, ProviderUtil.KODO_PROVIDER, "kodoPersistenceProviderIsDefault", defProvider);
            if (defProvider[0] == ProviderUtil.DEFAULT_PROVIDER && providers.getSize() == 0 && PersistenceProviderComboboxHelper.supportsDefaultProvider(platform, j2eeModuleProvider)) {
                providers.addElement(defProvider[0]);
            }
        }
        PersistenceProviderComboboxHelper.addProvidersFromLibraries(providers);
        providerCombo.setModel(providers);
        providerCombo.addItem(SEPARATOR);
        providerCombo.addItem(new NewPersistenceLibraryItem());
        providerCombo.addItem(new ManageLibrariesItem());
        providerCombo.setRenderer(new PersistenceProviderCellRenderer(defProvider[0]));
        providerCombo.setSelectedIndex(0);
    }

    private static boolean supportsDefaultProvider(J2eePlatform platform, J2eeModuleProvider j2eeModuleProvider) {
        if (platform == null) {
            return false;
        }
        Set supportedVersions = platform.getSupportedSpecVersions(j2eeModuleProvider.getJ2eeModule().getModuleType());
        return supportedVersions.contains("1.5");
    }

    private static void addProvidersFromLibraries(DefaultComboBoxModel model) {
        for (Provider each : ProviderUtil.getProvidersFromLibraries()) {
            boolean found = false;
            for (int i = 0; i < model.getSize(); ++i) {
                Object elem = model.getElementAt(i);
                if (!(elem instanceof Provider) || !each.equals(elem)) continue;
                found = true;
                break;
            }
            if (found) continue;
            model.addElement(each);
        }
    }

    private static void addPersistenceProvider(DefaultComboBoxModel providers, J2eePlatform platform, Provider provider, String providerIsDefaultProperty, Provider[] defProvider) {
        if (platform != null && platform.isToolSupported(provider.getProviderClass())) {
            if (platform.isToolSupported(providerIsDefaultProperty)) {
                providers.insertElementAt(provider, 0);
                defProvider[0] = provider;
            } else {
                providers.addElement(provider);
            }
        }
    }

    private static class ManageLibrariesItem
    implements LibraryItem {
        private ManageLibrariesItem() {
        }

        public String getText() {
            return NbBundle.getMessage(PersistenceProviderComboboxHelper.class, (String)"LBL_ManageLibraries");
        }

        public void performAction() {
            LibrariesCustomizer.showCustomizer(null);
        }
    }

    private static class NewPersistenceLibraryItem
    implements LibraryItem {
        private NewPersistenceLibraryItem() {
        }

        public String getText() {
            return NbBundle.getMessage(PersistenceProviderComboboxHelper.class, (String)"LBL_NewPersistenceLibrary");
        }

        public void performAction() {
            PersistenceLibraryCustomizer.showCustomizer();
        }
    }

    public static interface LibraryItem {
        public String getText();

        public void performAction();
    }

    private static class PersistenceProviderCellRenderer
    extends DefaultListCellRenderer {
        Provider defaultProvider;

        PersistenceProviderCellRenderer(Provider defaultProvider) {
            this.defaultProvider = defaultProvider;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Provider) {
                Provider provider = (Provider)value;
                String text = provider.getDisplayName();
                if (value.equals(this.defaultProvider) && !(value instanceof DefaultProvider)) {
                    text = text + NbBundle.getMessage(PersistenceProviderComboboxHelper.class, (String)"LBL_DEFAULT_PROVIDER");
                }
                this.setText(text);
            } else {
                if (PersistenceProviderComboboxHelper.SEPARATOR.equals(value)) {
                    JSeparator s = new JSeparator();
                    s.setPreferredSize(new Dimension(s.getWidth(), 1));
                    s.setForeground(Color.BLACK);
                    return s;
                }
                if (PersistenceProviderComboboxHelper.EMPTY.equals(value)) {
                    this.setText(" ");
                } else if (value instanceof LibraryItem) {
                    this.setText(((LibraryItem)value).getText());
                } else {
                    this.setText(value != null ? value.toString() : "");
                }
            }
            return this;
        }
    }
}

