/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataLoader;
import org.netbeans.modules.j2ee.persistence.unit.PUDataNode;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceToolBarMVElement;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.xml.sax.InputSource;

public class PUDataObject
extends XmlMultiViewDataObject {
    public static final String HELP_ID_DESIGN_PERSISTENCE_UNIT = "persistence_multiview_design_persistenceUnitNode";
    private ModelSynchronizer modelSynchronizer = new ModelSynchronizer(this);
    public static final int UPDATE_DELAY = 200;
    private static final int TYPE_TOOLBAR = 0;
    private Persistence persistence;
    private static final String DESIGN_VIEW_ID = "persistence_multiview_design";

    public PUDataObject(FileObject pf, PUDataLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
        this.parseDocument();
    }

    protected Node createNodeDelegate() {
        return new PUDataNode(this);
    }

    public void save() {
        EditorCookie edit = (EditorCookie)this.getCookie(EditorCookie.class);
        if (edit != null) {
            try {
                edit.saveDocument();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    public boolean parseDocument() {
        if (this.persistence == null) {
            try {
                this.persistence = this.getPersistence();
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return false;
            }
        }
        try {
            InputStream is = this.getEditorSupport().getInputStream();
            Persistence newPersistence = null;
            try {
                newPersistence = Persistence.createGraph(is, true);
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return false;
            }
            if (newPersistence != null) {
                this.persistence.merge(newPersistence, 3);
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            return false;
        }
        return true;
    }

    public void viewCanBeDisplayed() {
        boolean switchView = false;
        NotifyDescriptor.Message nd = null;
        if (!this.parseDocument() && this.getSelectedPerspective().preferredID().startsWith(DESIGN_VIEW_ID)) {
            nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PUDataObject.class, (String)"TXT_DocumentUnparsable", (Object)this.getPrimaryFile().getNameExt()), 2);
            switchView = true;
        } else if (!ProviderUtil.isValidServerInstanceOrNone(FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile())) && this.getSelectedPerspective().preferredID().startsWith(DESIGN_VIEW_ID)) {
            nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PUDataObject.class, (String)"TXT_ServerMissing"), 2);
            switchView = true;
        }
        if (switchView) {
            DialogDisplayer.getDefault().notify(nd);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PUDataObject.this.goToXmlView();
                }
            });
        }
    }

    public Persistence getPersistence() {
        if (this.persistence == null) {
            try {
                this.persistence = PersistenceMetadata.getDefault().getRoot(this.getPrimaryFile());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        assert (this.persistence != null);
        return this.persistence;
    }

    public void addPersistenceUnit(PersistenceUnit persistenceUnit) {
        ProviderUtil.makePortableIfPossible(FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile()), persistenceUnit);
        this.getPersistence().addPersistenceUnit(persistenceUnit);
        this.modelUpdatedFromUI();
    }

    public void removePersistenceUnit(PersistenceUnit persistenceUnit) {
        this.getPersistence().removePersistenceUnit(persistenceUnit);
        this.modelUpdatedFromUI();
    }

    public boolean addClass(PersistenceUnit persistenceUnit, String clazz) {
        String[] existing = persistenceUnit.getClass2();
        for (int i = 0; i < existing.length; ++i) {
            if (!clazz.equals(existing[i])) continue;
            return false;
        }
        persistenceUnit.addClass2(clazz);
        this.modelUpdatedFromUI();
        return true;
    }

    public void removeClass(PersistenceUnit persistenceUnit, String clazz) {
        persistenceUnit.removeClass2(clazz);
        this.modelUpdatedFromUI();
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        return new DesignMultiViewDesc[]{new DesignView(this, 0)};
    }

    public void showElement(Object element) {
        Object target = null;
        if (element instanceof PersistenceUnit) {
            this.openView(0);
            target = element;
        }
        if (target != null) {
            final Object key = target;
            Utils.runInAwtDispatchThread((Runnable)new Runnable(){

                public void run() {
                    PUDataObject.this.getActiveMultiViewElement0().getSectionView().openPanel(key);
                }
            });
        }
    }

    protected String getPrefixMark() {
        return null;
    }

    public ToolBarMultiViewElement getActiveMultiViewElement0() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    public void modelUpdatedFromUI() {
        this.setModified(true);
        this.modelSynchronizer.requestUpdateData();
    }

    public void updateDataFromModel(FileLock lock) throws IOException {
        this.modelSynchronizer.updateDataFromModel((Object)this.getPersistence(), lock, true);
    }

    public boolean isDeleteAllowed() {
        return true;
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return true;
    }

    protected Image getXmlViewIcon() {
        return Utilities.loadImage((String)"org/netbeans/modules/j2ee/persistence/unit/PersistenceIcon.gif");
    }

    private class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        public ModelSynchronizer(XmlMultiViewDataObject dataObject) {
            super(dataObject, 200);
        }

        protected boolean mayUpdateData(boolean allowDialog) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateDataFromModel(Object model, FileLock lock, boolean modify) {
            if (model == null) {
                return;
            }
            try {
                StringWriter out = new StringWriter();
                ((Persistence)((Object)model)).write(out);
                ((Writer)out).close();
                PUDataObject.this.getDataCache().setData(lock, ((Object)out).toString(), modify);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (Schema2BeansException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }

        protected Object getModel() {
            return PUDataObject.this.getPersistence();
        }

        protected void reloadModelFromData() {
            PUDataObject.this.parseDocument();
        }
    }

    private static class DesignView
    extends DesignMultiViewDesc {
        private static final long serialVersionUID = 1L;
        private int type;

        DesignView(PUDataObject dObj, int type) {
            super((XmlMultiViewDataObject)dObj, NbBundle.getMessage(PUDataObject.class, (String)"LBL_Design"));
            this.type = type;
        }

        public MultiViewElement createElement() {
            PUDataObject dObj = (PUDataObject)this.getDataObject();
            return new PersistenceToolBarMVElement(dObj);
        }

        public Image getIcon() {
            return Utilities.loadImage((String)"org/netbeans/modules/j2ee/persistence/unit/PersistenceIcon.gif");
        }

        public String preferredID() {
            return PUDataObject.DESIGN_VIEW_ID + String.valueOf(this.type);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(PUDataObject.HELP_ID_DESIGN_PERSISTENCE_UNIT);
        }
    }
}

