/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WindowSystemSnapshot;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ControllerHandler;
import org.netbeans.core.windows.view.EditorView;
import org.netbeans.core.windows.view.ElementAccessor;
import org.netbeans.core.windows.view.ModeAccessor;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.SlidingView;
import org.netbeans.core.windows.view.SplitAccessor;
import org.netbeans.core.windows.view.SplitView;
import org.netbeans.core.windows.view.View;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.ViewEvent;
import org.netbeans.core.windows.view.ViewHelper;
import org.netbeans.core.windows.view.ViewHierarchy;
import org.netbeans.core.windows.view.WindowSystemAccessor;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.openide.ErrorManager;
import org.openide.awt.ToolbarPool;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

class DefaultView
implements View,
Controller,
WindowDnDManager.ViewAccessor {
    private final ViewHierarchy hierarchy = new ViewHierarchy(this, new WindowDnDManager(this));
    private final ControllerHandler controllerHandler;
    private final Set showingTopComponents = new WeakSet(10);
    private static final boolean DEBUG = Debug.isLoggable(DefaultView.class);

    public DefaultView(ControllerHandler controllerHandler) {
        this.controllerHandler = controllerHandler;
    }

    public boolean isDragInProgress() {
        return this.hierarchy.isDragInProgress();
    }

    public Frame getMainWindow() {
        return this.hierarchy.getMainWindow();
    }

    public String guessSlideSide(TopComponent comp) {
        String toReturn = "left";
        if (this.hierarchy.getMaximizedModeView() != null) {
            toReturn = (String)comp.getClientProperty((Object)"lastSlideSide");
            if (toReturn == null) {
                toReturn = "left";
            }
        } else {
            Rectangle compb = comp.getBounds();
            Rectangle editorb = this.hierarchy.getPureEditorAreaBounds();
            Point leftTop = new Point(0, 0);
            SwingUtilities.convertPointToScreen(leftTop, (Component)comp);
            if (editorb.x > leftTop.x) {
                toReturn = "left";
            }
            if (editorb.x + editorb.width < leftTop.x) {
                toReturn = "right";
            }
            if (editorb.y + editorb.height < leftTop.y) {
                toReturn = "bottom";
            }
            comp.putClientProperty((Object)"lastSlideSide", (Object)toReturn);
        }
        return toReturn;
    }

    public void changeGUI(ViewEvent[] viewEvents, WindowSystemSnapshot snapshot) {
        int changeType;
        ViewEvent viewEvent;
        int i;
        WindowSystemAccessor wsa = ViewHelper.createWindowSystemAccessor(snapshot);
        if (DEBUG) {
            DefaultView.debugLog("CHANGEGUI()");
            DefaultView.debugLog("Structure=" + wsa);
            DefaultView.debugLog("");
        }
        if (wsa != null) {
            this.hierarchy.updateViewHierarchy(wsa.getModeStructureAccessor());
        }
        HashSet oldShowing = new HashSet(this.showingTopComponents);
        Set newShowing = this.hierarchy.getShowingTopComponents();
        this.showingTopComponents.clear();
        this.showingTopComponents.addAll(newShowing);
        HashSet toShow = new HashSet(newShowing);
        toShow.removeAll(oldShowing);
        Iterator it = toShow.iterator();
        while (it.hasNext()) {
            TopComponent tc = (TopComponent)it.next();
            WindowManagerImpl.getInstance().componentShowing(tc);
        }
        if (DEBUG) {
            DefaultView.debugLog("ChangeGUI: Checking view events...");
        }
        for (i = 0; i < viewEvents.length; ++i) {
            viewEvent = viewEvents[i];
            changeType = viewEvent.getType();
            if (DEBUG) {
                DefaultView.debugLog("ViewEvent=" + viewEvent);
            }
            if (changeType != 0) continue;
            if (DEBUG) {
                DefaultView.debugLog("Winsys visibility changed, visible=" + viewEvent.getNewValue());
            }
            this.windowSystemVisibilityChanged((Boolean)viewEvent.getNewValue(), wsa);
            return;
        }
        for (i = 0; i < viewEvents.length; ++i) {
            TopComponent tc;
            ModeView modeView;
            Rectangle bounds;
            viewEvent = viewEvents[i];
            changeType = viewEvent.getType();
            if (changeType == 1) {
                if (DEBUG) {
                    DefaultView.debugLog("Main window bounds joined changed");
                }
                if (wsa.getEditorAreaState() != 0 || (bounds = (Rectangle)viewEvent.getNewValue()) == null) continue;
                this.hierarchy.getMainWindow().setBounds(bounds);
                continue;
            }
            if (changeType == 2) {
                if (DEBUG) {
                    DefaultView.debugLog("Main window bounds separated changed");
                }
                if (wsa.getEditorAreaState() != 1 || (bounds = (Rectangle)viewEvent.getNewValue()) == null) continue;
                this.hierarchy.getMainWindow().setBounds(bounds);
                continue;
            }
            if (changeType == 3) {
                if (DEBUG) {
                    DefaultView.debugLog("Main window frame state joined changed");
                }
                if (wsa.getEditorAreaState() != 0) continue;
                this.hierarchy.getMainWindow().setExtendedState(wsa.getMainWindowFrameStateJoined());
                continue;
            }
            if (changeType == 4) {
                if (DEBUG) {
                    DefaultView.debugLog("Main window frame state separated changed");
                }
                if (wsa.getEditorAreaState() != 1) continue;
                this.hierarchy.getMainWindow().setExtendedState(wsa.getMainWindowFrameStateSeparated());
                continue;
            }
            if (changeType == 5) {
                if (DEBUG) {
                    DefaultView.debugLog("Editor area state changed");
                }
                this.hierarchy.updateMainWindowBounds(wsa);
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.setSeparateModesVisible(true);
                continue;
            }
            if (changeType == 6) {
                if (DEBUG) {
                    DefaultView.debugLog("Editor area frame state changed");
                }
                this.hierarchy.updateEditorAreaFrameState(wsa.getEditorAreaFrameState());
                continue;
            }
            if (changeType == 7) {
                if (DEBUG) {
                    DefaultView.debugLog("Editor area bounds changed");
                }
                this.hierarchy.updateEditorAreaBounds((Rectangle)viewEvent.getNewValue());
                continue;
            }
            if (changeType == 8) {
                if (DEBUG) {
                    DefaultView.debugLog("Editor area constraints changed");
                }
                this.hierarchy.updateDesktop(wsa);
                continue;
            }
            if (changeType == 9) {
                if (DEBUG) {
                    DefaultView.debugLog("Active mode changed, mode=" + viewEvent.getNewValue());
                }
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 10) {
                if (DEBUG) {
                    DefaultView.debugLog("Toolbar config name changed");
                }
                ToolbarPool.getDefault().setConfiguration(wsa.getToolbarConfigurationName());
                continue;
            }
            if (changeType == 11) {
                if (DEBUG) {
                    DefaultView.debugLog("Maximized mode changed");
                }
                this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(wsa.getMaximizedModeAccessor()));
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 12) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode added");
                }
                this.hierarchy.updateDesktop(wsa);
                continue;
            }
            if (changeType == 13) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode removed");
                }
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 14) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode constraints changed");
                }
                this.hierarchy.updateDesktop(wsa);
                continue;
            }
            if (changeType == 20) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode bounds changed");
                }
                if ((modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()))) == null) continue;
                modeView.getComponent().setBounds((Rectangle)viewEvent.getNewValue());
                continue;
            }
            if (changeType == 21) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode state changed");
                }
                if ((modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()))) == null) continue;
                modeView.setFrameState((Integer)viewEvent.getNewValue());
                modeView.updateFrameState();
                continue;
            }
            if (changeType == 22) {
                if (DEBUG) {
                    DefaultView.debugLog("Selected topcomponent changed, tc=" + viewEvent.getNewValue());
                }
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 23) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent added");
                }
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.setSeparateModesVisible(true);
                modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()));
                if (modeView == null) continue;
                modeView.updateFrameState();
                continue;
            }
            if (changeType == 24) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent removed");
                }
                this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(wsa.getMaximizedModeAccessor()));
                this.hierarchy.updateDesktop(wsa);
                modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()));
                if (modeView != null) {
                    modeView.removeTopComponent((TopComponent)viewEvent.getNewValue());
                }
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 31) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent display name changed, tc=" + viewEvent.getNewValue());
                }
                if ((modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()))) == null) continue;
                modeView.updateName((TopComponent)viewEvent.getNewValue());
                continue;
            }
            if (changeType == 32) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent display name annotation changed, tc=" + viewEvent.getNewValue());
                }
                if ((modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()))) == null) continue;
                modeView.updateName((TopComponent)viewEvent.getNewValue());
                continue;
            }
            if (changeType == 33) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent tooltip changed, tc=" + viewEvent.getNewValue());
                }
                if ((modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()))) == null) continue;
                modeView.updateToolTip((TopComponent)viewEvent.getNewValue());
                continue;
            }
            if (changeType == 34) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent icon changed");
                }
                if ((modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()))) == null) continue;
                modeView.updateIcon((TopComponent)viewEvent.getNewValue());
                continue;
            }
            if (changeType == 41) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent attached");
                }
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 42) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent array added:" + Arrays.asList((TopComponent[])viewEvent.getNewValue()));
                }
                this.hierarchy.updateDesktop(wsa);
                continue;
            }
            if (changeType == 43) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent array removed:" + Arrays.asList((TopComponent[])viewEvent.getNewValue()));
                }
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 44) {
                if (DEBUG) {
                    DefaultView.debugLog("TopComponent activated, tc=" + viewEvent.getNewValue());
                }
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 45) {
                if (DEBUG) {
                    DefaultView.debugLog("Mode closed, mode=" + viewEvent.getSource());
                }
                this.hierarchy.updateDesktop();
                continue;
            }
            if (changeType == 46) {
                if (DEBUG) {
                    DefaultView.debugLog("DnD performed");
                }
                this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(wsa.getMaximizedModeAccessor()));
                this.hierarchy.updateDesktop();
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 61) {
                if (DEBUG) {
                    DefaultView.debugLog("UI update");
                }
                this.hierarchy.updateUI();
                continue;
            }
            if (changeType == 62) {
                if (DEBUG) {
                    DefaultView.debugLog("Update project name");
                }
                this.hierarchy.setProjectName(wsa.getProjectName());
                continue;
            }
            if (changeType == 47 || changeType == 48) {
                if (DEBUG) {
                    DefaultView.debugLog("Top Component Auto Hide changed");
                }
                this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(wsa.getMaximizedModeAccessor()));
                this.hierarchy.updateDesktop(wsa);
                this.hierarchy.activateMode(wsa.getActiveModeAccessor());
                continue;
            }
            if (changeType == 63) {
                if (DEBUG) {
                    DefaultView.debugLog("Top component request attention");
                }
                if ((modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()))) != null) {
                    tc = (TopComponent)viewEvent.getNewValue();
                    if (tc == null) {
                        throw new NullPointerException("Top component is null for attention request");
                    }
                    modeView.requestAttention(tc);
                    continue;
                }
                ErrorManager.getDefault().log(1, "Could not find mode " + viewEvent.getSource());
                continue;
            }
            if (changeType != 64) continue;
            if (DEBUG) {
                DefaultView.debugLog("Top component cancel request attention");
            }
            if ((modeView = this.hierarchy.getModeViewForAccessor(wsa.findModeAccessor((String)viewEvent.getSource()))) != null) {
                tc = (TopComponent)viewEvent.getNewValue();
                if (tc == null) {
                    throw new NullPointerException("Top component is null for attention cancellation request");
                }
                modeView.cancelRequestAttention(tc);
                continue;
            }
            ErrorManager.getDefault().log(1, "Could not find mode " + viewEvent.getSource());
        }
        HashSet toHide = new HashSet(oldShowing);
        toHide.removeAll(newShowing);
        Iterator it2 = toHide.iterator();
        while (it2.hasNext()) {
            TopComponent tc = (TopComponent)it2.next();
            WindowManagerImpl.getInstance().componentHidden(tc);
        }
    }

    private void windowSystemVisibilityChanged(boolean visible, WindowSystemAccessor wsa) {
        if (visible) {
            this.showWindowSystem(wsa);
        } else {
            this.hideWindowSystem();
        }
    }

    private void showWindowSystem(WindowSystemAccessor wsa) {
        long start = System.currentTimeMillis();
        if (DEBUG) {
            DefaultView.debugLog("ShowWindowSystem--");
        }
        this.hierarchy.getMainWindow().initializeComponents();
        ToolbarPool.getDefault().setConfiguration(wsa.getToolbarConfigurationName());
        if (DEBUG) {
            DefaultView.debugLog(wsa.getModeStructureAccessor().toString());
        }
        this.hierarchy.getMainWindow().prepareWindow();
        if (DEBUG) {
            DefaultView.debugLog("Init view 4=" + (System.currentTimeMillis() - start) + " ms");
        }
        if (DEBUG) {
            DefaultView.debugLog("Init view 2=" + (System.currentTimeMillis() - start) + " ms");
        }
        this.hierarchy.setSplitModesVisible(true);
        if (DEBUG) {
            DefaultView.debugLog("Init view 3=" + (System.currentTimeMillis() - start) + " ms");
        }
        this.hierarchy.getMainWindow().setVisible(true);
        if (wsa.getEditorAreaState() == 0) {
            this.hierarchy.getMainWindow().setExtendedState(wsa.getMainWindowFrameStateJoined());
        } else {
            this.hierarchy.getMainWindow().setExtendedState(wsa.getMainWindowFrameStateSeparated());
        }
        this.hierarchy.setMaximizedModeView(this.hierarchy.getModeViewForAccessor(wsa.getMaximizedModeAccessor()));
        this.hierarchy.updateDesktop(wsa);
        this.hierarchy.setSeparateModesVisible(true);
        this.hierarchy.updateEditorAreaFrameState(wsa.getEditorAreaFrameState());
        this.hierarchy.updateFrameStates();
        this.hierarchy.setProjectName(wsa.getProjectName());
        if (wsa.getEditorAreaState() == 0 && this.hierarchy.getMainWindow().getExtendedState() != 6) {
            if (DEBUG) {
                DefaultView.debugLog("do updateMainWindowBoundsSeparatedHelp");
            }
            this.updateMainWindowBoundsSeparatedHelp();
            this.updateEditorAreaBoundsHelp();
        }
        this.hierarchy.activateMode(wsa.getActiveModeAccessor());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (DEBUG) {
                    DefaultView.debugLog("Installing main window listeners.");
                }
                DefaultView.this.hierarchy.installMainWindowListeners();
            }
        });
        if (DEBUG) {
            DefaultView.debugLog("Init view 5=" + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private void hideWindowSystem() {
        this.hierarchy.uninstallMainWindowListeners();
        this.hierarchy.setSeparateModesVisible(false);
        this.hierarchy.getMainWindow().setVisible(false);
        this.hierarchy.releaseAll();
    }

    public void userActivatedModeView(ModeView modeView) {
        if (DEBUG) {
            DefaultView.debugLog("User activated mode view, mode=" + modeView);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userActivatedMode(mode);
    }

    public void userActivatedModeWindow(ModeView modeView) {
        if (DEBUG) {
            DefaultView.debugLog("User activated mode window, mode=" + modeView);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userActivatedModeWindow(mode);
    }

    public void userActivatedEditorWindow() {
        if (DEBUG) {
            DefaultView.debugLog("User activated editor window");
        }
        this.controllerHandler.userActivatedEditorWindow();
    }

    public void userSelectedTab(ModeView modeView, TopComponent selected) {
        if (DEBUG) {
            DefaultView.debugLog("User selected tab, tc=" + WindowManagerImpl.getInstance().getTopComponentDisplayName(selected));
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userActivatedTopComponent(mode, selected);
    }

    public void userClosingMode(ModeView modeView) {
        if (DEBUG) {
            DefaultView.debugLog("User closing mode=" + modeView);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userClosedMode(mode);
    }

    private void removeModeViewFromHierarchy(ModeView modeView) {
        this.hierarchy.removeModeView(modeView);
        this.hierarchy.updateDesktop();
    }

    public void userResizedMainWindow(Rectangle bounds) {
        if (DEBUG) {
            DefaultView.debugLog("User resized main window");
        }
        if (this.hierarchy.getMainWindow().getExtendedState() != 6) {
            this.controllerHandler.userResizedMainWindow(bounds);
        }
        if (this.hierarchy.getMainWindow().getExtendedState() != 6) {
            this.updateMainWindowBoundsSeparatedHelp();
            this.updateEditorAreaBoundsHelp();
            this.updateSeparateBoundsForView(this.hierarchy.getSplitRootElement());
        }
    }

    public void userMovedMainWindow(Rectangle bounds) {
        if (DEBUG) {
            DefaultView.debugLog("User moved main window");
        }
        if (this.hierarchy.getMainWindow().getExtendedState() != 6) {
            this.controllerHandler.userResizedMainWindow(bounds);
        }
    }

    public void userResizedEditorArea(Rectangle bounds) {
        if (DEBUG) {
            DefaultView.debugLog("User resized editor area");
        }
        this.controllerHandler.userResizedEditorArea(bounds);
    }

    public void userResizedModeBounds(ModeView modeView, Rectangle bounds) {
        ModeAccessor modeAccessor;
        if (DEBUG) {
            DefaultView.debugLog("User resized mode");
        }
        if ((modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView)) != null) {
            ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
            this.controllerHandler.userResizedModeBounds(mode, bounds);
        }
    }

    public void userMovedSplit(SplitView splitView, ViewElement[] childrenViews, double[] splitWeights) {
        if (DEBUG) {
            DefaultView.debugLog("User moved split");
        }
        SplitAccessor splitAccessor = (SplitAccessor)this.hierarchy.getAccessorForView(splitView);
        ElementAccessor[] childrenAccessors = new ElementAccessor[childrenViews.length];
        for (int i = 0; i < childrenViews.length; ++i) {
            childrenAccessors[i] = this.hierarchy.getAccessorForView(childrenViews[i]);
        }
        ViewHelper.setSplitWeights(splitAccessor, childrenAccessors, splitWeights, this.controllerHandler);
    }

    public void userClosedTopComponent(ModeView modeView, TopComponent tc) {
        if (DEBUG) {
            DefaultView.debugLog("User closed topComponent=" + tc);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userClosedTopComponent(mode, tc);
    }

    public void userChangedFrameStateMainWindow(int frameState) {
        if (DEBUG) {
            DefaultView.debugLog("User changed frame state main window");
        }
        this.controllerHandler.userChangedFrameStateMainWindow(frameState);
    }

    public void userChangedFrameStateEditorArea(int frameState) {
        if (DEBUG) {
            DefaultView.debugLog("User changed frame state editor area");
        }
        this.controllerHandler.userChangedFrameStateEditorArea(frameState);
    }

    public void userChangedFrameStateMode(ModeView modeView, int frameState) {
        if (DEBUG) {
            DefaultView.debugLog("User changed frame state mode");
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userChangedFrameStateMode(mode, frameState);
    }

    public void userDroppedTopComponents(ModeView modeView, TopComponent[] tcs) {
        if (tcs.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's");
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userDroppedTopComponents(mode, tcs);
    }

    public void userDroppedTopComponents(ModeView modeView, TopComponent[] tcs, int index) {
        if (tcs.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's to index=" + index);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        int position = Arrays.asList(modeAccessor.getOpenedTopComponents()).indexOf(tcs[0]);
        if (position > -1 && position <= index) {
            --index;
        }
        this.controllerHandler.userDroppedTopComponents(mode, tcs, index);
    }

    public void userDroppedTopComponents(ModeView modeView, TopComponent[] tcs, String side) {
        if (tcs.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's to side=" + side);
        }
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userDroppedTopComponents(mode, tcs, side);
    }

    public void userDroppedTopComponentsIntoEmptyEditor(TopComponent[] tcs) {
        if (tcs.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's into empty editor");
        }
        this.controllerHandler.userDroppedTopComponentsIntoEmptyEditor(tcs);
    }

    public void userDroppedTopComponentsAround(TopComponent[] tcs, String side) {
        if (tcs.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's around, side=" + side);
        }
        this.controllerHandler.userDroppedTopComponentsAround(tcs, side);
    }

    public void userDroppedTopComponentsAroundEditor(TopComponent[] tcs, String side) {
        if (tcs.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's around editor, side=" + side);
        }
        this.controllerHandler.userDroppedTopComponentsAroundEditor(tcs, side);
    }

    public void userDroppedTopComponentsIntoFreeArea(TopComponent[] tcs, Rectangle bounds) {
        if (tcs.length == 0) {
            return;
        }
        if (DEBUG) {
            DefaultView.debugLog("User dropped TopComponent's into free area, bounds=" + bounds);
        }
        this.controllerHandler.userDroppedTopComponentsIntoFreeArea(tcs, bounds);
    }

    public void userDisabledAutoHide(ModeView modeView, TopComponent tc) {
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userDisabledAutoHide(tc, mode);
    }

    public void userEnabledAutoHide(ModeView modeView, TopComponent tc) {
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        String side = this.guessSlideSide(tc);
        this.controllerHandler.userEnabledAutoHide(tc, mode, side);
    }

    public void userTriggeredSlideIn(ModeView modeView, SlideOperation operation) {
        this.hierarchy.performSlideIn(operation);
    }

    public void userTriggeredSlideOut(ModeView modeView, SlideOperation operation) {
        this.hierarchy.performSlideOut(operation);
        if (operation.requestsActivation()) {
            ModeView lastNonSlidingActive = this.hierarchy.getLastNonSlidingActiveModeView();
            ModeImpl mode = null;
            if (lastNonSlidingActive != null) {
                mode = DefaultView.getModeForModeAccessor((ModeAccessor)this.hierarchy.getAccessorForView(lastNonSlidingActive));
            }
            if (mode != null) {
                this.controllerHandler.userActivatedMode(mode);
            } else {
                this.controllerHandler.userActivatedEditorWindow();
            }
        }
    }

    public void userTriggeredSlideIntoDesktop(ModeView modeView, SlideOperation operation) {
        this.hierarchy.performSlideIntoDesktop(operation);
    }

    public void userTriggeredSlideIntoEdge(ModeView modeView, SlideOperation operation) {
        this.hierarchy.performSlideIntoEdge(operation);
    }

    public void userResizedSlidingWindow(ModeView modeView, SlideOperation operation) {
        ((SlidingView)modeView).setSlideBounds(modeView.getSelectedTopComponent().getBounds());
        this.hierarchy.performSlideResize(operation);
        ModeAccessor modeAccessor = (ModeAccessor)this.hierarchy.getAccessorForView(modeView);
        ModeImpl mode = DefaultView.getModeForModeAccessor(modeAccessor);
        this.controllerHandler.userResizedSlidingMode(mode, operation.getFinishBounds());
    }

    private static ModeImpl getModeForModeAccessor(ModeAccessor accessor) {
        return accessor == null ? null : accessor.getMode();
    }

    private static ModelElement getModelElementForAccessor(ElementAccessor accessor) {
        return accessor == null ? null : accessor.getOriginator();
    }

    private void updateMainWindowBoundsSeparatedHelp() {
        this.controllerHandler.userResizedMainWindowBoundsSeparatedHelp(this.hierarchy.getMainWindow().getPureMainWindowBounds());
    }

    private void updateEditorAreaBoundsHelp() {
        Rectangle bounds = this.hierarchy.getPureEditorAreaBounds();
        this.controllerHandler.userResizedEditorAreaBoundsHelp(bounds);
    }

    void updateSeparateBoundsForView(ViewElement view) {
        if (view.getComponent() instanceof JComponent) {
            JComponent comp = (JComponent)view.getComponent();
            Dimension dim = new Dimension(comp.getSize());
            comp.setPreferredSize(dim);
            comp.putClientProperty("lastAvailableSpace", dim);
        }
        if (view instanceof ModeView) {
            ModeView mv = (ModeView)view;
            ModeAccessor ma = (ModeAccessor)this.hierarchy.getAccessorForView(mv);
            if (ma != null) {
                Component comp = mv.getComponent();
                Rectangle bounds = comp.getBounds();
                Point point = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point, comp);
                bounds.setLocation(point);
                ModeImpl mode = DefaultView.getModeForModeAccessor(ma);
                this.controllerHandler.userResizedModeBoundsSeparatedHelp(mode, bounds);
            }
        } else if (view instanceof SplitView) {
            SplitView sv = (SplitView)view;
            List children = sv.getChildren();
            Iterator i = children.iterator();
            while (i.hasNext()) {
                ViewElement child = (ViewElement)i.next();
                this.updateSeparateBoundsForView(child);
            }
        } else if (view instanceof EditorView) {
            this.updateEditorAreaBoundsHelp();
        }
    }

    public Set getModeComponents() {
        return this.hierarchy.getModeComponents();
    }

    public Set getSeparateModeFrames() {
        return this.hierarchy.getSeparateModeFrames();
    }

    public Controller getController() {
        return this;
    }

    public Component getSlidingModeComponent(String side) {
        return this.hierarchy.getSlidingModeComponent(side);
    }

    private static void debugLog(String message) {
        Debug.log(DefaultView.class, message);
    }
}

