/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.diff.EncodedReaderFactory;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DiffStreamSource
extends StreamSource {
    private final File baseFile;
    private final String revision;
    private final String title;
    private String mimeType;
    private IOException failure;
    private File remoteFile;
    private boolean binary;
    private ExecutorGroup group;

    public DiffStreamSource(File baseFile, String revision, String title) {
        this.baseFile = baseFile;
        this.revision = revision;
        this.title = title;
    }

    public String getName() {
        return this.baseFile.getName();
    }

    public String getTitle() {
        return this.title;
    }

    public void setGroup(ExecutorGroup group) {
        this.group = group;
    }

    public String getMIMEType() {
        try {
            this.init(null);
        }
        catch (IOException e) {
            return null;
        }
        return this.mimeType;
    }

    public Reader createReader() throws IOException {
        this.init(null);
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (this.binary) {
            return new StringReader(NbBundle.getMessage((Class)DiffStreamSource.class, (String)"BK5001", (Object)this.getTitle()));
        }
        return EncodedReaderFactory.getDefault().getReader(this.remoteFile, this.mimeType);
    }

    public Writer createWriter(Difference[] conflicts) throws IOException {
        throw new IOException("Operation not supported");
    }

    synchronized void init(ExecutorGroup group) throws IOException {
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        this.binary = !CvsVersioningSystem.getInstance().isText(this.baseFile);
        try {
            this.remoteFile = VersionsCache.getInstance().getRemoteFile(this.baseFile, this.revision, group);
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.binary = !CvsVersioningSystem.getInstance().isText(this.remoteFile);
            }
            this.failure = null;
        }
        catch (Exception e) {
            this.failure = new IOException("Cannot initialize stream source");
            this.failure.initCause(e);
            throw this.failure;
        }
        FileObject fo = FileUtil.toFileObject((File)this.baseFile);
        if (fo == null && this.remoteFile != null) {
            fo = FileUtil.toFileObject((File)this.remoteFile);
        }
        this.mimeType = fo != null ? fo.getMIMEType() : (this.binary ? "application/octet-stream" : "text/plain");
    }
}

