/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.system.cvss.Annotator;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.settings.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.actions.CvsCommandsMenuItem;
import org.netbeans.modules.versioning.system.cvss.util.FlatFolder;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.actions.SystemAction;

public class FileStatusProvider
extends AnnotationProvider
implements VersioningListener,
PropertyChangeListener {
    private static final int STATUS_BADGEABLE = 12;
    private static final Action[] EMPTY_ACTIONS = new Action[0];
    private static FileStatusProvider instance;
    private boolean shutdown;

    public FileStatusProvider() {
        instance = this;
    }

    public static FileStatusProvider getInstance() {
        return instance;
    }

    public String annotateNameHtml(String name, Set files) {
        if (this.shutdown) {
            return null;
        }
        if (FileStatusProvider.isManaged(files)) {
            return CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(name, files, 6622);
        }
        return null;
    }

    public String annotateName(String name, Set files) {
        if (this.shutdown) {
            return null;
        }
        if (FileStatusProvider.isManaged(files)) {
            return CvsVersioningSystem.getInstance().getAnnotator().annotateName(name, files);
        }
        return null;
    }

    public Image annotateIcon(Image icon, int iconType, Set files) {
        if (this.shutdown) {
            return null;
        }
        HashSet<File> roots = new HashSet<File>();
        boolean folderAnnotation = false;
        if (files instanceof NonRecursiveFolder) {
            FileObject folder = ((NonRecursiveFolder)files).getFolder();
            roots.add(new FlatFolder(FileUtil.toFile((FileObject)folder).getAbsolutePath()));
            folderAnnotation = true;
        } else {
            Iterator i = files.iterator();
            while (i.hasNext()) {
                FileObject fo = (FileObject)i.next();
                if (fo.isFolder()) {
                    folderAnnotation = true;
                }
                roots.add(FileUtil.toFile((FileObject)fo));
            }
        }
        if (!folderAnnotation && files.size() > 1) {
            folderAnnotation = Annotator.looksLikeLogicalFolder(files);
        }
        if (!folderAnnotation) {
            return null;
        }
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        boolean isVersioned = false;
        Iterator i = roots.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            if ((cache.getStatus(file).getStatus() & 0xC) == 0) continue;
            isVersioned = true;
            break;
        }
        if (!isVersioned) {
            return null;
        }
        return CvsVersioningSystem.getInstance().getAnnotator().annotateFolderIcon(roots, icon);
    }

    public Action[] actions(Set files) {
        if (FileStatusProvider.isManaged(files)) {
            return new Action[]{SystemAction.get((Class)CvsCommandsMenuItem.class)};
        }
        return null;
    }

    public InterceptionListener getInterceptionListener() {
        return CvsVersioningSystem.getInstance().getFileSystemHandler();
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)event.getParams()[0];
            this.fireFileStatusEvent(file);
        }
    }

    public void fireFileStatusEvent(File file) {
        FileSystem fs;
        HashMap<FileSystem, HashSet<FileObject>> folders = new HashMap<FileSystem, HashSet<FileObject>>();
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            try {
                FileObject fo = FileUtil.toFileObject((File)parent);
                if (fo == null) continue;
                fs = fo.getFileSystem();
                HashSet<FileObject> fsFolders = (HashSet<FileObject>)folders.get(fs);
                if (fsFolders == null) {
                    fsFolders = new HashSet<FileObject>();
                    folders.put(fs, fsFolders);
                }
                fsFolders.add(fo);
                continue;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null) {
            try {
                this.fireFileStatusChanged(new FileStatusEvent(fo.getFileSystem(), fo, false, true));
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        Iterator i = folders.keySet().iterator();
        while (i.hasNext()) {
            fs = (FileSystem)i.next();
            Set files = (Set)folders.get(fs);
            this.fireFileStatusChanged(new FileStatusEvent(fs, files, true, false));
        }
    }

    private static boolean isManaged(Set fileObjects) {
        boolean managed = false;
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        Iterator it = fileObjects.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            File file = FileUtil.toFile((FileObject)fo);
            if (file == null || (cache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            return true;
        }
        return false;
    }

    void shutdown() {
        this.shutdown = true;
        CvsModuleConfig.getDefault().removePropertyChangeListener(this);
        this.refreshAllAnnotations(true, true);
    }

    void init() {
        CvsModuleConfig.getDefault().addPropertyChangeListener(this);
    }

    private void refreshModifiedFiles() {
        Map files = CvsVersioningSystem.getInstance().getStatusCache().getAllModifiedFiles();
        Iterator i = files.keySet().iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            this.fireFileStatusEvent(file);
        }
    }

    public void refreshAllAnnotations(boolean icon, boolean text) {
        HashSet<FileSystem> filesystems = new HashSet<FileSystem>(1);
        File[] allRoots = File.listRoots();
        for (int i = 0; i < allRoots.length; ++i) {
            File root = allRoots[i];
            FileObject fo = FileUtil.toFileObject((File)root);
            if (fo == null) continue;
            try {
                filesystems.add(fo.getFileSystem());
                continue;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        Iterator i = filesystems.iterator();
        while (i.hasNext()) {
            FileSystem fileSystem = (FileSystem)i.next();
            this.fireFileStatusChanged(new FileStatusEvent(fileSystem, icon, text));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("textAnnotations".equals(evt.getPropertyName())) {
            this.refreshAllAnnotations(false, true);
        }
    }
}

