/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileHeader;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntHolder;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.PageID;

class MapPage {
    private int pageSize;
    private int myOffset;
    private short numFiles;
    private short maxPages;
    private long fileId;
    private long timeStamp;
    private long newTimeStamp;
    private short pageCount;
    private short checksum;
    private static final int FIXED_SIZE = 40;
    private int[] oldEOF;
    private int[] offsets;

    MapPage(int pgSz, int noFiles, int offset) {
        this.myOffset = offset;
        this.pageSize = pgSz;
        this.numFiles = (short)noFiles;
        this.oldEOF = new int[this.numFiles];
        this.maxPages = (short)((this.pageSize - 40 - 4 * this.numFiles) / 4);
        this.offsets = new int[this.maxPages];
    }

    void setEOFs(RandomAccessFile[] files) throws StorageException {
        try {
            for (int i = 0; i < this.numFiles; ++i) {
                this.oldEOF[i] = (int)files[i].length();
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    int getEOF(int index) {
        return this.oldEOF[index];
    }

    MapPage(MapPage previous) {
        this(previous.pageSize, (int)previous.numFiles, previous.myOffset + (previous.pageCount + 1) * previous.pageSize);
        this.setTimeStamps(previous.timeStamp, previous.newTimeStamp);
        this.oldEOF = new int[previous.oldEOF.length];
        System.arraycopy(previous.oldEOF, 0, this.oldEOF, 0, this.oldEOF.length);
    }

    void setFileID(long id) {
        this.fileId = id;
    }

    void setTimeStamps(long stamp, long newStamp) {
        this.timeStamp = stamp;
        this.newTimeStamp = newStamp;
    }

    void write(RandomAccessFile file) throws StorageException {
        int i;
        byte[] buffer = new byte[this.pageSize];
        IntHolder offset = new IntHolder(0);
        this.checksum = this.computeChecksum();
        Converter.writeInt(buffer, offset, this.pageSize);
        Converter.writeInt(buffer, offset, this.myOffset);
        Converter.writeShort(buffer, offset, this.numFiles);
        Converter.writeShort(buffer, offset, this.maxPages);
        Converter.writeShort(buffer, offset, this.pageCount);
        Converter.writeShort(buffer, offset, this.checksum);
        Converter.writeLong(buffer, offset, this.fileId);
        Converter.writeLong(buffer, offset, this.timeStamp);
        Converter.writeLong(buffer, offset, this.newTimeStamp);
        for (i = 0; i < this.numFiles; ++i) {
            Converter.writeInt(buffer, offset, this.oldEOF[i]);
        }
        for (i = 0; i < this.pageCount; ++i) {
            Converter.writeInt(buffer, offset, this.offsets[i]);
        }
        try {
            file.seek(this.myOffset);
            file.write(buffer);
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    MapPage(RandomAccessFile file, int offset, int pgSz) throws StorageException {
        int i;
        byte[] buffer = new byte[pgSz];
        try {
            file.seek(offset);
            file.readFully(buffer);
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        IntHolder index = new IntHolder(0);
        this.pageSize = Converter.readInt(buffer, index);
        if (this.pageSize == 0) {
            return;
        }
        if (this.pageSize != pgSz) {
            throw new StoragePersistentDataException(MessageFormat.format("Invalid page size {0}: {1} expected", new Integer(pgSz), new Integer(this.pageSize)));
        }
        this.myOffset = Converter.readInt(buffer, index);
        this.numFiles = Converter.readShort(buffer, index);
        this.maxPages = Converter.readShort(buffer, index);
        this.pageCount = Converter.readShort(buffer, index);
        this.checksum = Converter.readShort(buffer, index);
        this.fileId = Converter.readLong(buffer, index);
        this.timeStamp = Converter.readLong(buffer, index);
        this.newTimeStamp = Converter.readLong(buffer, index);
        this.oldEOF = new int[this.numFiles];
        this.offsets = new int[this.pageCount];
        for (i = 0; i < this.numFiles; ++i) {
            this.oldEOF[i] = Converter.readInt(buffer, index);
        }
        for (i = 0; i < this.pageCount; ++i) {
            this.offsets[i] = Converter.readInt(buffer, index);
        }
        if (this.checksum != this.computeChecksum()) {
            throw new StoragePersistentDataException("Invalid checksum in MapPage");
        }
    }

    boolean isEmpty() {
        return this.pageSize == 0;
    }

    MapPage getNext(RandomAccessFile file, int numPages) throws StorageException {
        if (!this.isFull()) {
            return null;
        }
        int offset = this.myOffset + this.pageSize * (this.pageCount + 1);
        if (offset >= numPages * this.pageSize) {
            return null;
        }
        return new MapPage(file, offset, this.pageSize);
    }

    void checkParameters(int thePageSize, int theNumberOfFiles) throws StorageException {
        if (thePageSize != this.pageSize) {
            throw new StoragePersistentDataException("Map page contains wrong page size.");
        }
        if (theNumberOfFiles != this.numFiles) {
            throw new StoragePersistentDataException("Map page contains wrong number of files.");
        }
    }

    void checkFileHeader(RandomAccessFile file) throws StorageException {
        FileHeader header = new FileHeader(file);
        if (header.timeStamp != this.timeStamp && header.timeStamp != this.newTimeStamp) {
            throw new StoragePersistentDataException("Map page contains invalid timestamp" + header.timeStamp + " valid would be " + this.timeStamp + " or " + this.newTimeStamp);
        }
        if (header.fileId != this.fileId) {
            throw new StoragePersistentDataException("Map page contains invalid file id");
        }
    }

    int nextPageOffset() {
        return this.myOffset + (this.pageCount + 1) * this.pageSize;
    }

    void add(CachedPage page) {
        short s = this.pageCount;
        this.pageCount = (short)(s + 1);
        this.offsets[s] = this.encode(page.key);
    }

    boolean isFull() {
        return this.pageCount == this.maxPages;
    }

    private int encode(PageID page) {
        return page.fileIndex << 20 | page.offset / this.pageSize;
    }

    private PageID decode(int pageID) {
        return new PageID(pageID >>> 20, (pageID & 0xFFFFF) * this.pageSize);
    }

    short computeChecksum() {
        int i;
        int sum = 0;
        sum = (int)((long)sum + this.fileId);
        sum = (int)((long)sum + this.timeStamp);
        sum = (int)((long)sum + this.newTimeStamp);
        sum += this.pageCount;
        for (i = 0; i < this.numFiles; ++i) {
            sum += this.oldEOF[i];
        }
        for (i = 0; i < this.pageCount; ++i) {
            sum += this.offsets[i];
        }
        return (short)((sum & 0xFFFF) + (sum >>> 16));
    }

    void truncateFiles(RandomAccessFile[] files) throws StorageException {
        try {
            for (int i = 0; i < files.length; ++i) {
                files[i].setLength(this.oldEOF[i]);
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    void recover(RandomAccessFile[] files, RandomAccessFile logFile, int numPages, byte[] buffer) throws StorageException {
        try {
            int logOffset;
            for (int i = 0; i < this.pageCount && (logOffset = this.myOffset + this.pageSize * (i + 1)) < numPages * this.pageSize; ++i) {
                PageID entry = this.decode(this.offsets[i]);
                files[entry.fileIndex].seek(entry.offset);
                logFile.seek(logOffset);
                logFile.readFully(buffer);
                files[entry.fileIndex].write(buffer);
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }
}

