/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.SafeDeletePanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SafeDeleteUI
implements RefactoringUI {
    private final Element[] elementsToDelete;
    private final SafeDeleteRefactoring refactoring;
    private SafeDeletePanel panel;
    private ResourceBundle bundle;

    public SafeDeleteUI(Element[] selectedElements) {
        this.elementsToDelete = selectedElements;
        this.refactoring = new SafeDeleteRefactoring(this.elementsToDelete);
    }

    public Problem checkParameters() {
        this.refactoring.setCheckInComments(this.panel.isSearchInComments());
        return this.refactoring.fastCheckParameters();
    }

    public String getDescription() {
        if (this.elementsToDelete[0] instanceof JavaClass) {
            return this.getString("DSC_SafeDelClasses", this.elementsToDelete);
        }
        if (this.elementsToDelete[0] instanceof Method) {
            if (this.elementsToDelete.length > 1) {
                return this.getString("DSC_SafeDelMethods");
            }
            return this.getString("DSC_SafeDelMethod", this.elementsToDelete[0]);
        }
        if (this.elementsToDelete[0] instanceof Resource) {
            return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"DSC_SafeDel", (Object)((Resource)this.elementsToDelete[0]).getName());
        }
        return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"DSC_SafeDel", (Object[])this.elementsToDelete);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SafeDeleteUI.class.getName());
    }

    public String getName() {
        return NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"LBL_SafeDel");
    }

    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
        if (this.panel == null) {
            this.panel = new SafeDeletePanel(this.refactoring, Arrays.asList(this.elementsToDelete));
        }
        return this.panel;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public boolean isQuery() {
        return false;
    }

    public Problem setParameters() {
        this.refactoring.setCheckInComments(this.panel.isSearchInComments());
        return this.refactoring.checkParameters();
    }

    private String getString(String key) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle((Class)SafeDeleteUI.class);
        }
        return this.bundle.getString(key);
    }

    private String getString(String key, Object value) {
        return new MessageFormat(this.getString(key)).format(new Object[]{value});
    }
}

