/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.ui.CheckNode;
import org.netbeans.modules.refactoring.ui.CheckRenderer;

class CheckNodeListener
implements MouseListener,
KeyListener {
    private final boolean isQuery;

    public CheckNodeListener(boolean isQuery) {
        this.isQuery = isQuery;
    }

    public void mouseClicked(MouseEvent e) {
        int y;
        JTree tree = (JTree)e.getSource();
        Point p = e.getPoint();
        int x = e.getX();
        int row = tree.getRowForLocation(x, y = e.getY());
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            CheckNode node = (CheckNode)path.getLastPathComponent();
            if (this.isQuery) {
                if (e.getClickCount() == 2) {
                    if (node.getUserObject() instanceof RefactoringElement) {
                        CheckNodeListener.findInSource(node);
                    } else if (tree.isCollapsed(row)) {
                        tree.expandRow(row);
                    } else {
                        tree.collapseRow(row);
                    }
                }
            } else {
                Rectangle chRect = CheckRenderer.getCheckBoxRectangle();
                Rectangle rowRect = tree.getPathBounds(path);
                chRect.setLocation(chRect.x + rowRect.x, chRect.y + rowRect.y);
                if (e.getClickCount() == 1 && chRect.contains(p)) {
                    boolean isSelected = !node.isSelected();
                    node.setSelected(isSelected);
                    if (node.getSelectionMode() == 4) {
                        if (isSelected) {
                            tree.expandPath(path);
                        } else {
                            tree.collapsePath(path);
                        }
                    }
                    ((DefaultTreeModel)tree.getModel()).nodeChanged(node);
                    if (row == 0) {
                        tree.revalidate();
                        tree.repaint();
                    }
                } else if (e.getClickCount() == 2 && !chRect.contains(p)) {
                    if (node.getUserObject() instanceof RefactoringElement) {
                        CheckNodeListener.findInSource(node);
                    } else if (tree.isCollapsed(row)) {
                        tree.expandRow(row);
                    } else {
                        tree.collapseRow(row);
                    }
                }
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        JTree tree;
        TreePath path;
        if (e.getKeyCode() == 10 && (path = (tree = (JTree)e.getSource()).getSelectionPath()) != null) {
            CheckNode node = (CheckNode)path.getLastPathComponent();
            CheckNodeListener.findInSource(node);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        JTree tree;
        TreePath path;
        if (e.getKeyChar() == ' ' && (path = (tree = (JTree)e.getSource()).getSelectionPath()) != null) {
            CheckNode node;
            node.setSelected(!(node = (CheckNode)path.getLastPathComponent()).isSelected());
            e.consume();
        }
    }

    static void findInSource(CheckNode node) {
        Object o = node.getUserObject();
        if (o instanceof RefactoringElement) {
            ((RefactoringElement)o).openInEditor();
        }
    }
}

