/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.refactoring.api.AnonymousToInnerRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.openide.actions.EditAction;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AnonymousToInnerPanel
extends CustomRefactoringPanel {
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final String[] columnNames = new String[]{AnonymousToInnerPanel.getString("LBL_AnonymousToInnerColName"), AnonymousToInnerPanel.getString("LBL_AnonymousToInnerColType"), "Variable"};
    private static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";
    private static Action editAction = null;
    private ParametersPanel parentPanel;
    private ParamTableModel model;
    private AnonymousToInnerRefactoring refactoring;
    private boolean initialized;
    private JPanel buttonsPanel;
    private JPanel eastPanel;
    private JPanel fillPanel;
    private JComboBox modifiersCombo;
    private JLabel modifiersLabel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JLabel name;
    private JTextField nameField;
    private JTable paramTable;
    private JLabel parameters;
    private JCheckBox staticCheckBox;
    private JScrollPane westPanel;

    public AnonymousToInnerPanel(AnonymousToInnerRefactoring ref, ParametersPanel parent) {
        this.parentPanel = parent;
        this.refactoring = ref;
        this.model = new ParamTableModel(columnNames, 0);
        this.initComponents();
    }

    public void initialize() {
        if (!this.initialized) {
            this.nameField.setText("NewClass");
            this.staticCheckBox.setSelected((this.refactoring.getModifiers() & 8) != 0);
            this.setAccessModifier();
            this.initTableData();
            this.nameField.requestFocus();
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent event) {
                    AnonymousToInnerPanel.this.parentPanel.stateChanged(null);
                }

                public void insertUpdate(DocumentEvent event) {
                    AnonymousToInnerPanel.this.parentPanel.stateChanged(null);
                }

                public void removeUpdate(DocumentEvent event) {
                    AnonymousToInnerPanel.this.parentPanel.stateChanged(null);
                }
            });
            this.nameField.setSelectionStart(0);
            this.nameField.setSelectionEnd(this.nameField.getText().length());
            this.initialized = true;
        }
    }

    private void initComponents() {
        this.parameters = new JLabel();
        this.staticCheckBox = new JCheckBox();
        this.eastPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.fillPanel = new JPanel();
        this.westPanel = new JScrollPane();
        this.paramTable = new JTable();
        this.modifiersLabel = new JLabel();
        this.modifiersCombo = new JComboBox();
        this.name = new JLabel();
        this.nameField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setName(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_AnonymousToInner"));
        this.parameters.setLabelFor(this.paramTable);
        Mnemonics.setLocalizedText((JLabel)this.parameters, (String)NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"LBL_AnonymousToInnerParameters"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.parameters, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.staticCheckBox, (String)NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"LBL_AnonymousToInnerStatic"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 1, 0);
        this.add((Component)this.staticCheckBox, gridBagConstraints);
        this.staticCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"ACSD_DeclareStatic"));
        this.staticCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"ACSD_DeclareStaticDescription"));
        this.eastPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(1, 11, 1, 1));
        this.moveUpButton.setMnemonic(AnonymousToInnerPanel.getString("LBL_AnonymousToInnerMoveUp_MNEM").charAt(0));
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_AnonymousToInnerMoveUp"));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnonymousToInnerPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setMnemonic(AnonymousToInnerPanel.getString("LBL_AnonymousToInnerMoveDown_MNEM").charAt(0));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_AnonymousToInnerMoveDown"));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnonymousToInnerPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.eastPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.eastPanel.add((Component)this.fillPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.eastPanel, gridBagConstraints);
        this.westPanel.setPreferredSize(new Dimension(453, 100));
        this.paramTable.setModel(this.model);
        this.initRenderer();
        this.paramTable.getSelectionModel().addListSelectionListener(this.getListener1());
        this.paramTable.getSelectionModel().setSelectionMode(1);
        this.model.addTableModelListener(this.getListener2());
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(113, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getActionMap().put(ACTION_INLINE_EDITOR, AnonymousToInnerPanel.getEditAction());
        this.paramTable.setSurrendersFocusOnKeystroke(true);
        this.paramTable.setCellSelectionEnabled(false);
        this.paramTable.setRowSelectionAllowed(true);
        this.paramTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.paramTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.westPanel.setViewportView(this.paramTable);
        this.paramTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"ACSD_paramTable"));
        this.paramTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"ACSD_paramTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.westPanel, gridBagConstraints);
        this.modifiersLabel.setDisplayedMnemonic(AnonymousToInnerPanel.getString("LBL_AnonymousToInnerMods_MNEM").charAt(0));
        this.modifiersLabel.setLabelFor(this.modifiersCombo);
        Mnemonics.setLocalizedText((JLabel)this.modifiersLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("LBL_AnonymousToInnerMods"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.modifiersLabel, gridBagConstraints);
        this.modifiersCombo.setModel(new DefaultComboBoxModel<String>(modifierNames));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.modifiersCombo, gridBagConstraints);
        this.modifiersCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"ACSD_methodAcc"));
        this.modifiersCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"ACSD_methodAcc"));
        this.name.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.name, (String)NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"LBL_AnonymousToInnerName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.name, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.nameField, gridBagConstraints);
        this.nameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"ACSD_InnerClassName"));
        this.nameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)"ACSD_InnerClassNameDescription"));
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.doMove(1);
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.doMove(-1);
    }

    public String getInnerName() {
        return this.nameField.getText();
    }

    public void requestFocus() {
        this.nameField.requestFocus();
    }

    public int getModifiers() {
        int mod = 0;
        switch (this.modifiersCombo.getSelectedIndex()) {
            case 3: {
                mod = 2;
                break;
            }
            case 0: {
                mod = 1;
                break;
            }
            case 1: {
                mod = 4;
            }
        }
        return mod | (this.staticCheckBox.isSelected() ? 8 : 0);
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    private ListSelectionListener getListener1() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!AnonymousToInnerPanel.this.initialized || e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int minIndex = lsm.getMinSelectionIndex();
                    int maxIndex = lsm.getMaxSelectionIndex();
                    AnonymousToInnerPanel.this.setButtons(minIndex, maxIndex);
                } else {
                    AnonymousToInnerPanel.this.moveDownButton.setEnabled(false);
                    AnonymousToInnerPanel.this.moveUpButton.setEnabled(false);
                }
            }
        };
    }

    private TableModelListener getListener2() {
        return new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (!AnonymousToInnerPanel.this.initialized) {
                    return;
                }
                int[] selectedRows = AnonymousToInnerPanel.this.paramTable.getSelectedRows();
                if (selectedRows.length != 0) {
                    int min = selectedRows[0];
                    int max = selectedRows[selectedRows.length - 1];
                    AnonymousToInnerPanel.this.setButtons(min, max);
                }
                AnonymousToInnerPanel.this.parentPanel.stateChanged(null);
            }
        };
    }

    private boolean acceptEditedValue() {
        TableCellEditor tce = this.paramTable.getCellEditor();
        if (tce != null) {
            return this.paramTable.getCellEditor().stopCellEditing();
        }
        return false;
    }

    private void doMove(int step) {
        this.acceptEditedValue();
        ListSelectionModel selectionModel = this.paramTable.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        selectionModel.clearSelection();
        this.model.moveRow(min, max, min + step);
        selectionModel.addSelectionInterval(min + step, max + step);
    }

    private void setButtons(int min, int max) {
        int r = this.model.getRowCount() - 1;
        this.moveUpButton.setEnabled(min > 0);
        this.moveDownButton.setEnabled(max < r);
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)AnonymousToInnerPanel.class, (String)key);
    }

    private void initRenderer() {
        TableColumnModel tcm = this.paramTable.getColumnModel();
        Enumeration<TableColumn> columns = this.paramTable.getColumnModel().getColumns();
        this.paramTable.removeColumn(tcm.getColumn(2));
        while (columns.hasMoreElements()) {
            TableColumn tc = columns.nextElement();
            tc.setCellRenderer(new ParamRenderer());
        }
    }

    private void setAccessModifier() {
        int mod = this.refactoring.getModifiers();
        if (Modifier.isPrivate(mod)) {
            this.modifiersCombo.setSelectedIndex(3);
        } else if (Modifier.isProtected(mod)) {
            this.modifiersCombo.setSelectedIndex(1);
        } else if (Modifier.isPublic(mod)) {
            this.modifiersCombo.setSelectedIndex(0);
        } else {
            this.modifiersCombo.setSelectedIndex(2);
        }
    }

    private void initTableData() {
        AnonymousToInnerRefactoring.ParameterInfo[] pars = this.refactoring.getParamTable();
        for (int i = 0; i < pars.length; ++i) {
            AnonymousToInnerRefactoring.ParameterInfo par = pars[i];
            Variable var = par.getVariable();
            Object[] row = new Object[]{par.getName(), var.getType().getName(), var};
            this.model.addRow(row);
        }
    }

    private static Action getEditAction() {
        if (editAction == null) {
            editAction = new EditAction();
        }
        return editAction;
    }

    static class ParamTableModel
    extends DefaultTableModel {
        public ParamTableModel(Object[] data, int rowCount) {
            super(data, rowCount);
        }

        public boolean isCellEditable(int row, int column) {
            return column <= 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ParamRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        Color origBackground;

        public ParamRenderer() {
            this.setOpaque(true);
            this.origBackground = this.getBackground();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                this.setBackground(UIManager.getColor("Panel.background"));
            }
            return this;
        }
    }
}

