/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openidex.search.FileObjectFilter;

class SimpleSearchIterator
implements Iterator {
    private Enumeration childrenEnum;
    private List filters;
    private List filtersCopy;
    private final boolean recursive;
    private final ArrayList enums = new ArrayList();
    private final ArrayList filterLists = new ArrayList();
    private boolean upToDate = false;
    private DataObject nextObject;
    static final /* synthetic */ boolean $assertionsDisabled;

    SimpleSearchIterator(DataFolder folder, boolean recursive, List filters) {
        this.childrenEnum = folder.children(false);
        this.recursive = recursive;
        this.filters = filters != null ? new ArrayList(filters) : null;
    }

    public boolean hasNext() {
        if (!this.upToDate) {
            this.update();
        }
        return this.nextObject != null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.upToDate = false;
        return this.nextObject;
    }

    private void update() {
        if (!$assertionsDisabled && this.upToDate) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.childrenEnum == null) {
            throw new AssertionError();
        }
        do {
            if (this.childrenEnum.hasMoreElements()) {
                Object next = this.childrenEnum.nextElement();
                DataObject dataObject = (DataObject)next;
                FileObject file = dataObject.getPrimaryFile();
                if (file.isFolder()) {
                    if (!this.recursive) continue;
                    if (this.filters != null) {
                        List subfolderFilters = this.checkFolderFilters(file);
                        if (subfolderFilters == null) continue;
                        this.filterLists.add(this.filters);
                        if (subfolderFilters.size() != this.filters.size()) {
                            this.filters = !subfolderFilters.isEmpty() ? subfolderFilters : null;
                        }
                    } else {
                        this.filterLists.add(null);
                    }
                    this.enums.add(this.childrenEnum);
                    this.childrenEnum = ((DataFolder)dataObject).children(false);
                    continue;
                }
                if (this.filters != null && !this.checkFileFilters(file)) continue;
                this.nextObject = dataObject;
                break;
            }
            if (!$assertionsDisabled && this.enums.isEmpty() != this.filterLists.isEmpty()) {
                throw new AssertionError();
            }
            this.nextObject = null;
            if (this.enums.isEmpty()) {
                this.childrenEnum = null;
                continue;
            }
            this.childrenEnum = (Enumeration)this.enums.remove(this.enums.size() - 1);
            this.filters = (List)this.filterLists.remove(this.filterLists.size() - 1);
            if (this.filtersCopy == null || this.filtersCopy.size() == this.filters.size()) continue;
            this.filtersCopy = null;
        } while (this.childrenEnum != null);
        this.upToDate = true;
    }

    private List checkFolderFilters(FileObject folder) {
        if (!$assertionsDisabled && !folder.isFolder()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.filters == null) {
            throw new AssertionError();
        }
        if (this.filtersCopy == null) {
            this.filtersCopy = new ArrayList(this.filters);
        }
        List result = this.filtersCopy;
        Iterator i = result.iterator();
        block5: while (i.hasNext()) {
            FileObjectFilter filter = (FileObjectFilter)i.next();
            int traverseCommand = filter.traverseFolder(folder);
            switch (traverseCommand) {
                case 1: {
                    continue block5;
                }
                case 0: {
                    result = null;
                    break block5;
                }
                case 2: {
                    i.remove();
                    this.filtersCopy = null;
                    continue block5;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue block5;
                }
            }
        }
        return result;
    }

    private boolean checkFileFilters(FileObject file) {
        if (!$assertionsDisabled && file.isFolder()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.filters == null) {
            throw new AssertionError();
        }
        Iterator i = this.filters.iterator();
        while (i.hasNext()) {
            FileObjectFilter filter = (FileObjectFilter)i.next();
            if (filter.searchFile(file)) continue;
            return false;
        }
        return true;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        $assertionsDisabled = !SimpleSearchIterator.class.desiredAssertionStatus();
    }
}

