/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesNodeModel;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class WatchesNodeModel
extends VariablesNodeModel {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/Watch";

    public WatchesNodeModel(ContextProvider lookupProvider) {
        super(lookupProvider);
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return NbBundle.getBundle((Class)WatchesNodeModel.class).getString("CTL_WatchesModel_Column_Name_Name");
        }
        if (o instanceof JPDAWatch) {
            return ((JPDAWatch)o).getExpression();
        }
        return super.getDisplayName(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return "Root";
        }
        if (o instanceof JPDAWatch) {
            JPDAWatch w = (JPDAWatch)o;
            boolean evaluated = VariablesTreeModelFilter.isEvaluated(o);
            if (!evaluated) {
                return w.getExpression();
            }
            String e = w.getExceptionDescription();
            if (e != null) {
                return w.getExpression() + " = >" + e + "<";
            }
            String t = w.getType();
            if (t == null) {
                return w.getExpression() + " = " + w.getValue();
            }
            try {
                return w.getExpression() + " = (" + w.getType() + ") " + w.getToStringValue();
            }
            catch (InvalidExpressionException ex) {
                return ex.getLocalizedMessage();
            }
        }
        return super.getShortDescription(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return WATCH;
        }
        if (o instanceof JPDAWatch) {
            return WATCH;
        }
        return super.getIconBase(o);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }
}

