/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.models.ThreadsActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class CallStackActionsProvider
implements NodeActionsProvider {
    private final Action MAKE_CURRENT_ACTION = Models.createAction((String)NbBundle.getBundle((Class)ThreadsActionsProvider.class).getString("CTL_CallstackAction_MakeCurrent_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            CallStackActionsProvider.this.makeCurrent((CallStackFrame)nodes[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private static final Action POP_TO_HERE_ACTION = Models.createAction((String)NbBundle.getBundle((Class)ThreadsActionsProvider.class).getString("CTL_CallstackAction_PopToHere_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            CallStackActionsProvider.popToHere((CallStackFrame)nodes[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private JPDADebugger debugger;
    private ContextProvider lookupProvider;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$jpda$ui$SourcePath;

    public CallStackActionsProvider(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[0];
        }
        if (!(node instanceof CallStackFrame)) {
            throw new UnknownTypeException(node);
        }
        boolean popToHere = this.debugger.canPopFrames();
        if (popToHere) {
            return new Action[]{this.MAKE_CURRENT_ACTION, POP_TO_HERE_ACTION};
        }
        return new Action[]{this.MAKE_CURRENT_ACTION};
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof CallStackFrame) {
            this.makeCurrent((CallStackFrame)node);
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static void popToHere(CallStackFrame frame) {
        try {
            JPDAThread t = frame.getThread();
            CallStackFrame[] stack = t.getCallStack();
            int k = stack.length;
            if (k < 2) {
                return;
            }
            for (int i = 0; i < k; ++i) {
                if (!stack[i].equals(frame)) continue;
                if (i > 0) {
                    stack[i - 1].popFrame();
                }
                return;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    private void makeCurrent(final CallStackFrame frame) {
        if (this.debugger.getCurrentCallStackFrame() != frame) {
            frame.makeCurrent();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String language = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
                    SourcePath sp = (SourcePath)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, class$org$netbeans$modules$debugger$jpda$ui$SourcePath == null ? (class$org$netbeans$modules$debugger$jpda$ui$SourcePath = CallStackActionsProvider.class$("org.netbeans.modules.debugger.jpda.ui.SourcePath")) : class$org$netbeans$modules$debugger$jpda$ui$SourcePath);
                    sp.showSource(frame, language);
                }
            });
        }
    }
}

