/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.Vector;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsTreeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    private Vector listeners = new Vector();
    private static final String ZEROS = "            ";
    private JPDABreakpoint currentBreakpoint;

    static int log10(int n) {
        int l = 1;
        while ((n /= 10) > 0) {
            ++l;
        }
        return l;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String z = ZEROS;
        while (z.length() < n) {
            z = z + " ";
        }
        return z;
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o instanceof LineBreakpoint) {
            int max;
            int num0;
            LineBreakpoint b = (LineBreakpoint)o;
            int lineNum = b.getLineNumber();
            String line = Integer.toString(lineNum);
            Integer maxInt = (Integer)BreakpointsTreeModelFilter.MAX_LINES.get(b);
            if (maxInt != null && (num0 = BreakpointsNodeModel.log10(max = maxInt.intValue()) - BreakpointsNodeModel.log10(lineNum)) > 0) {
                line = BreakpointsNodeModel.zeros(num0) + line;
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName(b), (Object)line));
        }
        if (o instanceof ThreadBreakpoint) {
            ThreadBreakpoint b = (ThreadBreakpoint)o;
            if (b.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Started_Breakpoint"));
            }
            if (b.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Death_Breakpoint"));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Breakpoint"));
        }
        if (o instanceof FieldBreakpoint) {
            FieldBreakpoint b = (FieldBreakpoint)o;
            if (b.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Field_Access_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getClassName()), (Object)b.getFieldName()));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Field_Modification_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getClassName()), (Object)b.getFieldName()));
        }
        if (o instanceof MethodBreakpoint) {
            MethodBreakpoint b = (MethodBreakpoint)o;
            String className = "";
            String[] fs = b.getClassFilters();
            if (fs.length > 0) {
                className = fs[0];
            }
            if (b.getMethodName().equals("")) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_All_Methods_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Method_Breakpoint", (Object)BreakpointsNodeModel.getShort(className), (Object)b.getMethodName()));
        }
        if (o instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint b = (ClassLoadUnloadBreakpoint)o;
            String className = "";
            String[] fs = b.getClassFilters();
            if (fs.length > 0) {
                className = fs[0];
            } else {
                fs = b.getClassExclusionFilters();
                if (fs.length > 0) {
                    className = fs[0];
                }
            }
            if (b.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Loaded_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
            }
            if (b.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Unloaded_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
        }
        if (o instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint b = (ExceptionBreakpoint)o;
            if (b.getCatchType() == 1) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Catched_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getExceptionClassName())));
            }
            if (b.getCatchType() == 2) {
                return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Uncatched_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getExceptionClassName())));
            }
            return this.bold((JPDABreakpoint)b, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Breakpoint", (Object)BreakpointsNodeModel.getShort(b.getExceptionClassName())));
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o instanceof LineBreakpoint) {
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName((LineBreakpoint)o), (Object)("" + ((LineBreakpoint)o).getLineNumber()));
        }
        if (o instanceof ThreadBreakpoint) {
            ThreadBreakpoint b = (ThreadBreakpoint)o;
            if (b.getBreakpointType() == 1) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Started_Breakpoint");
            }
            if (b.getBreakpointType() == 2) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Death_Breakpoint");
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Thread_Breakpoint");
        }
        if (o instanceof FieldBreakpoint) {
            FieldBreakpoint b = (FieldBreakpoint)o;
            if (b.getBreakpointType() == 1) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Field_Access_Breakpoint", (Object)b.getClassName(), (Object)b.getFieldName());
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Field_Modification_Breakpoint", (Object)b.getClassName(), (Object)b.getFieldName());
        }
        if (o instanceof MethodBreakpoint) {
            MethodBreakpoint b = (MethodBreakpoint)o;
            String className = "";
            String[] fs = b.getClassFilters();
            if (fs.length > 0) {
                className = fs[0];
            }
            if (b.getMethodName().equals("")) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_All_Methods_Breakpoint", (Object)className);
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Method_Breakpoint", (Object)className, (Object)b.getMethodName());
        }
        if (o instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint b = (ClassLoadUnloadBreakpoint)o;
            String className = "";
            String[] fs = b.getClassFilters();
            if (fs.length > 0) {
                className = fs[0];
            } else {
                fs = b.getClassExclusionFilters();
                if (fs.length > 0) {
                    className = fs[0];
                }
            }
            if (b.getBreakpointType() == 1) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Loaded_Breakpoint", (Object)className);
            }
            if (b.getBreakpointType() == 2) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Unloaded_Breakpoint", (Object)className);
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Class_Breakpoint", (Object)className);
        }
        if (o instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint b = (ExceptionBreakpoint)o;
            if (b.getCatchType() == 1) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Catched_Breakpoint", (Object)b.getExceptionClassName());
            }
            if (b.getCatchType() == 2) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Uncatched_Breakpoint", (Object)b.getExceptionClassName());
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Exception_Breakpoint", (Object)b.getExceptionClassName());
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        if (o instanceof LineBreakpoint) {
            return LINE_BREAKPOINT;
        }
        if (o instanceof ThreadBreakpoint) {
            return BREAKPOINT;
        }
        if (o instanceof FieldBreakpoint) {
            return BREAKPOINT;
        }
        if (o instanceof MethodBreakpoint) {
            return BREAKPOINT;
        }
        if (o instanceof ClassLoadUnloadBreakpoint) {
            return BREAKPOINT;
        }
        if (o instanceof ExceptionBreakpoint) {
            return BREAKPOINT;
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    void fireNodeChanged(JPDABreakpoint b) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)b));
        }
    }

    static String getShort(String s) {
        if (s.indexOf(42) >= 0) {
            return s;
        }
        int i = s.lastIndexOf(46);
        if (i < 0) {
            return s;
        }
        return s.substring(i + 1);
    }

    private String bold(JPDABreakpoint b, String name) {
        return b == this.currentBreakpoint ? BoldVariablesTableModelFilterFirst.toHTML(name, true, false, null) : name;
    }

    public void setCurrentBreakpoint(JPDABreakpoint currentBreakpoint) {
        if (this.currentBreakpoint != null) {
            this.fireNodeChanged(this.currentBreakpoint);
        }
        this.currentBreakpoint = currentBreakpoint;
        if (currentBreakpoint != null) {
            this.fireNodeChanged(currentBreakpoint);
        }
    }
}

