/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.DebuggerManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class Properties {
    private static Properties defaultProperties;
    static /* synthetic */ Class class$org$netbeans$api$debugger$Properties$Reader;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static synchronized Properties getDefault() {
        if (defaultProperties == null) {
            defaultProperties = new PropertiesImpl();
        }
        return defaultProperties;
    }

    public abstract String getString(String var1, String var2);

    public abstract void setString(String var1, String var2);

    public abstract int getInt(String var1, int var2);

    public abstract void setInt(String var1, int var2);

    public abstract char getChar(String var1, char var2);

    public abstract void setChar(String var1, char var2);

    public abstract float getFloat(String var1, float var2);

    public abstract void setFloat(String var1, float var2);

    public abstract long getLong(String var1, long var2);

    public abstract void setLong(String var1, long var2);

    public abstract double getDouble(String var1, double var2);

    public abstract void setDouble(String var1, double var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void setBoolean(String var1, boolean var2);

    public abstract byte getByte(String var1, byte var2);

    public abstract void setByte(String var1, byte var2);

    public abstract short getShort(String var1, short var2);

    public abstract void setShort(String var1, short var2);

    public abstract Object getObject(String var1, Object var2);

    public abstract void setObject(String var1, Object var2);

    public abstract Object[] getArray(String var1, Object[] var2);

    public abstract void setArray(String var1, Object[] var2);

    public abstract Collection getCollection(String var1, Collection var2);

    public abstract void setCollection(String var1, Collection var2);

    public abstract Map getMap(String var1, Map var2);

    public abstract void setMap(String var1, Map var2);

    public abstract Properties getProperties(String var1);

    private static class DelegatingProperties
    extends Properties {
        private Properties delegatingProperties;
        private String root;

        DelegatingProperties(Properties properties, String root) {
            this.delegatingProperties = properties;
            this.root = root;
        }

        public String getString(String propertyName, String defaultValue) {
            return this.delegatingProperties.getString(this.root + '.' + propertyName, defaultValue);
        }

        public void setString(String propertyName, String value) {
            this.delegatingProperties.setString(this.root + '.' + propertyName, value);
        }

        public int getInt(String propertyName, int defaultValue) {
            return this.delegatingProperties.getInt(this.root + '.' + propertyName, defaultValue);
        }

        public void setInt(String propertyName, int value) {
            this.delegatingProperties.setInt(this.root + '.' + propertyName, value);
        }

        public byte getByte(String propertyName, byte defaultValue) {
            return this.delegatingProperties.getByte(this.root + '.' + propertyName, defaultValue);
        }

        public void setByte(String propertyName, byte value) {
            this.delegatingProperties.setByte(this.root + '.' + propertyName, value);
        }

        public char getChar(String propertyName, char defaultValue) {
            return this.delegatingProperties.getChar(this.root + '.' + propertyName, defaultValue);
        }

        public void setChar(String propertyName, char value) {
            this.delegatingProperties.setChar(this.root + '.' + propertyName, value);
        }

        public boolean getBoolean(String propertyName, boolean defaultValue) {
            return this.delegatingProperties.getBoolean(this.root + '.' + propertyName, defaultValue);
        }

        public void setBoolean(String propertyName, boolean value) {
            this.delegatingProperties.setBoolean(this.root + '.' + propertyName, value);
        }

        public short getShort(String propertyName, short defaultValue) {
            return this.delegatingProperties.getShort(this.root + '.' + propertyName, defaultValue);
        }

        public void setShort(String propertyName, short value) {
            this.delegatingProperties.setShort(this.root + '.' + propertyName, value);
        }

        public long getLong(String propertyName, long defaultValue) {
            return this.delegatingProperties.getLong(this.root + '.' + propertyName, defaultValue);
        }

        public void setLong(String propertyName, long value) {
            this.delegatingProperties.setLong(this.root + '.' + propertyName, value);
        }

        public double getDouble(String propertyName, double defaultValue) {
            return this.delegatingProperties.getDouble(this.root + '.' + propertyName, defaultValue);
        }

        public void setDouble(String propertyName, double value) {
            this.delegatingProperties.setDouble(this.root + '.' + propertyName, value);
        }

        public float getFloat(String propertyName, float defaultValue) {
            return this.delegatingProperties.getFloat(this.root + '.' + propertyName, defaultValue);
        }

        public void setFloat(String propertyName, float value) {
            this.delegatingProperties.setFloat(this.root + '.' + propertyName, value);
        }

        public Object getObject(String propertyName, Object defaultValue) {
            return this.delegatingProperties.getObject(this.root + '.' + propertyName, defaultValue);
        }

        public void setObject(String propertyName, Object value) {
            this.delegatingProperties.setObject(this.root + '.' + propertyName, value);
        }

        public Object[] getArray(String propertyName, Object[] defaultValue) {
            return this.delegatingProperties.getArray(this.root + '.' + propertyName, defaultValue);
        }

        public void setArray(String propertyName, Object[] value) {
            this.delegatingProperties.setArray(this.root + '.' + propertyName, value);
        }

        public Collection getCollection(String propertyName, Collection defaultValue) {
            return this.delegatingProperties.getCollection(this.root + '.' + propertyName, defaultValue);
        }

        public void setCollection(String propertyName, Collection value) {
            this.delegatingProperties.setCollection(this.root + '.' + propertyName, value);
        }

        public Map getMap(String propertyName, Map defaultValue) {
            return this.delegatingProperties.getMap(this.root + '.' + propertyName, defaultValue);
        }

        public void setMap(String propertyName, Map value) {
            this.delegatingProperties.setMap(this.root + '.' + propertyName, value);
        }

        public Properties getProperties(String propertyName) {
            return new DelegatingProperties(this.delegatingProperties, this.root + '.' + propertyName);
        }
    }

    private static class PropertiesImpl
    extends Properties {
        private static final Object BAD_OBJECT = new Object();
        private static final String BAD_STRING = "";
        private static final Map BAD_MAP = new HashMap();
        private static final Collection BAD_COLLECTION = new ArrayList();
        private static final Object[] BAD_ARRAY = new Object[0];
        private HashMap register;
        private PrimitiveRegister impl = new PrimitiveRegister();
        private static ClassLoader classLoader;

        private PropertiesImpl() {
        }

        private void initReaders() {
            this.register = new HashMap();
            Iterator i = DebuggerManager.getDebuggerManager().lookup(null, class$org$netbeans$api$debugger$Properties$Reader == null ? (class$org$netbeans$api$debugger$Properties$Reader = Properties.class$("org.netbeans.api.debugger.Properties$Reader")) : class$org$netbeans$api$debugger$Properties$Reader).iterator();
            while (i.hasNext()) {
                Reader r = (Reader)i.next();
                String[] ns = r.getSupportedClassNames();
                int jj = ns.length;
                for (int j = 0; j < jj; ++j) {
                    this.register.put(ns[j], r);
                }
            }
        }

        private Reader findReader(String typeID) {
            Reader r;
            if (this.register == null) {
                this.initReaders();
            }
            if ((r = (Reader)this.register.get(typeID)) != null) {
                return r;
            }
            Class<?> c = null;
            try {
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            for (c = PropertiesImpl.getClassLoader().loadClass(typeID); c != null && this.register.get(c.getName()) == null; c = c.getSuperclass()) {
            }
            if (c != null) {
                r = (Reader)this.register.get(c.getName());
            }
            return r;
        }

        public String getString(String propertyName, String defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                return defaultValue;
            }
            if (!value.startsWith("\"")) {
                System.out.println("Can not read string " + value + ".");
                return defaultValue;
            }
            return value.substring(1, value.length() - 1);
        }

        public void setString(String propertyName, String value) {
            if (value != null) {
                this.impl.setProperty(propertyName, "\"" + value + "\"");
            } else {
                this.impl.setProperty(propertyName, value);
            }
        }

        public int getInt(String propertyName, int defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                return defaultValue;
            }
            int val = Integer.parseInt(value);
            return val;
        }

        public void setInt(String propertyName, int value) {
            this.impl.setProperty(propertyName, Integer.toString(value));
        }

        public char getChar(String propertyName, char defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                return defaultValue;
            }
            char val = value.charAt(0);
            return val;
        }

        public void setChar(String propertyName, char value) {
            this.impl.setProperty(propertyName, BAD_STRING + value);
        }

        public float getFloat(String propertyName, float defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                return defaultValue;
            }
            float val = Float.parseFloat(value);
            return val;
        }

        public void setFloat(String propertyName, float value) {
            this.impl.setProperty(propertyName, Float.toString(value));
        }

        public long getLong(String propertyName, long defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                return defaultValue;
            }
            long val = Long.parseLong(value);
            return val;
        }

        public void setLong(String propertyName, long value) {
            this.impl.setProperty(propertyName, Long.toString(value));
        }

        public double getDouble(String propertyName, double defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                return defaultValue;
            }
            double val = Double.parseDouble(value);
            return val;
        }

        public void setDouble(String propertyName, double value) {
            this.impl.setProperty(propertyName, Double.toString(value));
        }

        public boolean getBoolean(String propertyName, boolean defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                return defaultValue;
            }
            boolean val = value.equals("true");
            return val;
        }

        public void setBoolean(String propertyName, boolean value) {
            this.impl.setProperty(propertyName, value ? "true" : "false");
        }

        public byte getByte(String propertyName, byte defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                return defaultValue;
            }
            byte val = Byte.parseByte(value);
            return val;
        }

        public void setByte(String propertyName, byte value) {
            this.impl.setProperty(propertyName, Byte.toString(value));
        }

        public short getShort(String propertyName, short defaultValue) {
            String value = this.impl.getProperty(propertyName, null);
            if (value == null) {
                return defaultValue;
            }
            short val = Short.parseShort(value);
            return val;
        }

        public void setShort(String propertyName, short value) {
            this.impl.setProperty(propertyName, Short.toString(value));
        }

        public Object getObject(String propertyName, Object defaultValue) {
            Reader r;
            String typeID = this.impl.getProperty(propertyName, null);
            if (typeID == null) {
                return defaultValue;
            }
            if (typeID.equals("# null")) {
                return null;
            }
            if (typeID == null) {
                return defaultValue;
            }
            if (!typeID.startsWith("# ")) {
                if (typeID.startsWith("\"")) {
                    String s = this.getString(propertyName, BAD_STRING);
                    if (s == BAD_STRING) {
                        return defaultValue;
                    }
                    return s;
                }
                System.out.println("Can not read object " + typeID + ". No reader registered for type " + typeID + ".");
                return defaultValue;
            }
            typeID = typeID.substring(2);
            Class<?> c = null;
            try {
                c = Class.forName(typeID);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (c != null) {
                if ((class$java$util$Map == null ? (class$java$util$Map = Properties.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(c)) {
                    Map m = this.getMap(propertyName, BAD_MAP);
                    if (m == BAD_MAP) {
                        return defaultValue;
                    }
                    return m;
                }
                if ((array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = Properties.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object).isAssignableFrom(c)) {
                    Object[] os = this.getArray(propertyName, BAD_ARRAY);
                    if (os == BAD_ARRAY) {
                        return defaultValue;
                    }
                    return os;
                }
                if ((class$java$util$Collection == null ? (class$java$util$Collection = Properties.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(c)) {
                    Collection co = this.getCollection(propertyName, BAD_COLLECTION);
                    if (co == BAD_COLLECTION) {
                        return defaultValue;
                    }
                    return co;
                }
            }
            if ((r = this.findReader(typeID)) == null) {
                System.out.println("Can not read object. No reader registered for type " + typeID + ".");
                return defaultValue;
            }
            return r.read(typeID, this.getProperties(propertyName));
        }

        public void setObject(String propertyName, Object value) {
            if (value == null) {
                this.impl.setProperty(propertyName, "# null");
                return;
            }
            if (value instanceof String) {
                this.setString(propertyName, (String)value);
                return;
            }
            if (value instanceof Map) {
                this.setMap(propertyName, (Map)value);
                return;
            }
            if (value instanceof Collection) {
                this.setCollection(propertyName, (Collection)value);
                return;
            }
            if (value instanceof Object[]) {
                this.setArray(propertyName, (Object[])value);
                return;
            }
            Reader r = this.findReader(value.getClass().getName());
            if (r == null) {
                System.out.println("Can not write object " + value);
                return;
            }
            r.write(value, this.getProperties(propertyName));
            this.impl.setProperty(propertyName, "# " + value.getClass().getName());
        }

        public Object[] getArray(String propertyName, Object[] defaultValue) {
            String typeID = this.impl.getProperty(propertyName, null);
            String arrayType = this.impl.getProperty(propertyName + ".array_type", null);
            Properties p = this.getProperties(propertyName);
            int l = p.getInt("length", -1);
            if (l < 0) {
                return defaultValue;
            }
            Object[] os = null;
            try {
                os = (Object[])Array.newInstance(PropertiesImpl.getClassLoader().loadClass(arrayType), l);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                os = new Object[l];
            }
            for (int i = 0; i < l; ++i) {
                Object o = p.getObject(BAD_STRING + i, BAD_OBJECT);
                if (o == BAD_OBJECT) {
                    return defaultValue;
                }
                os[i] = o;
            }
            return os;
        }

        public void setArray(String propertyName, Object[] value) {
            this.impl.setProperty(propertyName, "# array");
            this.impl.setProperty(propertyName + ".array_type", value.getClass().getComponentType().getName());
            if (value == null) {
                return;
            }
            Properties p = this.getProperties(propertyName);
            int k = value.length;
            p.setInt("length", k);
            for (int i = 0; i < k; ++i) {
                p.setObject(BAD_STRING + i, value[i]);
            }
        }

        public Collection getCollection(String propertyName, Collection defaultValue) {
            String typeID = this.impl.getProperty(propertyName, null);
            if (typeID == null) {
                return defaultValue;
            }
            if (!typeID.startsWith("# ")) {
                return defaultValue;
            }
            Collection c = null;
            try {
                c = (Collection)Class.forName(typeID.substring(2)).newInstance();
            }
            catch (ClassNotFoundException ex) {
                return defaultValue;
            }
            catch (InstantiationException ex) {
                return defaultValue;
            }
            catch (IllegalAccessException ex) {
                return defaultValue;
            }
            Properties p = this.getProperties(propertyName);
            int k = p.getInt("length", 0);
            for (int i = 0; i < k; ++i) {
                Object o = p.getObject(BAD_STRING + i, BAD_OBJECT);
                if (o == BAD_OBJECT) {
                    return defaultValue;
                }
                c.add(o);
            }
            return c;
        }

        public void setCollection(String propertyName, Collection value) {
            if (value == null) {
                return;
            }
            this.impl.setProperty(propertyName, "# " + value.getClass().getName());
            if (value == null) {
                return;
            }
            Properties p = this.getProperties(propertyName);
            Iterator it = value.iterator();
            int i = 0;
            p.setInt("length", value.size());
            while (it.hasNext()) {
                p.setObject(BAD_STRING + i, it.next());
                ++i;
            }
        }

        public Map getMap(String propertyName, Map defaultValue) {
            String typeID = this.impl.getProperty(propertyName, null);
            if (typeID == null) {
                return defaultValue;
            }
            if (!typeID.startsWith("# ")) {
                return defaultValue;
            }
            Map m = null;
            try {
                m = (Map)Class.forName(typeID.substring(2)).newInstance();
            }
            catch (ClassNotFoundException ex) {
                return defaultValue;
            }
            catch (InstantiationException ex) {
                return defaultValue;
            }
            catch (IllegalAccessException ex) {
                return defaultValue;
            }
            Properties p = this.getProperties(propertyName);
            int k = p.getInt("length", 0);
            for (int i = 0; i < k; ++i) {
                Object key = p.getObject(BAD_STRING + i + "-key", BAD_OBJECT);
                if (key == BAD_OBJECT) {
                    return defaultValue;
                }
                Object value = p.getObject(BAD_STRING + i + "-value", BAD_OBJECT);
                if (value == BAD_OBJECT) {
                    return defaultValue;
                }
                m.put(key, value);
            }
            return m;
        }

        public void setMap(String propertyName, Map value) {
            if (value == null) {
                return;
            }
            this.impl.setProperty(propertyName, "# " + value.getClass().getName());
            if (value == null) {
                return;
            }
            Properties p = this.getProperties(propertyName);
            Iterator it = value.keySet().iterator();
            int i = 0;
            p.setInt("length", value.size());
            while (it.hasNext()) {
                Object o = it.next();
                p.setObject(BAD_STRING + i + "-key", o);
                p.setObject(BAD_STRING + i + "-value", value.get(o));
                ++i;
            }
        }

        public Properties getProperties(String propertyName) {
            return new DelegatingProperties(this, propertyName);
        }

        private static ClassLoader getClassLoader() {
            if (classLoader == null) {
                classLoader = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Properties.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            }
            return classLoader;
        }
    }

    private static class PrimitiveRegister {
        private HashMap properties = new HashMap();
        private boolean isInitialized = false;
        private RequestProcessor.Task task;

        private PrimitiveRegister() {
        }

        protected String getProperty(String propertyName, String defaultValue) {
            if (!this.isInitialized) {
                this.load();
            }
            this.isInitialized = true;
            String value = (String)this.properties.get(propertyName);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        protected void setProperty(String propertyName, String value) {
            if (!this.isInitialized) {
                this.load();
            }
            this.properties.put(propertyName, value);
            this.save();
        }

        private void load() {
            BufferedReader br = null;
            try {
                FileObject fo;
                FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                FileObject r = fs.findResource("Services");
                if (r == null) {
                    r = fs.getRoot();
                }
                if ((fo = r.getFileObject("org-netbeans-modules-debugger-Settings", "properties")) == null) {
                    fo = r.createData("org-netbeans-modules-debugger-Settings", "properties");
                }
                InputStream is = fo.getInputStream();
                br = new BufferedReader(new InputStreamReader(is));
                String l = br.readLine();
                while (l != null) {
                    int i = l.indexOf(58);
                    if (i > 0) {
                        this.properties.put(l.substring(0, i), l.substring(i + 1));
                    }
                    l = br.readLine();
                }
                br.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        private synchronized void save() {
            if (this.task == null) {
                this.task = new RequestProcessor("Debugger Properties Save RP", 1).create(new Runnable(){

                    public void run() {
                        PrimitiveRegister.this.saveIn();
                    }
                });
            }
            this.task.schedule(4000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveIn() {
            PrintWriter pw = null;
            FileLock lock = null;
            try {
                FileObject r = Repository.getDefault().getDefaultFileSystem().findResource("Services");
                FileObject fo = r.getFileObject("org-netbeans-modules-debugger-Settings", "properties");
                if (fo == null) {
                    fo = r.createData("org-netbeans-modules-debugger-Settings", "properties");
                }
                lock = fo.lock();
                OutputStream os = fo.getOutputStream(lock);
                pw = new PrintWriter(os);
                Set s = this.properties.keySet();
                ArrayList l = new ArrayList(s);
                Collections.sort(l);
                int k = l.size();
                for (int i = 0; i < k; ++i) {
                    String key = (String)l.get(i);
                    Object value = this.properties.get(key);
                    if (value == null) continue;
                    pw.println("" + key + ":" + value);
                }
                pw.flush();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)ex, "Can not save debugger settings."));
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    public static interface Reader {
        public String[] getSupportedClassNames();

        public Object read(String var1, Properties var2);

        public void write(Object var1, Properties var2);
    }
}

