/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.web.api.webmodule.WebFrameworkSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.LibrariesNode;
import org.netbeans.modules.web.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.client.WebServicesClientView;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.api.webservices.WebServicesView;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSView;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class WebViews {
    private WebViews() {
    }

    private static Lookup createLookup(Project project) {
        DataFolder rootFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, rootFolder});
    }

    private static class ConfFilesRefreshAction
    extends CookieAction {
        private ConfFilesRefreshAction() {
        }

        protected Class[] cookieClasses() {
            return new Class[]{RefreshCookie.class};
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        protected int mode() {
            return 8;
        }

        protected boolean asynchronous() {
            return false;
        }

        public String getName() {
            return NbBundle.getMessage(WebViews.class, (String)"LBL_Refresh");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void performAction(Node[] selectedNodes) {
            for (int i = 0; i < selectedNodes.length; ++i) {
                RefreshCookie cookie = (RefreshCookie)selectedNodes[i].getCookie(RefreshCookie.class);
                cookie.refresh();
            }
        }

        private static interface RefreshCookie
        extends Node.Cookie {
            public void refresh();
        }
    }

    private static final class ConfFilesChildren
    extends Children.Keys {
        private static final String[] wellKnownFiles = new String[]{"web.xml", "webservices.xml", "struts-config.xml", "faces-config.xml", "navigator.xml", "managed-beans.xml"};
        private ProjectWebModule pwm;
        private FileObject projectDir;
        private HashSet keys;
        private Comparator comparator = new NodeComparator();
        private FileChangeListener webInfListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fe) {
                if (ConfFilesChildren.this.isWellKnownFile(fe.getFile().getNameExt())) {
                    ConfFilesChildren.this.addKey(fe.getFile());
                }
            }

            public void fileRenamed(FileRenameEvent fe) {
                if (ConfFilesChildren.this.keys.contains(fe.getFile())) {
                    if (!ConfFilesChildren.this.isWellKnownFile(fe.getFile().getNameExt())) {
                        ConfFilesChildren.this.removeKey(fe.getFile());
                    } else {
                        ConfFilesChildren.this.doSetKeys();
                    }
                } else if (ConfFilesChildren.this.isWellKnownFile(fe.getFile().getNameExt())) {
                    ConfFilesChildren.this.addKey(fe.getFile());
                }
            }

            public void fileDeleted(FileEvent fe) {
                if (ConfFilesChildren.this.isWellKnownFile(fe.getFile().getNameExt())) {
                    ConfFilesChildren.this.removeKey(fe.getFile());
                }
            }
        };
        private FileChangeListener anyFileListener = new FileChangeAdapter(){

            public void fileDataCreated(FileEvent fe) {
                ConfFilesChildren.this.addKey(fe.getFile());
            }

            public void fileFolderCreated(FileEvent fe) {
                ConfFilesChildren.this.addKey(fe.getFile());
            }

            public void fileRenamed(FileRenameEvent fe) {
                ConfFilesChildren.this.addKey(fe.getFile());
            }

            public void fileDeleted(FileEvent fe) {
                ConfFilesChildren.this.removeKey(fe.getFile());
            }
        };
        private ConfigurationFilesListener serverSpecificFilesListener = new ConfigurationFilesListener(){

            public void fileCreated(FileObject fo) {
                ConfFilesChildren.this.addKey(fo);
            }

            public void fileDeleted(FileObject fo) {
                ConfFilesChildren.this.removeKey(fo);
            }
        };

        private ConfFilesChildren(ProjectWebModule pwm, FileObject projectDir) {
            this.pwm = pwm;
            this.projectDir = projectDir;
            this.keys = new HashSet();
        }

        public static Children forProject(Project project) {
            ProjectWebModule pwm = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class);
            return new ConfFilesChildren(pwm, project.getProjectDirectory());
        }

        protected void addNotify() {
            this.createKeys();
            this.doSetKeys();
        }

        protected void removeNotify() {
            this.removeListeners();
        }

        public Node[] createNodes(Object key) {
            Node[] nodeArray;
            Node n = null;
            if (this.keys.contains(key)) {
                FileObject fo = (FileObject)key;
                try {
                    DataObject dataObject = DataObject.find((FileObject)fo);
                    n = dataObject.getNodeDelegate().cloneNode();
                }
                catch (DataObjectNotFoundException dnfe) {
                    // empty catch block
                }
            }
            if (n == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = n;
            }
            return nodeArray;
        }

        public synchronized void refreshNodes() {
            this.addNotify();
        }

        private synchronized void addKey(FileObject key) {
            if (VisibilityQuery.getDefault().isVisible(key)) {
                this.keys.add(key);
                this.doSetKeys();
            }
        }

        private synchronized void removeKey(FileObject key) {
            this.keys.remove(key);
            this.doSetKeys();
        }

        private synchronized void createKeys() {
            this.keys.clear();
            this.addWellKnownFiles();
            this.addConfDirectoryFiles();
            this.addServerSpecificFiles();
            this.addFrameworkFiles();
        }

        private void doSetKeys() {
            Object[] result = this.keys.toArray();
            Arrays.sort(result, this.comparator);
            this.setKeys(result);
        }

        private void addWellKnownFiles() {
            FileObject webInf = this.pwm.getWebInf(true);
            if (webInf == null) {
                return;
            }
            for (int i = 0; i < wellKnownFiles.length; ++i) {
                FileObject fo = webInf.getFileObject(wellKnownFiles[i]);
                if (fo == null) continue;
                this.keys.add(fo);
            }
            webInf.addFileChangeListener(this.webInfListener);
        }

        private void addConfDirectoryFiles() {
            FileObject conf = this.pwm.getConfDir();
            if (conf == null) {
                return;
            }
            FileObject[] children = conf.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (!VisibilityQuery.getDefault().isVisible(children[i])) continue;
                this.keys.add(children[i]);
            }
            conf.addFileChangeListener(this.anyFileListener);
        }

        private void addServerSpecificFiles() {
            FileObject[] files = this.pwm.getConfigurationFiles();
            for (int i = 0; i < files.length; ++i) {
                this.keys.add(files[i]);
            }
            this.pwm.addConfigurationFilesListener(this.serverSpecificFilesListener);
        }

        private void addFrameworkFiles() {
            List providers = WebFrameworkSupport.getFrameworkProviders();
            for (int i = 0; i < providers.size(); ++i) {
                WebFrameworkProvider provider = (WebFrameworkProvider)providers.get(i);
                FileObject wmBase = this.pwm.getDocumentBase();
                File[] files = null;
                if (wmBase != null) {
                    files = provider.getConfigurationFiles(WebModule.getWebModule((FileObject)wmBase));
                }
                if (files == null) continue;
                for (int j = 0; j < files.length; ++j) {
                    FileObject fo = FileUtil.toFileObject((File)files[j]);
                    if (fo == null) continue;
                    this.keys.add(fo);
                }
            }
        }

        private void removeListeners() {
            FileObject conf;
            this.pwm.removeConfigurationFilesListener(this.serverSpecificFilesListener);
            FileObject webInf = this.pwm.getWebInf(true);
            if (webInf != null) {
                this.pwm.getWebInf().removeFileChangeListener(this.webInfListener);
            }
            if ((conf = this.pwm.getConfDir()) != null) {
                conf.removeFileChangeListener(this.anyFileListener);
            }
        }

        private boolean isWellKnownFile(String name) {
            for (int i = 0; i < wellKnownFiles.length; ++i) {
                if (!name.equals(wellKnownFiles[i])) continue;
                return true;
            }
            return false;
        }

        private void dumpKeys() {
            for (FileObject fileObject : this.keys) {
            }
        }

        private static final class NodeComparator
        implements Comparator {
            private NodeComparator() {
            }

            public int compare(Object o1, Object o2) {
                FileObject fo1 = (FileObject)o1;
                FileObject fo2 = (FileObject)o2;
                int result = this.compareType(fo1, fo2);
                if (result == 0) {
                    result = this.compareNames(fo1, fo2);
                }
                if (result == 0) {
                    return fo1.getPath().compareTo(fo2.getPath());
                }
                return result;
            }

            private int compareType(FileObject fo1, FileObject fo2) {
                int folder1 = fo1.isFolder() ? 0 : 1;
                int folder2 = fo2.isFolder() ? 0 : 1;
                return folder1 - folder2;
            }

            private int compareNames(FileObject do1, FileObject do2) {
                return do1.getNameExt().compareTo(do2.getNameExt());
            }

            public boolean equals(Object o) {
                return o instanceof NodeComparator;
            }
        }
    }

    private static final class ConfFilesNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private static final Image CONFIGURATION_FILES_BADGE = Utilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/config-badge.gif", (boolean)true);
        private Node projectNode;
        private Set files;
        private Map fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock = new Object();
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map groupsListeners;
        private Project project;

        public ConfFilesNode(Project prj) {
            super(ConfFilesChildren.forProject(prj), WebViews.createLookup(prj));
            this.project = prj;
            this.setName("configurationFiles");
            FileObject projectDir = prj.getProjectDirectory();
            try {
                DataObject projectDo = DataObject.find((FileObject)projectDir);
                if (projectDo != null) {
                    this.projectNode = projectDo.getNodeDelegate();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }

        public Image getIcon(int type) {
            Image img = this.computeIcon(false, type);
            return img != null ? img : super.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            Image img = this.computeIcon(true, type);
            return img != null ? img : super.getIcon(type);
        }

        private Image computeIcon(boolean opened, int type) {
            if (this.projectNode == null) {
                return null;
            }
            Image image = opened ? this.projectNode.getOpenedIcon(type) : this.projectNode.getIcon(type);
            image = Utilities.mergeImages((Image)image, (Image)CONFIGURATION_FILES_BADGE, (int)7, (int)7);
            return image;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(WebViews.class, (String)"LBL_Node_Config");
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(FindAction.class)};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean fireName;
            boolean fireIcon;
            Object object = this.privateLock;
            synchronized (object) {
                fireIcon = this.iconChange;
                fireName = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (fireIcon) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (fireName) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent event) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                    for (FileObject fo : this.files) {
                        if (!event.hasChanged(fo)) continue;
                        this.iconChange |= event.isIconChange();
                        this.nameChange |= event.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        public void stateChanged(ChangeEvent e) {
            this.setProjectFiles(this.project);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.setProjectFiles(this.project);
        }

        protected final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private final void setGroups(Collection groups) {
            if (this.groupsListeners != null) {
                for (SourceGroup group : this.groupsListeners.keySet()) {
                    PropertyChangeListener pcl = (PropertyChangeListener)this.groupsListeners.get(group);
                    group.removePropertyChangeListener(pcl);
                }
            }
            this.groupsListeners = new HashMap();
            HashSet<FileObject> roots = new HashSet<FileObject>();
            for (SourceGroup group : groups) {
                PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group);
                this.groupsListeners.put(group, pcl);
                group.addPropertyChangeListener(pcl);
                FileObject fo = group.getRootFolder();
                roots.add(fo);
            }
            this.setFiles(roots);
        }

        protected final void setFiles(Set files) {
            if (this.fileSystemListeners != null) {
                for (FileSystem fs : this.fileSystemListeners.keySet()) {
                    FileStatusListener fsl = (FileStatusListener)this.fileSystemListeners.get(fs);
                    fs.removeFileStatusListener(fsl);
                }
            }
            this.fileSystemListeners = new HashMap();
            this.files = files;
            if (files == null) {
                return;
            }
            Iterator<Object> it = files.iterator();
            HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (hookedFileSystems.contains(fs)) continue;
                    hookedFileSystems.add(fs);
                    FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                    fs.addFileStatusListener(fsl);
                    this.fileSystemListeners.put(fs, fsl);
                }
                catch (FileStateInvalidException e) {
                    ErrorManager err = ErrorManager.getDefault();
                    err.annotate((Throwable)e, "Can not get " + fo + " filesystem, ignoring...");
                    err.notify(1, (Throwable)e);
                }
            }
        }
    }

    private static final class DocBaseNode
    extends FilterNode {
        private Image icon;
        private Action[] actions;
        private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
        private static Image WEB_PAGES_BADGE = Utilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/webPagesBadge.gif");
        private Project project;

        DocBaseNode(DataFolder folder, Project project) {
            super(folder.getNodeDelegate(), folder.createNodeChildren(VISIBILITY_QUERY_FILTER));
            this.project = project;
        }

        public Image getIcon(int type) {
            return this.computeIcon(false, type);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(true, type);
        }

        private Node getDataFolderNodeDelegate() {
            return ((DataFolder)this.getLookup().lookup(DataFolder.class)).getNodeDelegate();
        }

        private Image computeIcon(boolean opened, int type) {
            Image image = opened ? this.getDataFolderNodeDelegate().getOpenedIcon(type) : this.getDataFolderNodeDelegate().getIcon(type);
            image = Utilities.mergeImages((Image)image, (Image)WEB_PAGES_BADGE, (int)7, (int)7);
            return image;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(WebViews.class, (String)"LBL_Node_DocBase");
        }

        public Action[] getActions(boolean context) {
            if (this.actions == null) {
                this.actions = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, new PreselectPropertiesAction(this.project, "Sources")};
            }
            return this.actions;
        }
    }

    static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fo);
        }

        public void stateChanged(ChangeEvent e) {
            Object[] listeners = this.ell.getListenerList();
            ChangeEvent event = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(event);
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.ell.add(ChangeListener.class, listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.ell.remove(ChangeListener.class, listener);
        }
    }

    private static class PreselectPropertiesAction
    extends AbstractAction {
        private Project project;
        private String nodeName;
        private String panelName;

        public PreselectPropertiesAction(Project project, String nodeName) {
            this(project, nodeName, null);
        }

        public PreselectPropertiesAction(Project project, String nodeName, String panelName) {
            super(NbBundle.getMessage(WebViews.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = nodeName;
            this.panelName = panelName;
        }

        public void actionPerformed(ActionEvent e) {
            CustomizerProviderImpl cp = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            if (cp != null) {
                cp.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        private String nodeName;
        private Project project;
        private Action[] actions;

        public PackageViewFilterNode(SourceGroup sourceGroup, Project project) {
            super(PackageView.createPackageView((SourceGroup)sourceGroup));
            this.project = project;
            this.nodeName = "Sources";
        }

        public Action[] getActions(boolean context) {
            if (!context) {
                if (this.actions == null) {
                    Action[] superActions = super.getActions(context);
                    this.actions = new Action[superActions.length + 2];
                    System.arraycopy(superActions, 0, this.actions, 0, superActions.length);
                    this.actions[superActions.length] = null;
                    this.actions[superActions.length + 1] = new PreselectPropertiesAction(this.project, this.nodeName);
                }
                return this.actions;
            }
            return super.getActions(context);
        }
    }

    static final class LogicalViewChildren
    extends Children.Keys
    implements ChangeListener {
        private static final String KEY_SOURCE_DIR = "srcDir";
        private static final String KEY_TEST_DIR = "testDir";
        private static final String KEY_DOC_BASE = "docBase";
        private static final String KEY_SERVICE_REFS = "serviceRefs";
        private static final String WEBSERVICES_DIR = "webservicesDir";
        private static final String KEY_SETUP_DIR = "setupDir";
        private static final String KEY_CONF_FILES = "confFiles";
        private static final String KEY_LIBRARIES = "libraries";
        private static final String KEY_TEST_LIBRARIES = "testLibraries";
        private static final String JAX_WS_PATH = "nbproject/jax-ws.xml";
        private final AntProjectHelper helper;
        private final PropertyEvaluator evaluator;
        private final UpdateHelper updateHelper;
        private final ReferenceHelper refHelper;
        private final Project project;
        private WebInfListener webInfListener;
        private WsdlCreationListener wsdlListener;
        private final FileObject projectDir;
        private FileChangeListener fcl;
        private JaxWsChangeListener jaxWsListener;
        private JaxRPCChangeListener jaxrpcChangeListener;
        private FileObject wsdlFolder;

        public LogicalViewChildren(Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper) {
            assert (project != null);
            this.project = project;
            assert (updateHelper != null);
            this.updateHelper = updateHelper;
            this.helper = updateHelper.getAntProjectHelper();
            assert (evaluator != null);
            this.evaluator = evaluator;
            assert (refHelper != null);
            this.refHelper = refHelper;
            this.webInfListener = new WebInfListener();
            this.wsdlListener = new WsdlCreationListener();
            this.jaxWsListener = new JaxWsChangeListener();
            this.jaxrpcChangeListener = new JaxRPCChangeListener();
            this.projectDir = this.helper.getProjectDirectory();
        }

        protected void addNotify() {
            FileObject webInf;
            WebModule wm;
            Sources sources;
            super.addNotify();
            this.fcl = new ProjectDirectoryListener();
            this.projectDir.addFileChangeListener(this.fcl);
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                jaxWsModel.addPropertyChangeListener((PropertyChangeListener)this.jaxWsListener);
            }
            if ((sources = this.getSources()) != null) {
                sources.addChangeListener((ChangeListener)this);
            }
            if ((wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory())) != null && (webInf = wm.getWebInf()) != null) {
                webInf.addFileChangeListener((FileChangeListener)this.webInfListener);
                webInf.addFileChangeListener((FileChangeListener)this.jaxrpcChangeListener);
            }
            WebServicesClientSupport wsClientSupportImpl = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.projectDir);
            FileObject wsdlDir = null;
            try {
                wsdlDir = wsClientSupportImpl.getWsdlFolder(false);
                if (wsdlDir != null) {
                    this.wsdlFolder = wsdlDir;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (this.wsdlFolder != null) {
                this.wsdlFolder.addFileChangeListener((FileChangeListener)this.wsdlListener);
            }
            this.buildKeys();
        }

        private void buildKeys() {
            ArrayList<String> l = new ArrayList<String>();
            DataFolder docBaseDir = this.getFolder("web.docbase.dir");
            if (docBaseDir != null) {
                l.add(KEY_DOC_BASE);
            }
            JAXWSSupport jwss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            if (jwss != null && jaxWsModel != null && jaxWsModel.getServices() != null && jaxWsModel.getServices().length > 0) {
                l.add(WEBSERVICES_DIR);
            } else {
                List wServices;
                WebServicesSupport wss = WebServicesSupport.getWebServicesSupport((FileObject)this.project.getProjectDirectory());
                if (wss != null && (wServices = wss.getServices()) != null && !wServices.isEmpty()) {
                    l.add(WEBSERVICES_DIR);
                }
            }
            JAXWSClientSupport jwcss = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.project.getProjectDirectory());
            if (jwcss != null && jaxWsModel != null && jaxWsModel.getClients() != null && jaxWsModel.getClients().length > 0) {
                l.add(KEY_SERVICE_REFS);
            } else {
                List wsClients;
                WebServicesClientSupport wscs = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.project.getProjectDirectory());
                if (wscs != null && (wsClients = wscs.getServiceClients()) != null && !wsClients.isEmpty()) {
                    l.add(KEY_SERVICE_REFS);
                }
            }
            l.add(KEY_CONF_FILES);
            l.add(KEY_SETUP_DIR);
            l.addAll(this.getKeys());
            l.add(KEY_LIBRARIES);
            l.add(KEY_TEST_LIBRARIES);
            this.setKeys(l);
        }

        protected void removeNotify() {
            Sources sources;
            FileObject webInf;
            WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            if (wm != null && (webInf = wm.getWebInf()) != null) {
                webInf.removeFileChangeListener((FileChangeListener)this.webInfListener);
                webInf.removeFileChangeListener((FileChangeListener)this.jaxrpcChangeListener);
            }
            if (this.wsdlFolder != null) {
                this.wsdlFolder.removeFileChangeListener((FileChangeListener)this.wsdlListener);
            }
            this.setKeys(Collections.EMPTY_SET);
            this.projectDir.removeFileChangeListener(this.fcl);
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                jaxWsModel.removePropertyChangeListener((PropertyChangeListener)this.jaxWsListener);
            }
            if ((sources = this.getSources()) != null) {
                sources.removeChangeListener((ChangeListener)this);
            }
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            Node[] nodeArray;
            Object n = null;
            if (key instanceof SourceGroupKey) {
                n = new PackageViewFilterNode(((SourceGroupKey)key).group, this.project);
            } else if (key == KEY_CONF_FILES) {
                n = new ConfFilesNode(this.project);
            } else if (key == KEY_DOC_BASE) {
                n = new DocBaseNode(this.getFolder("web.docbase.dir"), this.project);
            } else if (key == WEBSERVICES_DIR) {
                if (this.project instanceof WebProject) {
                    boolean jsr109OldSupported;
                    WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
                    Map properties = ((WebProject)this.project).getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                    String serverInstance = (String)properties.get("j2ee.server.instance");
                    J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
                    boolean jwsdpSupported = j2eePlatform != null && j2eePlatform.isToolSupported("jwsdp");
                    boolean wsitSupported = j2eePlatform != null && j2eePlatform.isToolSupported("wsit");
                    boolean jsr109Supported = j2eePlatform != null && j2eePlatform.isToolSupported("jsr109");
                    boolean bl = jsr109OldSupported = j2eePlatform != null && j2eePlatform.isToolSupported("wscompile");
                    if (wm != null && ("1.5".equals(wm.getJ2eePlatformVersion()) || jwsdpSupported || wsitSupported || !jsr109Supported && !jsr109OldSupported)) {
                        JAXWSView view = JAXWSView.getJAXWSView();
                        n = view.createJAXWSView(this.project);
                    } else {
                        WebServicesView webServicesView;
                        WebProject webProject = (WebProject)this.project;
                        FileObject[] srcs = webProject.getSourceRoots().getRoots();
                        if (srcs != null && srcs.length > 0 && (webServicesView = WebServicesView.getWebServicesView((FileObject)srcs[0])) != null) {
                            n = webServicesView.createWebServicesView(srcs[0]);
                        }
                    }
                }
            } else if (key == KEY_LIBRARIES) {
                n = new LibrariesNode(NbBundle.getMessage(WebViews.class, (String)"CTL_LibrariesNode"), this.project, this.evaluator, this.updateHelper, this.refHelper, "javac.classpath", new String[]{"build.classes.dir"}, "platform.active", "j2ee.server.instance", new Action[]{LibrariesNode.createAddProjectAction(this.project, "javac.classpath", "web-module-libraries"), LibrariesNode.createAddLibraryAction(this.project, this.updateHelper.getAntProjectHelper(), "javac.classpath", "web-module-libraries"), LibrariesNode.createAddFolderAction(this.project, "javac.classpath", "web-module-libraries"), null, new PreselectPropertiesAction(this.project, "Libraries", "COMPILE")}, "web-module-libraries");
            } else if (key == KEY_TEST_LIBRARIES) {
                n = new LibrariesNode(NbBundle.getMessage(WebViews.class, (String)"CTL_TestLibrariesNode"), this.project, this.evaluator, this.updateHelper, this.refHelper, "javac.test.classpath", new String[]{"build.test.classes.dir", "javac.classpath", "build.classes.dir"}, null, null, new Action[]{LibrariesNode.createAddProjectAction(this.project, "javac.test.classpath", null), LibrariesNode.createAddLibraryAction(this.project, this.updateHelper.getAntProjectHelper(), "javac.test.classpath", null), LibrariesNode.createAddFolderAction(this.project, "javac.test.classpath", null), null, new PreselectPropertiesAction(this.project, "Libraries", "COMPILE_TESTS")}, null);
            } else if (key == KEY_SETUP_DIR) {
                n = J2eeProjectView.createServerResourcesNode((Project)this.project);
            } else if (key == KEY_SERVICE_REFS) {
                Map properties = ((WebProject)this.project).getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                String serverInstance = (String)properties.get("j2ee.server.instance");
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance);
                boolean jwsdpSupported = j2eePlatform != null && j2eePlatform.isToolSupported("jwsdp");
                boolean wsitSupported = j2eePlatform != null && j2eePlatform.isToolSupported("wsit");
                boolean jsr109Supported = j2eePlatform != null && j2eePlatform.isToolSupported("jsr109");
                boolean jsr109OldSupported = j2eePlatform != null && j2eePlatform.isToolSupported("wscompile");
                WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
                if (wm != null && ("1.5".equals(wm.getJ2eePlatformVersion()) || jwsdpSupported || wsitSupported || !jsr109Supported && !jsr109OldSupported)) {
                    JAXWSClientView view = JAXWSClientView.getJAXWSClientView();
                    n = view.createJAXWSClientView(this.project);
                } else {
                    WebServicesClientView clientView;
                    FileObject clientRoot = this.getFileObject("web.docbase.dir");
                    if (clientRoot == null) {
                        clientRoot = this.getFileObject("src.dir");
                    }
                    if (clientRoot != null && (clientView = WebServicesClientView.getWebServicesClientView((FileObject)clientRoot)) != null && this.wsdlFolder != null) {
                        FileObject[] children = this.wsdlFolder.getChildren();
                        boolean foundWsdl = false;
                        for (int i = 0; i < children.length; ++i) {
                            if (!children[i].getExt().equalsIgnoreCase("wsdl")) continue;
                            foundWsdl = true;
                            break;
                        }
                        if (foundWsdl) {
                            n = clientView.createWebServiceClientView(this.wsdlFolder);
                        }
                    }
                }
            }
            if (n == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = n;
            }
            return nodeArray;
        }

        private FileObject getFileObject(String propName) {
            String foName = this.evaluator.getProperty(propName);
            if (foName == null) {
                return null;
            }
            FileObject fo = this.helper.resolveFileObject(foName);
            return fo != null && fo.isValid() ? fo : null;
        }

        private DataFolder getFolder(String propName) {
            FileObject fo = this.getFileObject(propName);
            if (fo != null) {
                DataFolder df = DataFolder.findFolder((FileObject)fo);
                return df;
            }
            return null;
        }

        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LogicalViewChildren.this.buildKeys();
                }
            });
        }

        private Collection getKeys() {
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.EMPTY_LIST;
            }
            Sources sources = this.getSources();
            if (sources != null) {
                SourceGroup[] groups = sources.getSourceGroups("java");
                ArrayList<SourceGroupKey> result = new ArrayList<SourceGroupKey>(groups.length);
                for (int i = 0; i < groups.length; ++i) {
                    result.add(new SourceGroupKey(groups[i]));
                }
                return result;
            }
            return Collections.EMPTY_LIST;
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }

        private class ProjectDirectoryListener
        implements FileChangeListener {
            private ProjectDirectoryListener() {
            }

            public void fileAttributeChanged(FileAttributeEvent fe) {
            }

            public void fileChanged(FileEvent fe) {
            }

            public void fileDataCreated(FileEvent fe) {
            }

            public void fileDeleted(FileEvent fe) {
                if (this.isWatchedFile(this.getFileName(fe))) {
                    LogicalViewChildren.this.buildKeys();
                }
            }

            public void fileFolderCreated(FileEvent fe) {
                if (this.isWatchedFile(this.getFileName(fe))) {
                    LogicalViewChildren.this.buildKeys();
                }
            }

            public void fileRenamed(FileRenameEvent fe) {
                if (this.isWatchedFile(this.getFileName((FileEvent)fe)) || this.isWatchedFile(this.getOldFileName(fe))) {
                    LogicalViewChildren.this.buildKeys();
                }
            }

            private boolean isWatchedFile(String fileName) {
                String webDir = LogicalViewChildren.this.evaluator.getProperty("web.docbase.dir");
                return fileName.equals(webDir);
            }

            private String getFileName(FileEvent fe) {
                return fe.getFile().getNameExt();
            }

            private String getOldFileName(FileRenameEvent fe) {
                String result = fe.getName();
                if (fe.getExt() != "") {
                    result = result + "." + fe.getExt();
                }
                return result;
            }
        }

        private final class WebInfListener
        extends FileChangeAdapter {
            private WebInfListener() {
            }

            public void fileFolderCreated(FileEvent fe) {
                if (fe.getFile().isFolder() && "wsdl".equals(fe.getFile().getName())) {
                    fe.getFile().addFileChangeListener((FileChangeListener)LogicalViewChildren.this.wsdlListener);
                    LogicalViewChildren.this.wsdlFolder = fe.getFile();
                }
            }

            public void fileDeleted(FileEvent fe) {
                if (fe.getFile().isFolder() && "wsdl".equals(fe.getFile().getName())) {
                    fe.getFile().removeFileChangeListener((FileChangeListener)LogicalViewChildren.this.wsdlListener);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(LogicalViewChildren.KEY_SERVICE_REFS);
                        }
                    });
                }
            }
        }

        private final class JaxWsChangeListener
        implements PropertyChangeListener {
            private JaxWsChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LogicalViewChildren.this.buildKeys();
                    }
                });
            }
        }

        private final class JaxRPCChangeListener
        extends FileChangeAdapter {
            String webservicesFile = "webservices.xml";

            private JaxRPCChangeListener() {
            }

            public void fileDataCreated(FileEvent fe) {
                if (this.webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.buildKeys();
                        }
                    });
                }
            }

            public void fileDeleted(FileEvent fe) {
                if (this.webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.buildKeys();
                        }
                    });
                }
            }

            public void fileChanged(FileEvent fe) {
                if (this.webservicesFile.equalsIgnoreCase(fe.getFile().getNameExt())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.buildKeys();
                        }
                    });
                }
            }
        }

        private final class WsdlCreationListener
        extends FileChangeAdapter {
            private WsdlCreationListener() {
            }

            public void fileDataCreated(FileEvent fe) {
                if ("wsdl".equalsIgnoreCase(fe.getFile().getExt())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(LogicalViewChildren.KEY_SERVICE_REFS);
                        }
                    });
                }
            }

            public void fileDeleted(FileEvent fe) {
                if ("wsdl".equalsIgnoreCase(fe.getFile().getExt())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogicalViewChildren.this.refreshKey(LogicalViewChildren.KEY_SERVICE_REFS);
                        }
                    });
                }
            }
        }

        private static class SourceGroupKey {
            public final SourceGroup group;
            public final FileObject fileObject;

            SourceGroupKey(SourceGroup group) {
                this.group = group;
                this.fileObject = group.getRootFolder();
            }

            public int hashCode() {
                return this.fileObject.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof SourceGroupKey)) {
                    return false;
                }
                SourceGroupKey otherKey = (SourceGroupKey)obj;
                String thisDisplayName = this.group.getDisplayName();
                String otherDisplayName = otherKey.group.getDisplayName();
                return this.fileObject.equals(otherKey.fileObject) && thisDisplayName == null ? otherDisplayName == null : thisDisplayName.equals(otherDisplayName);
            }
        }
    }
}

