/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Set;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;

public final class FilterFileSystem
extends MultiFileSystem {
    private final FileObject root;
    private final FileSystem del;

    public FilterFileSystem(FileObject root) throws FileStateInvalidException {
        super(new FileSystem[]{root.getFileSystem()});
        this.root = root;
        this.del = root.getFileSystem();
        try {
            this.setSystemName(this.del.getSystemName() + " : " + root.getPath());
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.setPropagateMasks(true);
    }

    public final FileObject getRootFileObject() {
        return this.root;
    }

    protected FileObject findResourceOn(FileSystem fs, String res) {
        return fs.findResource(this.root.getPath() + "/" + res);
    }

    protected Set createLocksOn(String name) throws IOException {
        String nn = this.root.getPath() + "/" + name;
        LocalFileSystemEx.potentialLock((String)name, (String)nn);
        return super.createLocksOn(name);
    }
}

