/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.filesystems;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

abstract class DefaultParser
extends DefaultHandler {
    protected FileObject fo;
    private Locator locator = null;
    protected short state = 0;
    protected static final short PARSED = 1000;
    protected static final short ERROR = -1;
    protected static final short INIT = 0;

    protected DefaultParser() {
    }

    protected DefaultParser(FileObject fo) {
        this.fo = fo;
    }

    protected XMLReader createXMLReader() throws IOException, SAXException {
        return XMLUtil.createXMLReader((boolean)false);
    }

    protected boolean isStopException(Exception e) {
        return false;
    }

    protected short getState() {
        return this.state;
    }

    protected final Locator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(FileObject fo) {
        this.state = 0;
        InputStream is = null;
        this.fo = fo;
        try {
            XMLReader parser = this.createXMLReader();
            parser.setEntityResolver(this);
            parser.setErrorHandler(this);
            parser.setContentHandler(this);
            InputSource in = new InputSource();
            is = fo.getInputStream();
            in.setByteStream(is);
            in.setSystemId(fo.getURL().toExternalForm());
            this.customizeInputSource(in);
            parser.parse(in);
        }
        catch (IOException io) {
            if (!this.isStopException(io) && fo.isValid() && fo.canRead()) {
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.log("While parsing: " + fo.toString());
                emgr.notify(1, (Throwable)io);
                this.state = (short)-1;
            }
        }
        catch (SAXException sex) {
            if (!this.isStopException(sex)) {
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.annotate((Throwable)sex, 0, "While parsing: " + fo, null, null, null);
                emgr.notify(1, (Throwable)sex);
                this.state = (short)-1;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected void customizeInputSource(InputSource in) {
    }

    protected final void parse() {
        if (this.fo == null) {
            throw new NullPointerException();
        }
        this.parse(this.fo);
    }

    protected void error() throws SAXException {
        String reason = NbBundle.getMessage((Class)DefaultParser.class, (String)"Invalid_XML_document");
        this.error(reason);
    }

    protected void error(String reason) throws SAXException {
        StringBuffer buf = new StringBuffer(reason).append(": ").append(this.fo.toString());
        if (this.locator != null) {
            buf.append(" line: ").append(this.locator.getLineNumber());
            buf.append(" column: ").append(this.locator.getColumnNumber());
        }
        String msg = buf.toString();
        SAXException sex = new SAXException(msg);
        throw sex;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void endDocument() throws SAXException {
        this.state = (short)1000;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String publicID, String systemID) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }
}

