/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AnnotationTypeClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaEnumClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.parser.TokenIterator;
import org.netbeans.modules.javacore.scanning.ClassUpdater;
import org.netbeans.modules.javacore.scanning.FileInfo;
import org.netbeans.modules.javacore.scanning.FileScanner;
import org.netbeans.modules.javacore.scanning.IntSet;
import org.openide.ErrorManager;

public class JavaUpdater {
    private final JavaClassClassImpl jclsClass;
    private final JavaEnumClassImpl enumClass;
    private final AnnotationTypeClassImpl annTypeClass;
    private final ResourceClassImpl resourceClass;
    private final ClassIndex classIndex;
    private final String sourceLevel;
    private final FileScanner fileScanner;
    private static final int[] NULL_INTS = new int[0];

    public JavaUpdater(JavaModelPackage mofModel, String srcLevel, FileScanner fileScanner) {
        this.jclsClass = (JavaClassClassImpl)mofModel.getJavaClass();
        this.enumClass = (JavaEnumClassImpl)mofModel.getJavaEnum();
        this.resourceClass = (ResourceClassImpl)mofModel.getResource();
        this.annTypeClass = (AnnotationTypeClassImpl)mofModel.getAnnotationType();
        this.sourceLevel = srcLevel;
        this.classIndex = ClassIndex.getIndex(mofModel);
        this.fileScanner = fileScanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] computeIndex(ResourceImpl resource, TokenIterator tokens) {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
        try {
            int[] nArray = this.makeIndex(resource, tokens, false);
            return nArray;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans();
        }
    }

    private int[] makeIndex(ResourceImpl resource, TokenIterator tokens, boolean removeFeatures) {
        int[] idIndexes = NULL_INTS;
        boolean resInited = resource.isInitialized();
        HashSet<JavaClassImpl> reinitToDo = new HashSet<JavaClassImpl>();
        HashSet<JavaClassImpl> usedClasses = new HashSet<JavaClassImpl>();
        List javaClasses = resource.getPersistentClassifiers();
        Set remainingClasses = this.getAllClassesFromResource(resource, javaClasses);
        if (!resInited) {
            javaClasses.clear();
        }
        try {
            boolean persisted;
            boolean contentsInited;
            JavaClassImpl enclosingClass;
            int token;
            boolean S_NORMAL = false;
            boolean S_PACKAGE = true;
            int S_CLASS = 2;
            IntSet ids = new IntSet();
            boolean i = false;
            int last_token = 0;
            int state = 0;
            int modifiers = 0;
            String pack = "";
            Stack<JavaClassImpl> classes = new Stack<JavaClassImpl>();
            int br_level = 0;
            boolean packageSet = false;
            while ((token = tokens.getNextTokenType()) != 0) {
                String s;
                String text = null;
                if (token == 361) {
                    int hash = tokens.getIdentifierHash();
                    ids.add(hash);
                }
                if (tokens.isDeprecated()) {
                    modifiers |= Integer.MIN_VALUE;
                }
                switch (token) {
                    case 291: {
                        modifiers |= 1;
                        break;
                    }
                    case 290: {
                        modifiers |= 4;
                        break;
                    }
                    case 289: {
                        modifiers |= 2;
                        break;
                    }
                    case 257: {
                        modifiers |= 0x400;
                        break;
                    }
                    case 294: {
                        modifiers |= 8;
                        break;
                    }
                    case 274: {
                        modifiers |= 0x10;
                        break;
                    }
                    case 298: {
                        modifiers |= 0x20;
                        break;
                    }
                    case 286: {
                        modifiers |= 0x100;
                        break;
                    }
                    case 295: {
                        modifiers |= 0x800;
                        break;
                    }
                    case 302: {
                        modifiers |= 0x80;
                        break;
                    }
                    case 305: {
                        modifiers |= 0x40;
                        break;
                    }
                    case 313: {
                        modifiers = tokens.isDeprecated() ? Integer.MIN_VALUE : 0;
                        break;
                    }
                    case 309: {
                        ++br_level;
                        modifiers = tokens.isDeprecated() ? Integer.MIN_VALUE : 0;
                        break;
                    }
                    case 310: {
                        if (br_level == classes.size() && !classes.isEmpty()) {
                            classes.pop();
                        }
                        --br_level;
                    }
                }
                if (last_token == 316 && token == 361 && ((s = tokens.getIdentifierText()).equals("Deprecated") || s.equals("java.lang.Deprecated"))) {
                    modifiers |= Integer.MIN_VALUE;
                }
                switch (state) {
                    case 0: {
                        if (token == 288) {
                            state = 1;
                            break;
                        }
                        if (token != 265 && token != 284 && token != 272 || last_token == 315) break;
                        if (!packageSet) {
                            if (JMManager.INCONSISTENCY_DEBUG) {
                                System.err.println("JavaUpdater: Setting package name of resource " + resource.getName() + " to " + pack);
                            }
                            resource._setPackageName(pack);
                            packageSet = true;
                        }
                        if (last_token == 316 && token == 284) {
                            modifiers |= 0x2000;
                            ids.add("Annotation".hashCode());
                        }
                        state = 2;
                        break;
                    }
                    case 1: {
                        if (token == 361) {
                            text = tokens.getIdentifierText();
                        }
                        if (text != null) {
                            pack = pack.length() == 0 ? text : pack + '.' + text;
                        }
                        if (token != 313) break;
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (token == 361) {
                            text = tokens.getIdentifierText();
                        }
                        if (br_level == classes.size() && text != null) {
                            enclosingClass = null;
                            if (!classes.empty()) {
                                enclosingClass = (JavaClassImpl)((Object)classes.peek());
                            }
                            String fqn = this.constructFqn(pack, classes, text);
                            if (last_token == 284) {
                                modifiers |= 0x200;
                            } else if (last_token == 272) {
                                modifiers |= 0x4000;
                                ids.add("Enum".hashCode());
                            }
                            JavaClassImpl jcls = this.createJavaClass(fqn, modifiers, removeFeatures, text, remainingClasses, usedClasses, enclosingClass);
                            usedClasses.add(jcls);
                            classes.push(jcls);
                            remainingClasses.remove((Object)jcls);
                            if (jcls.refImmediateComposite() == null) {
                                if (enclosingClass != null) {
                                    contentsInited = enclosingClass.contentsInited();
                                    persisted = enclosingClass.isPersisted();
                                    if (persisted) {
                                        enclosingClass.getPersistentContents().add(jcls);
                                        if (contentsInited) {
                                            reinitToDo.add(enclosingClass);
                                        }
                                    } else {
                                        jcls.setParentClass(enclosingClass);
                                    }
                                } else {
                                    javaClasses.add(jcls);
                                }
                            }
                        }
                        state = 0;
                    }
                }
                last_token = token;
            }
            if (!packageSet) {
                if (JMManager.INCONSISTENCY_DEBUG) {
                    System.err.println("JavaUpdater: Setting package name of resource " + resource.getName() + " to " + pack);
                }
                resource._setPackageName(pack);
            }
            idIndexes = ids.toArray();
            Iterator it = remainingClasses.iterator();
            while (it.hasNext()) {
                JavaClassImpl cls = (JavaClassImpl)((Object)it.next());
                if (!cls.isValid()) continue;
                RefFeatured parent = cls.refImmediateComposite();
                if (parent == resource) {
                    javaClasses.remove((Object)cls);
                } else if (parent instanceof JavaClassImpl) {
                    enclosingClass = (JavaClassImpl)parent;
                    contentsInited = enclosingClass.contentsInited();
                    persisted = enclosingClass.isPersisted();
                    if (persisted) {
                        enclosingClass.getPersistentContents().remove((Object)cls);
                        if (contentsInited) {
                            reinitToDo.add(enclosingClass);
                        }
                    } else {
                        cls.setParentClass(null);
                    }
                }
                cls.refDelete();
            }
            if (resource.classifiersInited()) {
                resource.reinitClassifiers();
            }
            it = reinitToDo.iterator();
            while (it.hasNext()) {
                JavaClassImpl cls = (JavaClassImpl)((Object)it.next());
                if (!cls.isValid()) continue;
                cls.reinitContents();
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return idIndexes;
    }

    private JavaClassImpl createJavaClass(String fqn, int modifiers, boolean removeFeatures, String simpleName, Set remainingClasses, Set usedClasses, JavaClass enclosingClass) {
        Set classes = this.classIndex.getClassesByFqn(fqn);
        JavaClassImpl jcls = null;
        if (JMManager.INCONSISTENCY_DEBUG) {
            System.err.println("JavaUpdater: Looking for class: " + fqn);
        }
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            int declType;
            JavaClass temp = (JavaClass)it.next();
            if ((removeFeatures || enclosingClass == null || !enclosingClass.equals(temp.refImmediateComposite()) || usedClasses.contains(temp)) && !remainingClasses.contains(temp)) continue;
            if (JMManager.INCONSISTENCY_DEBUG) {
                System.err.println("JavaUpdater: Existing class found in index.");
            }
            int n = temp instanceof JavaEnum ? 1 : (declType = temp instanceof AnnotationType ? 2 : 0);
            if (declType == 1 && !JavaUpdater.isEnum(modifiers) || declType != 1 && JavaUpdater.isEnum(modifiers) || declType == 2 && !JavaUpdater.isAnnotation(modifiers) || declType != 2 && JavaUpdater.isAnnotation(modifiers)) {
                if (JMManager.INCONSISTENCY_DEBUG) {
                    System.err.println("JavaUpdater: The found class is of wrong type: " + temp.getClass().getName() + " -> deleting...");
                }
                remainingClasses.add(temp);
                break;
            }
            jcls = temp;
            break;
        }
        if (jcls == null) {
            if (JMManager.INCONSISTENCY_DEBUG) {
                System.err.println("JavaUpdater: No suitable class found -> creating...");
            }
            jcls = JavaUpdater.isEnum(modifiers) ? this.enumClass.create(fqn, modifiers, false) : (JavaUpdater.isAnnotation(modifiers) ? this.annTypeClass.create(fqn, modifiers, false) : this.jclsClass.create(fqn, modifiers, null, null, false));
        } else if (removeFeatures) {
            ClassUpdater.removePersisted(jcls);
        }
        return jcls;
    }

    private Set getAllClassesFromResource(Resource res, Collection topLevelClasses) {
        Iterator topIt = topLevelClasses.iterator();
        HashSet<JavaClass> allClasses = new HashSet<JavaClass>();
        while (topIt.hasNext()) {
            JavaClass topJcls = (JavaClass)topIt.next();
            Iterator innerListIt = this.classIndex.getClassesByFQNPrefix(topJcls.getName().concat(".")).iterator();
            allClasses.add(topJcls);
            while (innerListIt.hasNext()) {
                JavaClass innerJcls = (JavaClass)innerListIt.next();
                if (!res.equals(innerJcls.getResource())) continue;
                allClasses.add(innerJcls);
            }
        }
        return allClasses;
    }

    private static boolean isEnum(int modifiers) {
        return (modifiers & 0x4000) != 0;
    }

    private static boolean isAnnotation(int modifiers) {
        return (modifiers & 0x2000) != 0;
    }

    private String constructFqn(String pack, Stack names, String simpleName) {
        String name = names.isEmpty() ? (pack.length() > 0 ? pack + '.' : "") : ((JavaClass)names.peek()).getName() + '.';
        return name.concat(simpleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection updateResources(Map javaFiles) {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
        try {
            Iterator resIt = javaFiles.values().iterator();
            ArrayList<ResourceImpl> resList = new ArrayList<ResourceImpl>();
            long indexTimestamp = this.classIndex.getTimestamp();
            while (resIt.hasNext()) {
                FileInfo file = (FileInfo)resIt.next();
                try {
                    String name = file.getPath();
                    long timestamp = file.lastModified();
                    ResourceImpl resource = (ResourceImpl)this.resourceClass.resolveResource(name, true, false);
                    resList.add(resource);
                    if (resource.getTimestamp() == timestamp && !resource.isFromMemory() && indexTimestamp >= timestamp) continue;
                    resource.setTimestamp(timestamp, false);
                    if (this.fileScanner != null) {
                        this.fileScanner.checkParseEagerly(resource);
                    }
                    BufferedInputStream stream = new BufferedInputStream(file.getInputStream());
                    try {
                        int[] ids = this.makeIndex(resource, new TokenIterator(stream, this.sourceLevel, true), !resource.isInitialized());
                        this.classIndex.setIdentifiers(resource, ids);
                    }
                    finally {
                        ((InputStream)stream).close();
                    }
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            ArrayList<ResourceImpl> arrayList = resList;
            return arrayList;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans();
        }
    }
}

