/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import org.netbeans.modules.javacore.JMManager;

final class IntSet {
    private Entry[] table;
    private int size;
    private static final int LOAD_FACTOR = 2;
    private static final int GROWTH_FACTOR = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IntSet() {
        this(2048);
    }

    public IntSet(int capacity) {
        this.table = new Entry[capacity];
    }

    public boolean add(int x) {
        Entry e;
        if (this.contains(x)) {
            return false;
        }
        if (this.size > this.table.length / 2) {
            this.resize();
        }
        int h = IntSet.hash(x);
        int idx = IntSet.indexFor(h, this.table.length);
        this.table[idx] = e = new Entry(x, h, this.table[idx]);
        ++this.size;
        return true;
    }

    public boolean contains(int x) {
        int h = IntSet.hash(x);
        Entry e = this.table[IntSet.indexFor(h, this.table.length)];
        while (e != null) {
            if (e.value == x) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int[] toArray() {
        int[] arr = new int[this.size];
        int n = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                arr[n++] = e.value;
                e = e.next;
            }
        }
        if (!$assertionsDisabled && n != this.size) {
            throw new AssertionError();
        }
        return arr;
    }

    private void resize() {
        Entry[] newt = new Entry[this.table.length * 2];
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                int idx = IntSet.indexFor(e.hash, newt.length);
                Entry eNext = e.next;
                e.next = newt[idx];
                newt[idx] = e;
                e = eNext;
            }
        }
        this.table = newt;
        JMManager.getLog().log("IntSet: table doubled to " + this.table.length);
    }

    private static int hash(int h) {
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    static {
        $assertionsDisabled = !IntSet.class.desiredAssertionStatus();
    }

    static class Entry {
        int value;
        int hash;
        Entry next;

        Entry(int v, int h, Entry n) {
            this.value = v;
            this.hash = h;
            this.next = n;
        }
    }
}

