/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ProgressSupport;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ElementNavigator;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeClassImpl;
import org.openide.util.Cancellable;

public class UsageFinder {
    private NamedElement what;
    private ElementNavigator navigator;
    private Collection usages;
    private static final int MAX_COUNT = 30;
    private Set declaringClasses;
    private boolean overriders = false;
    private boolean findUsages = true;

    public UsageFinder(NamedElement what) {
        this.what = what instanceof ParameterizedType ? UsageFinder.convert((Type)this.getRealClassDefinition((ClassDefinition)((ParameterizedType)what))) : UsageFinder.convert(what);
    }

    private static List getParameters(CallableFeature f) {
        ArrayList<Type> params = new ArrayList<Type>();
        Iterator i = f.getParameters().iterator();
        while (i.hasNext()) {
            params.add(UsageFinder.convert(TypeClassImpl.getRawType(((Parameter)i.next()).getType())));
        }
        return params;
    }

    private static NamedElement convert(NamedElement what) {
        ClassDefinition cls;
        if (what instanceof TypeParameter) {
            return what;
        }
        if (what instanceof JavaClass) {
            return UsageFinder.convert((Type)((JavaClass)what));
        }
        Field convertedElement = null;
        if (what instanceof ClassMember && (cls = ((ClassMember)what).getDeclaringClass()) instanceof JavaClass) {
            JavaClass clazz = (JavaClass)UsageFinder.convert((Type)cls);
            if (clazz.equals(cls)) {
                return what;
            }
            if (what instanceof Field) {
                convertedElement = clazz.getField(what.getName(), false);
            } else if (what instanceof Method) {
                convertedElement = clazz.getMethod(what.getName(), UsageFinder.getParameters((CallableFeature)what), false);
            } else if (what instanceof Constructor) {
                convertedElement = clazz.getConstructor(UsageFinder.getParameters((CallableFeature)what), false);
            }
        }
        return convertedElement == null ? what : convertedElement;
    }

    private static Type convert(Type clazz) {
        if (clazz instanceof JavaClassImpl && ((JavaClassImpl)clazz).isTransient()) {
            return clazz;
        }
        return JavaMetamodel.getManager().getDefaultExtent().getType().resolve(clazz.getName());
    }

    public UsageFinder(CallableFeature method, boolean findUsages, boolean fromBaseClass, boolean overriders) {
        this((NamedElement)method);
        this.overriders = overriders;
        this.findUsages = findUsages;
        this.declaringClasses = new HashSet();
        ClassDefinition clazz = method.getDeclaringClass();
        this.declaringClasses.add(this.getRealClassDefinition(clazz));
        ArrayList<Type> argTypes = new ArrayList<Type>();
        Iterator i = method.getParameters().iterator();
        while (i.hasNext()) {
            argTypes.add(TypeClassImpl.getRawType(((Parameter)i.next()).getType()));
        }
        if (fromBaseClass) {
            LinkedList<ClassDefinition> q = new LinkedList<ClassDefinition>();
            q.add(clazz);
            HashSet<ClassDefinition> visited = new HashSet<ClassDefinition>();
            while (!q.isEmpty()) {
                clazz = (ClassDefinition)q.removeFirst();
                if (!visited.add(clazz)) continue;
                Object callFeature = null;
                callFeature = method instanceof Method ? clazz.getMethod(method.getName(), argTypes, false) : clazz.getConstructor(argTypes, false);
                if (callFeature != null) {
                    this.declaringClasses.add(this.getRealClassDefinition(clazz));
                }
                q.addAll(clazz.getInterfaces());
                if ((clazz = clazz.getSuperClass()) == null) continue;
                q.add(clazz);
            }
        }
    }

    private ClassDefinition getRealClassDefinition(ClassDefinition cls) {
        return (ClassDefinition)TypeClassImpl.getRawType((Type)cls);
    }

    private Collection getUsers(MetadataElement where) {
        this.usages = new ArrayList();
        ArrayList<MetadataElement> l = new ArrayList<MetadataElement>(1);
        l.add(where);
        this.getUsers(l);
        return this.usages;
    }

    public Collection getUsers(Resource[] res) {
        return new LazyCollection(res);
    }

    private void getUsers(Collection elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            MetadataElement el = (MetadataElement)((Object)iter.next());
            if (!(el instanceof Resource) && !this.navigator.containsIdentifierIn(el)) continue;
            if (this.isMatch((Element)this.what, el)) {
                this.usages.add(el);
            }
            this.getUsers(el.getChildren());
        }
    }

    private boolean isMatch(Element what, Element r) {
        if (what.equals(r)) {
            return false;
        }
        Element ref = r;
        if (this.findUsages) {
            if (ref instanceof ElementReference) {
                ref = ((ElementReference)r).getElement();
            } else if (!this.overriders) {
                return false;
            }
        }
        if (!(what instanceof Method)) {
            if (ref instanceof ParameterizedType) {
                ref = this.getRealClassDefinition((ClassDefinition)((ParameterizedType)ref));
            }
            return what.equals(ref);
        }
        if (!(ref instanceof Method)) {
            return false;
        }
        if (!this.overriders && what.equals(ref)) {
            return true;
        }
        Method m = (Method)ref;
        if (m.signatureEquals((Method)what)) {
            ClassDefinition declaringClass = this.getRealClassDefinition(m.getDeclaringClass());
            Iterator i = this.declaringClasses.iterator();
            while (i.hasNext()) {
                ClassDefinition collectedClass = (ClassDefinition)i.next();
                if (!declaringClass.isSubTypeOf(collectedClass)) continue;
                return true;
            }
        }
        return false;
    }

    private void lock() {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
    }

    private void unlock() {
        JavaMetamodel.getDefaultRepository().endTrans(false);
    }

    private class LazyIterator
    implements Iterator,
    Cancellable {
        MOFID[] res;
        Collection currentUsages = Collections.EMPTY_LIST;
        Iterator inner;
        int currentIndex;
        Object next;
        boolean hasNext;
        float step;
        int last;
        ProgressSupport progressSupport;
        private boolean cancelRequest;

        LazyIterator(MOFID[] res) {
            this.res = res;
            this.inner = this.currentUsages.iterator();
            this.currentIndex = -1;
            this.hasNext = true;
            this.step = 1.0f;
            if (res.length > 30) {
                this.step = 30.0f / (float)res.length;
            }
            this.last = 0;
            this.progressSupport = JavaMetamodel.getManager().getProgressSupport();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            UsageFinder.this.lock();
            try {
                if (this.next == null) {
                    this.findNext();
                }
                Object result = this.next;
                this.next = null;
                Object object = result;
                return object;
            }
            finally {
                UsageFinder.this.unlock();
            }
        }

        private void findNext() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            while (this.next == null && this.hasNext) {
                if (!this.inner.hasNext()) {
                    if (this.cancelRequest) {
                        return;
                    }
                    ++this.currentIndex;
                    if (this.currentIndex == 0) {
                        this.progressSupport.fireProgressListenerStart(0, Math.min(this.res.length, 30));
                    }
                    if (this.currentIndex < this.res.length) {
                        MOFID mofId = this.res[this.currentIndex];
                        if (mofId != null) {
                            ResourceImpl resource = (ResourceImpl)((NBMDRepositoryImpl)JMManager.getDefaultRepository()).getByMofId(mofId);
                            try {
                                if (resource != null && !resource.getName().endsWith("class")) {
                                    UsageFinder.this.navigator = new ElementNavigator(resource, UsageFinder.this.what);
                                    this.currentUsages = UsageFinder.this.getUsers(resource);
                                    this.inner = this.currentUsages.iterator();
                                    if (!this.inner.hasNext()) {
                                        this.res[this.currentIndex] = null;
                                    }
                                } else {
                                    this.res[this.currentIndex] = null;
                                }
                            }
                            catch (IllegalArgumentException e) {
                                JMManager.getLog().notify(1, (Throwable)new Exception("Resource " + (Object)((Object)resource) == null ? null : resource.getName() + " is not parsable.", e));
                            }
                        }
                        if ((float)this.currentIndex * this.step >= (float)this.last) {
                            this.progressSupport.fireProgressListenerStep();
                            ++this.last;
                        }
                    } else {
                        this.hasNext = false;
                        this.progressSupport.fireProgressListenerStop();
                    }
                }
                if (!this.inner.hasNext()) continue;
                this.next = this.inner.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            UsageFinder.this.lock();
            try {
                this.findNext();
                if (this.cancelRequest) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.hasNext;
                return bl;
            }
            finally {
                UsageFinder.this.unlock();
            }
        }

        public boolean cancel() {
            this.cancelRequest = true;
            return true;
        }
    }

    private class LazyCollection
    extends AbstractCollection {
        MOFID[] res;

        public LazyCollection(Resource[] res) {
            this.res = new MOFID[res.length];
            for (int i = 0; i < res.length; ++i) {
                this.res[i] = ((MetadataElement)res[i])._getMofId();
            }
        }

        public Iterator iterator() {
            return new LazyIterator(this.res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            UsageFinder.this.lock();
            try {
                int size = 0;
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    i.next();
                    ++size;
                }
                int n = size;
                return n;
            }
            finally {
                UsageFinder.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            UsageFinder.this.lock();
            try {
                boolean bl = !this.iterator().hasNext();
                return bl;
            }
            finally {
                UsageFinder.this.unlock();
            }
        }
    }
}

