/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.tag;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class TagBuilder
implements Builder {
    public static final String STATES = "T D ? ";
    public static final String CVS_SERVER = "server: ";
    public static final String EXAM_DIR = "server: ";
    private DefaultFileInfoContainer fileInfoContainer;
    private EventManager eventManager;
    private String localPath;

    public TagBuilder(EventManager eventManager, String localPath) {
        this.eventManager = eventManager;
        this.localPath = localPath;
    }

    public void outputDone() {
        if (this.fileInfoContainer != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.fileInfoContainer));
            this.fileInfoContainer = null;
        }
    }

    public void parseLine(String line, boolean isErrorMessage) {
        if (isErrorMessage) {
            return;
        }
        if (line.indexOf("server: ") < 0) {
            if (line.length() < 3) {
                return;
            }
            String firstChar = line.substring(0, 2);
            if (STATES.indexOf(firstChar) >= 0) {
                this.processFile(line);
            }
        }
    }

    private void processFile(String line) {
        if (this.fileInfoContainer == null) {
            this.fileInfoContainer = new DefaultFileInfoContainer();
        }
        this.fileInfoContainer.setType(line.substring(0, 1));
        String fileName = line.substring(2).trim();
        if (fileName.startsWith("no file")) {
            fileName = fileName.substring(8);
        }
        this.fileInfoContainer.setFile(this.createFile(fileName));
        this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.fileInfoContainer));
        this.fileInfoContainer = null;
    }

    private File createFile(String fileName) {
        return new File(this.localPath, fileName);
    }

    public void parseEnhancedMessage(String key, Object value) {
    }
}

