/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.AttributeSet;

class SimpleAttributeSet
implements AttributeSet {
    private Hashtable map = new Hashtable();
    private AttributeSet parent;

    SimpleAttributeSet() {
    }

    SimpleAttributeSet(AttributeSet as) {
        Enumeration<?> names = as.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            this.map.put(name, as.getAttribute(name));
        }
        this.parent = as.getResolveParent();
        if (this.parent != null) {
            this.parent = new SimpleAttributeSet(this.parent);
        }
    }

    public boolean containsAttribute(Object name, Object value) {
        return this.map.containsKey(name) && this.map.get(name).equals(value);
    }

    public boolean containsAttributes(AttributeSet as) {
        Enumeration<?> names = as.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (this.containsAttribute(name, as.getAttribute(name))) continue;
            return false;
        }
        return true;
    }

    public AttributeSet copyAttributes() {
        return new SimpleAttributeSet(this);
    }

    public Object getAttribute(Object name) {
        return this.map.get(name);
    }

    public int getAttributeCount() {
        return this.map.size();
    }

    public Enumeration getAttributeNames() {
        return this.map.keys();
    }

    public AttributeSet getResolveParent() {
        return this.parent;
    }

    public boolean isDefined(Object name) {
        return this.map.containsKey(name);
    }

    public boolean isEqual(AttributeSet as) {
        return this.getAttributeCount() == as.getAttributeCount() && this.containsAttributes(as);
    }

    void addAttribute(Object name, Object value) {
        this.map.put(name, value);
    }

    public String toString() {
        return super.toString() + " " + this.map.toString();
    }
}

