/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.TextAction;
import org.netbeans.lib.editor.codetemplates.CodeTemplateInsertHandler;

final class CodeTemplateOverrideAction
extends TextAction {
    public static final String ORIGINAL_ACTION_PROPERTY = "original-action";
    private static final int DEFAULT_KEY_TYPED = 0;
    private static final int TAB = 1;
    private static final int SHIFT_TAB = 2;
    private static final int ENTER = 3;
    private static final int UNDO = 4;
    private static final int REDO = 5;
    private final CodeTemplateInsertHandler handler;
    private final int actionType;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ActionMap installOverrideActionMap(JComponent component, CodeTemplateInsertHandler handler) {
        ActionMap origActionMap = component.getActionMap();
        ActionMap actionMap = new ActionMap(){

            public Action get(Object key) {
                Action retValue = super.get(key);
                return retValue;
            }
        };
        CodeTemplateOverrideAction[] actions = new CodeTemplateOverrideAction[]{new CodeTemplateOverrideAction(handler, 0), new CodeTemplateOverrideAction(handler, 1), new CodeTemplateOverrideAction(handler, 2), new CodeTemplateOverrideAction(handler, 3)};
        for (int i = actions.length - 1; i >= 0; --i) {
            CodeTemplateOverrideAction action = actions[i];
            Object actionKey = (String)action.getValue("Name");
            if (!$assertionsDisabled && actionKey == null) {
                throw new AssertionError();
            }
            actionKey = action.findActionKey(component);
            if (actionKey == null) continue;
            Action origAction = origActionMap.get(actionKey);
            action.putValue(ORIGINAL_ACTION_PROPERTY, origAction);
            actionMap.put(actionKey, action);
        }
        actionMap.setParent(origActionMap);
        component.setActionMap(actionMap);
        return origActionMap;
    }

    private static String actionType2Name(int actionType) {
        switch (actionType) {
            case 0: {
                return "default-typed";
            }
            case 1: {
                return "insert-tab";
            }
            case 2: {
                return "remove-tab";
            }
            case 3: {
                return "insert-break";
            }
            case 4: {
                return "undo";
            }
            case 5: {
                return "redo";
            }
        }
        throw new IllegalArgumentException();
    }

    private CodeTemplateOverrideAction(CodeTemplateInsertHandler handler, int actionType) {
        super(CodeTemplateOverrideAction.actionType2Name(actionType));
        this.handler = handler;
        this.actionType = actionType;
    }

    private Action getOrigAction() {
        return (Action)this.getValue(ORIGINAL_ACTION_PROPERTY);
    }

    public void actionPerformed(ActionEvent evt) {
        switch (this.actionType) {
            case 0: {
                this.handler.defaultKeyTypedAction(evt, this.getOrigAction());
                break;
            }
            case 1: {
                this.handler.tabAction(evt, this.getOrigAction());
                break;
            }
            case 2: {
                this.handler.shiftTabAction(evt);
                break;
            }
            case 3: {
                this.handler.enterAction(evt);
                break;
            }
            case 4: {
                this.handler.undoAction(evt);
                break;
            }
            case 5: {
                this.handler.redoAction(evt);
            }
        }
    }

    Object findActionKey(JComponent component) {
        KeyStroke keyStroke;
        switch (this.actionType) {
            case 0: {
                keyStroke = KeyStroke.getKeyStroke('a');
                break;
            }
            case 1: {
                keyStroke = KeyStroke.getKeyStroke(9, 0);
                break;
            }
            case 2: {
                keyStroke = KeyStroke.getKeyStroke(9, 1);
                break;
            }
            case 3: {
                keyStroke = KeyStroke.getKeyStroke(10, 0);
                break;
            }
            case 4: {
                keyStroke = KeyStroke.getKeyStroke(90, 2);
                break;
            }
            case 5: {
                keyStroke = KeyStroke.getKeyStroke(89, 2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Object key = component.getInputMap().get(keyStroke);
        return key;
    }

    static {
        $assertionsDisabled = !CodeTemplateOverrideAction.class.desiredAssertionStatus();
    }
}

