/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.websvc.wsdl.xmlutils.XMLJ2eeDataObject;
import org.netbeans.modules.websvc.wsdl.xmlutils.XMLJ2eeUtils;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public abstract class DD2beansDataObject
extends XMLJ2eeDataObject
implements CookieSet.Factory {
    private static final int DELAY_FOR_TIMER = 200;
    protected static final RequestProcessor RP = new RequestProcessor("XML Parsing");
    private RequestProcessor.Task generationTask;
    private boolean saveAfterNodeChanges;
    private Timer timer;
    private String prefixMark;
    private int numberOfStartedGens;
    ActionListener timerListener;
    private static final long serialVersionUID = -5363900668319174348L;

    public DD2beansDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        this(pf, loader, true);
    }

    public DD2beansDataObject(FileObject pf, MultiFileLoader loader, boolean saveAfterNodeChanges) throws DataObjectExistsException {
        super(pf, loader);
        this.saveAfterNodeChanges = saveAfterNodeChanges;
        this.init();
    }

    private void init() {
        this.timerListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DD2beansDataObject.this.restartGen();
            }
        };
        this.timer = new Timer(0, null);
        this.timer.addActionListener((ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.timerListener, (Object)this.timer));
        this.timer.setInitialDelay(200);
        this.timer.setRepeats(false);
    }

    private synchronized void restartTimer() {
        if (!this.timer.isRunning()) {
            ++this.numberOfStartedGens;
        }
        this.timer.restart();
    }

    protected abstract String generateDocument();

    protected final void setPrefixMark(String prefix) {
        this.prefixMark = prefix;
    }

    protected final String getPrefixMark() {
        return this.prefixMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeDirty(boolean dirty) {
        if (dirty) {
            DD2beansDataObject dD2beansDataObject = this;
            synchronized (dD2beansDataObject) {
                this.nodeDirty = true;
                this.restartTimer();
            }
        }
    }

    public RequestProcessor.Task getGenerationTask() {
        return this.generationTask;
    }

    protected void restartGen() {
        this.generationTask = null;
        this.generationTask = RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                final String newDoc = DD2beansDataObject.this.generateDocument();
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SaveCookie savec;
                            Object doc = DD2beansDataObject.this.getEditorSupport().openDocument();
                            XMLJ2eeUtils.replaceDocument(doc, newDoc, DD2beansDataObject.this.prefixMark);
                            DD2beansDataObject.this.setDocumentValid(true);
                            if (DD2beansDataObject.this.saveAfterNodeChanges && (savec = (SaveCookie)DD2beansDataObject.this.getCookie(SaveCookie.class)) != null) {
                                savec.save();
                            }
                            DD2beansDataObject.this.getEditorSupport().getUndo().discardAllEdits();
                        }
                        catch (BadLocationException e) {
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                        }
                        finally {
                            DD2beansDataObject e = DD2beansDataObject.this;
                            synchronized (e) {
                                DD2beansDataObject.this.numberOfStartedGens--;
                                if (DD2beansDataObject.this.numberOfStartedGens == 0) {
                                    DD2beansDataObject.this.nodeDirty = false;
                                }
                            }
                        }
                    }
                });
            }
        });
    }
}

