/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.api.webservices.WebServicesView;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.core.webservices.action.JaxRpcWsdlCookie;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSView;
import org.netbeans.modules.websvc.jaxws.api.JaxWsWsdlCookie;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JaxWsExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private Node selectedServiceNode = null;
    private JLabel jLblTreeView;

    public JaxWsExplorerPanel() {
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLblTreeView.setText(NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"LBL_AvailableWebServices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setBorder((Border)new EtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor((Component)this.treeView);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        Children.Array rootChildren = new Children.Array();
        AbstractNode explorerClientRoot = new AbstractNode((Children)rootChildren);
        ArrayList<ProjectNode> projectNodeList = new ArrayList<ProjectNode>();
        for (int i = 0; i < projects.length; ++i) {
            FileObject ddFolder;
            Node servicesNode;
            LogicalViewProvider logicalProvider = (LogicalViewProvider)projects[i].getLookup().lookup(LogicalViewProvider.class);
            if (logicalProvider == null) continue;
            Node rootNode = logicalProvider.createLogicalView();
            JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)projects[i].getProjectDirectory());
            if (jaxWsSupport != null && jaxWsSupport.getServices().size() > 0) {
                Node servicesNode2 = JAXWSView.getJAXWSView().createJAXWSView(projects[i]);
                if (servicesNode2 == null) continue;
                Children.Array children = new Children.Array();
                Node[] nodes = servicesNode2.getChildren().getNodes();
                if (nodes == null || nodes.length <= 0) continue;
                Node[] serviceNodes = new Node[nodes.length];
                for (int j = 0; j < nodes.length; ++j) {
                    serviceNodes[j] = new ServiceNode((JaxWsNode)nodes[j]);
                }
                children.add(serviceNodes);
                projectNodeList.add(new ProjectNode((Children)children, rootNode));
                continue;
            }
            WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)projects[i].getProjectDirectory());
            if (wsSupport == null || wsSupport.getServices().size() <= 0 || (servicesNode = WebServicesView.getWebServicesView((FileObject)(ddFolder = wsSupport.getWsDDFolder())).createWebServicesView(ddFolder)) == null) continue;
            Children.Array children = new Children.Array();
            Node[] nodes = servicesNode.getChildren().getNodes();
            if (nodes == null || nodes.length <= 0) continue;
            Node[] filterNodes = new Node[nodes.length];
            for (int j = 0; j < nodes.length; ++j) {
                filterNodes[j] = new FilterNode(nodes[j]);
            }
            children.add(filterNodes);
            projectNodeList.add(new ProjectNode((Children)children, rootNode));
        }
        Node[] projectNodes = new Node[projectNodeList.size()];
        projectNodeList.toArray(projectNodes);
        rootChildren.add(projectNodes);
        this.manager.setRootContext((Node)explorerClientRoot);
        this.descriptor.setValid(false);
    }

    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Node getSelectedService() {
        return this.selectedServiceNode;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Node[] nodes;
        if (evt.getSource() == this.manager && "selectedNodes".equals(evt.getPropertyName()) && (nodes = this.manager.getSelectedNodes()) != null && nodes.length > 0) {
            Node node = nodes[0];
            if (node.getCookie(JaxWsWsdlCookie.class) != null || node.getCookie(JaxRpcWsdlCookie.class) != null) {
                this.selectedServiceNode = node;
                this.descriptor.setValid(true);
            } else {
                this.selectedServiceNode = null;
                this.descriptor.setValid(false);
            }
        }
    }

    private class ServiceNode
    extends AbstractNode
    implements JaxWsWsdlCookie {
        private JaxWsNode serviceNode;

        ServiceNode(JaxWsNode serviceNode) {
            super(Children.LEAF);
            this.serviceNode = serviceNode;
            this.setName(serviceNode.getDisplayName());
            this.getCookieSet().add((Node.Cookie)this);
        }

        public Image getIcon(int type) {
            return this.serviceNode.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.serviceNode.getOpenedIcon(type);
        }

        public String getWsdlURL() {
            return this.serviceNode.getWsdlURL();
        }
    }

    private class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node rootNode) {
            super(children);
            this.rootNode = rootNode;
            this.setName(rootNode.getDisplayName());
        }

        public Image getIcon(int type) {
            return this.rootNode.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.rootNode.getOpenedIcon(type);
        }
    }
}

