/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.nodes;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRefHandler;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.core.webservices.action.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.core.webservices.ui.panels.MessageHandlerPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ConfigureHandlerCookieImpl
implements ConfigureHandlerCookie {
    private String serviceName;
    private Project project;
    private FileObject srcRoot;
    private WebServicesClientSupport clientSupport;

    public ConfigureHandlerCookieImpl(String serviceName, Project project, WebServicesClientSupport clientSupport, FileObject srcRoot) {
        this.serviceName = serviceName;
        this.project = project;
        this.clientSupport = clientSupport;
        this.srcRoot = srcRoot;
    }

    public void configureHandler() {
        try {
            String ddServiceName;
            FileObject ddFO = this.clientSupport.getDeploymentDescriptor();
            if (ddFO == null) {
                return;
            }
            WebApp rootDD = DDProvider.getDefault().getDDRoot(ddFO);
            final ServiceRef serviceRef = (ServiceRef)rootDD.findBeanByName("ServiceRef", "ServiceRefName", ddServiceName = "service/" + this.serviceName);
            if (serviceRef == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ConfigureHandlerCookieImpl.class, (String)"ERR_NotJSR109Client"), 2));
                return;
            }
            ServiceRefHandler[] handlers = serviceRef.getHandler();
            ArrayList<String> handlerList = new ArrayList<String>();
            for (int j = 0; j < handlers.length; ++j) {
                handlerList.add(handlers[j].getHandlerClass());
            }
            final MessageHandlerPanel panel = new MessageHandlerPanel(this.project, handlerList.toArray(new String[handlerList.size()]), false, this.serviceName);
            String title = NbBundle.getMessage(ConfigureHandlerCookieImpl.class, (String)"TTL_MessageHandlerPanel");
            DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, title, true, new ActionListener((RootInterface)rootDD, ddFO){
                final /* synthetic */ RootInterface val$rootDD;
                final /* synthetic */ FileObject val$ddFO;
                {
                    this.val$rootDD = rootInterface;
                    this.val$ddFO = fileObject;
                }

                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
                        DefaultListModel listModel = panel.getListModel();
                        try {
                            ServiceRefHandler handler;
                            for (int i = 0; i < listModel.getSize(); ++i) {
                                String className = (String)listModel.getElementAt(i);
                                if (!ConfigureHandlerCookieImpl.this.isNewHandler(className, serviceRef)) continue;
                                handler = (ServiceRefHandler)this.val$rootDD.createBean("ServiceRefHandler");
                                handler.setHandlerName(className);
                                handler.setHandlerClass(className);
                                serviceRef.addHandler(handler);
                            }
                            ServiceRefHandler[] handlers = serviceRef.getHandler();
                            for (int j = 0; j < handlers.length; ++j) {
                                handler = handlers[j];
                                String clsName = handler.getHandlerClass();
                                if (ConfigureHandlerCookieImpl.this.isInModel(clsName, listModel)) continue;
                                serviceRef.removeHandler(handler);
                            }
                            this.val$rootDD.write(this.val$ddFO);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e.getMessage());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e.getMessage());
                        }
                    }
                }
            });
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
            dialog.setVisible(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private boolean isNewHandler(String className, ServiceRef serviceRef) {
        ServiceRefHandler[] handlers = serviceRef.getHandler();
        for (int i = 0; i < handlers.length; ++i) {
            if (!handlers[i].getHandlerClass().equals(className)) continue;
            return false;
        }
        return true;
    }

    private boolean isInModel(String className, ListModel model) {
        for (int i = 0; i < model.getSize(); ++i) {
            String cls = (String)model.getElementAt(i);
            if (!className.equals(cls)) continue;
            return true;
        }
        return false;
    }
}

