/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.netbeans.updater.Localization;
import org.netbeans.updater.ModuleUpdate;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterFrame;

public final class ModuleUpdater
extends Thread {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String UPDATE_DIR = "update";
    static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    private static final String BACKUP_DIR = "update" + FILE_SEPARATOR + "backup";
    private static final String NB_LIB_DIR = "lib";
    private static final String EXT_DIR = "ext";
    private static final String JAVA_LIB_EXT_DIR = "lib" + FILE_SEPARATOR + "ext";
    public static final String UPDATE_NETBEANS_DIR = "netbeans";
    public static final String UPDATE_JAVA_EXT_DIR = "java_ext";
    public static final String UPDATE_MAIN_DIR = "main";
    private static final String JVM_PARAMS_FILE = "main.properties";
    public static final String NBM_EXTENSION = "nbm";
    public static final String LOG_FILE_NAME = "update.log";
    public static final String LATER_FILE_NAME = "install_later.xml";
    public static final char SPACE = ' ';
    public static final char QUOTE = '\"';
    private File downloadDirectory = null;
    private File backupDirectory = null;
    private File netbeansDirectory = null;
    private File nbLibDirectory = null;
    private File javaLibExtDirectory = null;
    private File updateDirectory = null;
    private File mainDirectory = null;
    private Set installOnly;
    private Set installFiles;
    private static Boolean singleMode = null;
    private volatile boolean stop = false;
    private volatile boolean suspend = false;
    private long totalLength;
    private static int instCount = 0;
    private static boolean fromInstall = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            instCount = 0;
            this.getDownloadDirectory();
            this.checkStop();
            if (this.downloadDirectory == null) {
                this.endRun();
            }
            this.checkStop();
            this.installFiles = new HashSet();
            for (File cluster : UpdateTracking.clusters(true)) {
                UpdateTracking ut = UpdateTracking.getTracking(cluster);
                if (ut == null) continue;
                this.installFiles.addAll(ut.getModulesToInstall());
            }
            if (this.installOnly != null) {
                this.installFiles.retainAll(this.installOnly);
            }
            if (this.installFiles.isEmpty()) {
                this.endRun();
            }
            this.checkStop();
            this.totalLength();
            this.checkStop();
            this.unpack();
            if (!UpdaterFrame.isFromIDE()) {
                this.deleteInstall_Later();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        finally {
            UpdaterFrame.getUpdaterFrame().unpackingFinished();
        }
    }

    private void deleteInstall_Later() {
        File later = null;
        if (ModuleUpdater.isMultiuser() && (later = new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME)).exists()) {
            later.delete();
        }
        if ((later = new File(UpdateTracking.getPlatformDir(), DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME)).exists()) {
            later.delete();
        }
    }

    void endRun() {
        this.stop = true;
    }

    private void checkStop() {
        if (this.suspend) {
            while (this.suspend) {
            }
        }
        if (this.stop) {
            UpdaterFrame.getUpdaterFrame();
            if (UpdaterFrame.isFromIDE()) {
                UpdaterFrame.getUpdaterFrame().unpackingFinished();
            } else {
                System.exit(0);
            }
        }
    }

    public void setInstallOnly(File[] files) {
        this.installOnly = new HashSet();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.installOnly.add(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void totalLength() {
        this.totalLength = 0L;
        UpdaterFrame.setLabel(Localization.getBrandedString("CTL_PreparingUnpack"));
        UpdaterFrame.setProgressRange(0L, this.installFiles.size());
        Iterator it = this.installFiles.iterator();
        for (int i = 0; i < this.installFiles.size(); ++i) {
            ZipFile jarFile = null;
            try {
                UpdaterFrame.setProgressValue(i + 1);
                jarFile = new JarFile((File)it.next());
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    this.checkStop();
                    if (!entry.getName().startsWith(UPDATE_NETBEANS_DIR) && !entry.getName().startsWith(UPDATE_JAVA_EXT_DIR) && !entry.getName().startsWith(UPDATE_MAIN_DIR) || entry.isDirectory()) continue;
                    this.totalLength += entry.getSize();
                }
                continue;
            }
            catch (IOException e) {
                continue;
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpack() {
        UpdateTracking.Version version;
        UpdateTracking.Module modtrack;
        long bytesRead = 0L;
        UpdaterFrame.setLabel("");
        UpdaterFrame.setProgressRange(0L, this.totalLength);
        fromInstall = true;
        ArrayList<UpdateTracking> allTrackings = new ArrayList<UpdateTracking>();
        HashMap<ModuleUpdate, UpdateTracking.Version> l10ns = new HashMap<ModuleUpdate, UpdateTracking.Version>();
        List clusters = UpdateTracking.clusters(true);
        for (File cluster : clusters) {
            UpdateTracking tracking = UpdateTracking.getTracking(cluster, false);
            if (tracking == null) continue;
            allTrackings.add(tracking);
            HashSet nbms = new HashSet(tracking.getModulesToInstall());
            nbms.retainAll(this.installFiles);
            File[] nbmFiles = nbms.toArray(new File[0]);
            for (int i = 0; i < nbmFiles.length; ++i) {
                ModuleUpdate mu = null;
                try {
                    mu = new ModuleUpdate(nbmFiles[i], fromInstall);
                }
                catch (RuntimeException re) {
                    if (!nbmFiles[i].exists() || nbmFiles[i].delete()) continue;
                    System.out.println("Error: File " + nbmFiles[i] + " cannot be deleted. Propably file lock on the file.");
                    assert (false) : "Error: File " + nbmFiles[i] + " cannot be deleted. Propably file lock on the file.";
                    nbmFiles[i].deleteOnExit();
                    continue;
                }
                assert (mu != null) : "Module update is not null for file: " + nbmFiles[i];
                if (mu.isL10n()) {
                    modtrack = null;
                    version = tracking.createVersion("0");
                    l10ns.put(mu, version);
                } else {
                    modtrack = tracking.readModuleTracking(!fromInstall, mu.getCodenamebase(), true);
                    version = modtrack.addNewVersion(mu.getSpecification_version());
                }
                System.gc();
                boolean hasMainClass = false;
                UpdaterFrame.setLabel(Localization.getBrandedString("CTL_UnpackingFile") + "  " + nbmFiles[i].getName());
                UpdaterFrame.setProgressValue(bytesRead);
                JarFile jarFile = null;
                try {
                    MainConfig mconfig;
                    jarFile = new JarFile(nbmFiles[i]);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        File destFile;
                        JarEntry entry = entries.nextElement();
                        this.checkStop();
                        if (entry.getName().startsWith(UPDATE_NETBEANS_DIR)) {
                            if (entry.isDirectory()) {
                                File newBckDir;
                                File newDir = new File(this.getNetbeansDirectory(), entry.getName().substring(UPDATE_NETBEANS_DIR.length()));
                                if (!newDir.isDirectory()) {
                                    newDir.mkdirs();
                                }
                                if ((newBckDir = new File(this.getBackupDirectory(), entry.getName())).isDirectory()) continue;
                                newBckDir.mkdirs();
                                continue;
                            }
                            String pathTo = entry.getName().substring(9);
                            if (mu.isL10n()) {
                                version.addL10NFileWithCrc(pathTo, Long.toString(entry.getCrc()), mu.getSpecification_version());
                            } else {
                                version.addFileWithCrc(pathTo, Long.toString(entry.getCrc()));
                            }
                            File destFile2 = new File(cluster, entry.getName().substring(UPDATE_NETBEANS_DIR.length()));
                            if (destFile2.exists()) {
                                File bckFile = new File(this.getBackupDirectory(), entry.getName());
                                bckFile.getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream(destFile2), new FileOutputStream(bckFile), -1L);
                            } else {
                                destFile2.getParentFile().mkdirs();
                            }
                            bytesRead = this.copyStreams(jarFile.getInputStream(entry), new FileOutputStream(destFile2), bytesRead);
                            UpdaterFrame.setProgressValue(bytesRead);
                            continue;
                        }
                        if (entry.getName().startsWith(UPDATE_JAVA_EXT_DIR) && !entry.isDirectory()) {
                            destFile = new File(this.getJavaLibExtDirectory(), entry.getName().substring(UPDATE_JAVA_EXT_DIR.length()));
                            if (destFile.exists()) {
                                File bckFile = new File(this.getBackupDirectory(), UPDATE_JAVA_EXT_DIR + FILE_SEPARATOR + entry.getName().substring(UPDATE_NETBEANS_DIR.length()));
                                bckFile.getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream(destFile), new FileOutputStream(bckFile), -1L);
                            } else {
                                destFile.getParentFile().mkdirs();
                            }
                            bytesRead = this.copyStreams(jarFile.getInputStream(entry), new FileOutputStream(destFile), bytesRead);
                            UpdaterFrame.setProgressValue(bytesRead);
                            continue;
                        }
                        if (!entry.getName().startsWith(UPDATE_MAIN_DIR) || entry.isDirectory()) continue;
                        destFile = new File(this.getMainDirectory(), entry.getName().substring(UPDATE_MAIN_DIR.length() + 1));
                        destFile.getParentFile().mkdirs();
                        hasMainClass = true;
                        bytesRead = this.copyStreams(jarFile.getInputStream(entry), new FileOutputStream(destFile), bytesRead);
                        UpdaterFrame.setProgressValue(bytesRead);
                    }
                    if (hasMainClass && (mconfig = new MainConfig(this.getMainDirString() + FILE_SEPARATOR + JVM_PARAMS_FILE)).isValid()) {
                        String java_path = System.getProperty("java.home") + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "java";
                        java_path = ModuleUpdater.quoteString(java_path);
                        String torun = java_path + " -cp " + ModuleUpdater.quoteString(this.getMainDirString() + mconfig.getClasspath()) + mconfig.getCommand();
                        this.startCommand(torun);
                        this.deleteDir(this.getMainDirectory());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException e) {}
                    if (!nbmFiles[i].delete()) {
                        System.out.println("Error: Cannot delete " + nbmFiles[i]);
                        assert (false) : "Cannot delete " + nbmFiles[i];
                        nbmFiles[i].deleteOnExit();
                    }
                }
                if (mu.isL10n()) continue;
                modtrack.write();
                modtrack.writeConfigModuleXMLIfMissing();
            }
        }
        for (UpdateTracking t : allTrackings) {
            for (Map.Entry entry : l10ns.entrySet()) {
                ModuleUpdate mod = (ModuleUpdate)entry.getKey();
                version = (UpdateTracking.Version)entry.getValue();
                modtrack = t.readModuleTracking(!mod.isFromInstall(), mod.getCodenamebase(), true);
                modtrack.addL10NVersion(version);
                modtrack.write();
            }
            t.deleteUnusedFiles();
        }
    }

    public File getUpdateDirectory() {
        if (this.updateDirectory == null) {
            this.updateDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + UPDATE_DIR) : new File(UpdateTracking.getPlatformDir(), UPDATE_DIR);
            if (!this.updateDirectory.isDirectory()) {
                this.updateDirectory.mkdirs();
            }
        }
        return this.updateDirectory;
    }

    private File getInstallDownloadDirectory() {
        File idir = new File(UpdateTracking.getPlatformDir(), DOWNLOAD_DIR);
        if (!idir.isDirectory()) {
            idir.mkdirs();
        }
        return idir;
    }

    private File getDownloadDirectory() {
        if (this.downloadDirectory == null) {
            this.downloadDirectory = new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + DOWNLOAD_DIR);
        }
        return this.downloadDirectory;
    }

    private void startCommand(String torun) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proces;
            final Process proc2 = proces = runtime.exec(ModuleUpdater.parseParameters(torun));
            new Thread(){

                public void run() {
                    try {
                        String vystup;
                        InputStreamReader stream = new InputStreamReader(proc2.getErrorStream());
                        BufferedReader reader = new BufferedReader(stream);
                        do {
                            if ((vystup = reader.readLine()) == null) continue;
                            System.out.println(vystup);
                        } while (vystup != null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            int x = proces.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File getBackupDirectory() {
        if (this.backupDirectory == null) {
            this.backupDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + BACKUP_DIR) : new File(UpdateTracking.getPlatformDir(), BACKUP_DIR);
            if (!this.backupDirectory.isDirectory()) {
                this.backupDirectory.mkdirs();
            }
        }
        return this.backupDirectory;
    }

    public File getNetbeansDirectory() {
        if (this.netbeansDirectory == null) {
            this.netbeansDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user")) : UpdateTracking.getPlatformDir();
        }
        return this.netbeansDirectory;
    }

    private File getMainDirectory() {
        if (this.mainDirectory == null) {
            this.mainDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + UPDATE_DIR + FILE_SEPARATOR + UPDATE_MAIN_DIR) : new File(UpdateTracking.getPlatformDir(), FILE_SEPARATOR + UPDATE_DIR + FILE_SEPARATOR + UPDATE_MAIN_DIR);
        }
        return this.mainDirectory;
    }

    private String getMainDirString() {
        return this.getMainDirectory().getPath();
    }

    public static final String quoteString(String s) {
        if (s.indexOf(32) > -1) {
            StringBuffer sb = new StringBuffer(s);
            int i = 0;
            while (i < sb.length()) {
                if (sb.charAt(i) == '\"') {
                    sb.deleteCharAt(i);
                    continue;
                }
                ++i;
            }
            sb.insert(0, '\"');
            sb.append('\"');
            return sb.toString();
        }
        return s;
    }

    public File getNbLibDirectory() {
        File nbLibExt;
        if (this.nbLibDirectory == null) {
            this.nbLibDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + NB_LIB_DIR) : new File(UpdateTracking.getPlatformDir(), NB_LIB_DIR);
        }
        if (!(nbLibExt = new File(this.nbLibDirectory, EXT_DIR)).isDirectory()) {
            nbLibExt.mkdirs();
        }
        return this.nbLibDirectory;
    }

    public File getJavaLibExtDirectory() {
        if (this.javaLibExtDirectory == null) {
            this.javaLibExtDirectory = new File(System.getProperty("java.home") + FILE_SEPARATOR + JAVA_LIB_EXT_DIR);
        }
        if (ModuleUpdater.canWrite(this.javaLibExtDirectory, true)) {
            return this.javaLibExtDirectory;
        }
        return this.getNbLibDirectory();
    }

    private static boolean isMultiuser() {
        if (fromInstall) {
            return false;
        }
        return !ModuleUpdater.singleMode();
    }

    private static boolean singleMode() {
        if (singleMode == null) {
            singleMode = Boolean.FALSE;
            if (System.getProperty("netbeans.user") == null) {
                singleMode = Boolean.TRUE;
            } else {
                File instDir;
                File userDir = new File(System.getProperty("netbeans.user"));
                if (userDir.equals(instDir = UpdateTracking.getPlatformDir())) {
                    singleMode = Boolean.TRUE;
                } else {
                    try {
                        if (userDir.getCanonicalPath().equals(instDir.getCanonicalPath())) {
                            singleMode = Boolean.TRUE;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return singleMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyStreams(InputStream src, OutputStream dest, long progressVal) throws IOException {
        BufferedInputStream bsrc = new BufferedInputStream(src);
        BufferedOutputStream bdest = new BufferedOutputStream(dest);
        int count = 0;
        try {
            int c;
            while ((c = bsrc.read()) != -1) {
                bdest.write(c);
                if (++count <= 8500) continue;
                if (progressVal >= 0L) {
                    UpdaterFrame.setProgressValue(progressVal += (long)count);
                }
                count = 0;
                this.checkStop();
            }
            if (progressVal >= 0L) {
                progressVal += (long)count;
            }
        }
        finally {
            bsrc.close();
            bdest.close();
        }
        return progressVal;
    }

    private static boolean canWrite(File dir, boolean create) {
        if (!dir.exists() && create) {
            dir.mkdirs();
        }
        if (!dir.isDirectory() || !dir.canWrite()) {
            return false;
        }
        File tmp = null;
        try {
            tmp = File.createTempFile("test", "access", dir);
        }
        catch (IOException e) {
            return false;
        }
        if (tmp == null) {
            return false;
        }
        boolean cw = tmp.canWrite();
        if (cw) {
            tmp.delete();
        }
        return cw;
    }

    private void deleteDir(File dir) {
        File[] files = dir.listFiles();
        for (int j = 0; j < files.length; ++j) {
            if (!files[j].isDirectory()) continue;
            this.deleteDir(files[j]);
            if (files[j].delete()) continue;
            System.out.println("Error: Cannot delete " + files[j]);
            assert (false) : "Cannot delete " + files[j];
        }
    }

    private String getLogPath() {
        return this.getUpdateDirectory().getPath() + FILE_SEPARATOR + LOG_FILE_NAME;
    }

    private static String[] parseParameters(String s) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        Vector<String> params = new Vector<String>(5, 5);
        int state = NULL;
        StringBuffer buff = new StringBuffer(20);
        int slength = s.length();
        for (int i = 0; i < slength; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (state == NULL) {
                    if (buff.length() <= 0) continue;
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    continue;
                }
                if (state == STICK) {
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\\');
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    state = INPARAM;
                    buff.append('\\');
                    buff.append(c);
                    continue;
                }
                buff.append(c);
                continue;
            }
            if (c == '\\') {
                if (state == NULL) {
                    if (++i < slength) {
                        char cc = s.charAt(i);
                        if (cc == '\"' || cc == '\\') {
                            buff.append(cc);
                            continue;
                        }
                        if (Character.isWhitespace(cc)) {
                            buff.append(c);
                            --i;
                            continue;
                        }
                        buff.append(c);
                        buff.append(cc);
                        continue;
                    }
                    buff.append('\\');
                    break;
                }
                if (state == INPARAM) {
                    state = INPARAMPENDING;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                    continue;
                }
                if (state == STICK) {
                    state = STICKPENDING;
                    continue;
                }
                if (state != STICKPENDING) continue;
                buff.append('\\');
                state = STICK;
                continue;
            }
            if (c == '\"') {
                if (state == NULL) {
                    state = INPARAM;
                    continue;
                }
                if (state == INPARAM) {
                    state = STICK;
                    continue;
                }
                if (state == STICK) {
                    state = INPARAM;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\"');
                    state = STICK;
                    continue;
                }
                buff.append('\"');
                state = INPARAM;
                continue;
            }
            if (state == INPARAMPENDING) {
                buff.append('\\');
                state = INPARAM;
            } else if (state == STICKPENDING) {
                buff.append('\\');
                state = STICK;
            }
            buff.append(c);
        }
        if (state == INPARAM) {
            params.addElement(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.addElement(buff.toString());
        } else if (buff.length() != 0) {
            params.addElement(buff.toString());
        }
        Object[] ret = new String[params.size()];
        params.copyInto(ret);
        return ret;
    }

    class MainConfig {
        private final String PAR_MAIN = "mainClass";
        private final String PAR_RELCP = "relativeClassPath";
        private final String PAR_JVMPAR = "jvm.parameters";
        private final String PAR_MAINARGS = "mainClass.arguments";
        private final String VAR_IDE_HOME = "%IDE_HOME%";
        private final String VAR_IDE_USER = "%IDE_USER%";
        private final String VAR_FILE_SEPARATOR = "%FS%";
        private final String VAR_JAVA_HOME = "%JAVA_HOME%";
        private final String VAR_ICON_ROOT = "%ICON_ROOT%";
        private final String ICON_ROOT = "Forte for Java";
        private final String VAR_LOGFILE = "%UPDATE_LOGFILE%";
        private String parameters = "";
        private String classpath = "";
        private boolean valid = false;

        public MainConfig(String spath) {
            this.valid = this.readParms(spath);
        }

        public String getCommand() {
            return this.parameters;
        }

        public String getClasspath() {
            return this.classpath;
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readParms(String spath) {
            String mainclass;
            Properties details = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(spath);
                details.load(fis);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
            String relpath = details.getProperty("relativeClassPath", null);
            if (relpath != null) {
                relpath = this.replaceVars(relpath);
                StringTokenizer token = new StringTokenizer(relpath, PATH_SEPARATOR, false);
                while (token.hasMoreTokens()) {
                    this.classpath = this.classpath + PATH_SEPARATOR + this.changeRelative(token.nextToken());
                }
            }
            this.parameters = "";
            String jvmparms = details.getProperty("jvm.parameters", null);
            if (jvmparms != null) {
                this.parameters = this.parameters + " " + jvmparms;
            }
            if ((mainclass = details.getProperty("mainClass", null)) == null) {
                return false;
            }
            this.parameters = this.parameters + " " + mainclass;
            String mainargs = details.getProperty("mainClass.arguments", null);
            if (mainargs != null) {
                this.parameters = this.parameters + " " + mainargs;
            }
            this.parameters = this.replaceVars(this.parameters);
            return true;
        }

        private String replaceVars(String original) {
            original = this.replaceAll(original, "%IDE_HOME%", UpdateTracking.getPlatformDir().getPath());
            original = this.replaceAll(original, "%IDE_USER%", ModuleUpdater.this.getNetbeansDirectory().getPath());
            MainConfig mainConfig = this;
            original = this.replaceAll(original, "%FS%", FILE_SEPARATOR);
            original = this.replaceAll(original, "%JAVA_HOME%", System.getProperty("java.home"));
            original = this.replaceAll(original, "%ICON_ROOT%", this.getIconRoot());
            original = this.replaceAll(original, "%UPDATE_LOGFILE%", ModuleUpdater.this.getLogPath());
            return original;
        }

        private String changeRelative(String path) {
            if (new File(path).isAbsolute()) {
                return path;
            }
            return ModuleUpdater.this.getMainDirString() + FILE_SEPARATOR + path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getIconRoot() {
            String ret;
            Properties prop = new Properties();
            FileInputStream fis = null;
            try {
                File propf = new File(UpdateTracking.getPlatformDir(), FILE_SEPARATOR + "system" + FILE_SEPARATOR + "product.properties");
                fis = new FileInputStream(propf);
                prop.load(fis);
                ret = prop.getProperty("start.menu.icon.root");
                if (ret == null) {
                    ret = this.getDefaultIconRoot();
                }
            }
            catch (IOException e) {
                ret = this.getDefaultIconRoot();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
            return '\"' + ret + '\"';
        }

        private String getDefaultIconRoot() {
            String s = Localization.getBranding();
            String ext = "";
            if (s != null) {
                if (s.indexOf("_ce") > 0) {
                    ext = " CE";
                } else if (s.indexOf("_ie") > 0) {
                    ext = " IE";
                } else if (s.indexOf("_ee") > 0) {
                    ext = " EE";
                }
            }
            return "Forte for Java" + ext;
        }

        private String replaceAll(String sin, String what, String repl) {
            StringBuffer sb = new StringBuffer(sin);
            int i = sb.toString().indexOf(what);
            int len = what.length();
            while (i > -1) {
                sb.replace(i, i + len, repl);
                i = sb.toString().indexOf(what, i + 1);
            }
            return sb.toString();
        }
    }
}

